/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server.locale;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class GWTLocaleHeaderFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CharResponseWrapper wrappedResponse = this.getWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)wrappedResponse);
        Locale locale = this.getLocale(request);
        String injectedScript = "<meta name=\"gwt:property\" content=\"locale=" + locale.toString() + "\">";
        Document document = Jsoup.parse((String)wrappedResponse.toString());
        document.head().append(injectedScript);
        String output = document.html();
        byte[] outputBytes = output.getBytes("UTF-8");
        response.setContentLength(outputBytes.length);
        response.getOutputStream().write(outputBytes);
    }

    protected CharResponseWrapper getWrapper(HttpServletResponse response) {
        return new CharResponseWrapper(response);
    }

    private Locale getLocale(ServletRequest request) {
        Locale locale = null;
        try {
            locale = new Locale(request.getParameter("locale"));
        }
        catch (Exception e) {
            locale = request.getLocale();
        }
        return locale;
    }

    static class CharResponseWrapper
    extends HttpServletResponseWrapper {
        protected CharArrayWriter charWriter = new CharArrayWriter();
        protected ServletOutputStream outputStream = new ServletOutputStream(){

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
            }

            public void write(int b) throws IOException {
                charWriter.write(b);
            }
        };
        protected PrintWriter writer = new PrintWriter(this.charWriter);

        public CharResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.outputStream;
        }

        public PrintWriter getWriter() throws IOException {
            return this.writer;
        }

        public void flushBuffer() throws IOException {
        }

        public String toString() {
            return this.charWriter.toString();
        }
    }
}

