/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.plugin.PluginRegistry;
import org.uberfire.workbench.events.PluginAddedEvent;
import org.uberfire.workbench.events.PluginUpdatedEvent;
import org.uberfire.workbench.events.PluginsReloadedEvent;

@Dependent
public class GwtRuntimePluginLoader {
    private static final Logger LOG = LoggerFactory.getLogger(GwtRuntimePluginLoader.class);
    private PluginRegistry pluginRegistry;
    private Event<PluginAddedEvent> pluginAddedEvent;
    private Event<PluginUpdatedEvent> pluginUpdatedEvent;
    private Event<PluginsReloadedEvent> pluginsReloadedEvent;
    private String pluginDir;
    private String pluginDeploymentUrlPath;
    private String pluginDeploymentDir;

    @Inject
    public GwtRuntimePluginLoader(Event<PluginAddedEvent> pluginAddedEvent, Event<PluginUpdatedEvent> pluginUpdatedEvent, Event<PluginsReloadedEvent> pluginsReloadedEvent) {
        this.pluginAddedEvent = pluginAddedEvent;
        this.pluginUpdatedEvent = pluginUpdatedEvent;
        this.pluginsReloadedEvent = pluginsReloadedEvent;
    }

    public void init(String contextRootDir, String pluginDir, String pluginDeploymentDir, PluginRegistry pluginRegistry) throws IOException {
        this.pluginDeploymentUrlPath = StringUtils.substringAfterLast((String)pluginDeploymentDir, (String)File.separator);
        this.pluginDeploymentDir = pluginDeploymentDir;
        this.pluginDir = pluginDir;
        this.pluginRegistry = pluginRegistry;
        this.loadPlugins();
    }

    void loadPlugins() throws IOException {
        this.pluginRegistry.removeAll();
        File pluginRoot = new File(this.pluginDir);
        if (pluginRoot.exists()) {
            Collection deployedPlugins = FileUtils.listFiles((File)pluginRoot, (String[])new String[]{"jar"}, (boolean)false);
            deployedPlugins.forEach(p -> this.loadPlugin(Paths.get(p.getAbsolutePath(), new String[0]), false));
        }
    }

    public void reload() throws IOException {
        this.loadPlugins();
        this.pluginsReloadedEvent.fire((Object)new PluginsReloadedEvent());
    }

    public void loadPlugin(Path path, boolean notifyClients) {
        String pluginJs = this.processPluginJar(this.pluginDir + File.separator + path.toFile().getName());
        if (pluginJs != null) {
            String pluginDisplayName = pluginJs.replace(".nocache.js", "");
            if (!this.pluginRegistry.isRegistered(pluginJs)) {
                String url = this.pluginDeploymentUrlPath + "/" + pluginJs + "?nocache=" + System.currentTimeMillis();
                this.pluginRegistry.add(pluginJs, url);
                if (notifyClients) {
                    this.pluginAddedEvent.fire((Object)new PluginAddedEvent(pluginDisplayName));
                }
            } else if (notifyClients) {
                this.pluginUpdatedEvent.fire((Object)new PluginUpdatedEvent(pluginDisplayName));
            }
        } else {
            LOG.warn("Deployed plugin " + path.toFile().getName() + " does not contain a nocache.js file!");
        }
    }

    String processPluginJar(String jarFileName) {
        String pluginScriptFileName = null;
        try (JarFile jar = new JarFile(jarFileName);){
            Enumeration<JarEntry> enumEntries = jar.entries();
            while (enumEntries.hasMoreElements()) {
                JarEntry file = enumEntries.nextElement();
                String fileName = StringUtils.substringAfterLast((String)file.getName(), (String)File.separator);
                if (!fileName.endsWith("cache.js")) continue;
                File f = new File(this.pluginDeploymentDir + File.separator + fileName);
                try (InputStream is = jar.getInputStream(file);
                     FileOutputStream fos = new FileOutputStream(f);){
                    while (is.available() > 0) {
                        fos.write(is.read());
                    }
                }
                if (!file.getName().endsWith("nocache.js")) continue;
                pluginScriptFileName = fileName;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return pluginScriptFileName;
    }
}

