/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.uberfire.annotations.processors.AbstractGenerator;
import org.uberfire.annotations.processors.GeneratorUtils;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;
import org.uberfire.relocated.freemarker.template.Template;
import org.uberfire.relocated.freemarker.template.TemplateException;

public class ScreenActivityGenerator
extends AbstractGenerator {
    @Override
    public StringBuffer generate(String packageName, PackageElement packageElement, String className, Element element, ProcessingEnvironment processingEnvironment) throws GenerationException {
        String onStartup1ParameterMethodName;
        String onStartup0ParameterMethodName;
        Messager messager = processingEnvironment.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Starting code generation for [" + className + "]");
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeElement classElement = (TypeElement)element;
        String annotationName = ClientAPIModule.getWorkbenchScreenClass();
        boolean isDynamic = ClientAPIModule.getWbScreenIsDynamicValueOnClass(classElement);
        String identifier = null;
        Integer preferredHeight = null;
        Integer preferredWidth = null;
        for (AnnotationMirror annotationMirror : classElement.getAnnotationMirrors()) {
            if (!annotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                int _preferredWidth;
                AnnotationValue aval = entry.getValue();
                if ("identifier".equals(entry.getKey().getSimpleName().toString())) {
                    identifier = aval.getValue().toString();
                    continue;
                }
                if ("preferredHeight".equals(entry.getKey().getSimpleName().toString())) {
                    int _preferredHeight = (Integer)aval.getValue();
                    if (_preferredHeight <= 0) continue;
                    preferredHeight = _preferredHeight;
                    continue;
                }
                if (!"preferredWidth".equals(entry.getKey().getSimpleName().toString()) || (_preferredWidth = ((Integer)aval.getValue()).intValue()) <= 0) continue;
                preferredWidth = _preferredWidth;
            }
        }
        String owningPlace = GeneratorUtils.getOwningPerspectivePlaceRequest(classElement, processingEnvironment);
        String string = GeneratorUtils.getBeanActivatorClassName(classElement, processingEnvironment);
        ExecutableElement onStartupMethod = GeneratorUtils.getOnStartupMethodForNonEditors(classElement, processingEnvironment);
        if (onStartupMethod == null) {
            onStartup0ParameterMethodName = null;
            onStartup1ParameterMethodName = null;
        } else if (onStartupMethod.getParameters().isEmpty()) {
            onStartup0ParameterMethodName = onStartupMethod.getSimpleName().toString();
            onStartup1ParameterMethodName = null;
        } else {
            onStartup0ParameterMethodName = null;
            onStartup1ParameterMethodName = onStartupMethod.getSimpleName().toString();
        }
        String onMayCloseMethodName = GeneratorUtils.getOnMayCloseMethodName(classElement, processingEnvironment);
        String onCloseMethodName = GeneratorUtils.getOnCloseMethodName(classElement, processingEnvironment);
        String onShutdownMethodName = GeneratorUtils.getOnShutdownMethodName(classElement, processingEnvironment);
        String onOpenMethodName = GeneratorUtils.getOnOpenMethodName(classElement, processingEnvironment);
        String onLostFocusMethodName = GeneratorUtils.getOnLostFocusMethodName(classElement, processingEnvironment);
        String onFocusMethodName = GeneratorUtils.getOnFocusMethodName(classElement, processingEnvironment);
        String getDefaultPositionMethodName = GeneratorUtils.getDefaultPositionMethodName(classElement, processingEnvironment);
        String getTitleMethodName = GeneratorUtils.getTitleMethodName(classElement, processingEnvironment);
        String getContextIdMethodName = GeneratorUtils.getContextIdMethodName(classElement, processingEnvironment);
        ExecutableElement getTitleWidgetMethod = GeneratorUtils.getTitleWidgetMethodName(classElement, processingEnvironment);
        String getTitleWidgetMethodName = getTitleWidgetMethod == null ? null : getTitleWidgetMethod.getSimpleName().toString();
        boolean isTitleWidgetMethodReturnTypeElement = getTitleWidgetMethod != null && GeneratorUtils.getIsElement(getTitleWidgetMethod.getReturnType(), processingEnvironment);
        ExecutableElement getWidgetMethod = GeneratorUtils.getWidgetMethodName(classElement, processingEnvironment);
        String getWidgetMethodName = getWidgetMethod == null ? null : getWidgetMethod.getSimpleName().toString();
        boolean isWidgetMethodReturnTypeElement = getWidgetMethod != null && GeneratorUtils.getIsElement(getWidgetMethod.getReturnType(), processingEnvironment);
        boolean hasUberView = GeneratorUtils.hasUberViewReference(classElement, processingEnvironment, getWidgetMethod);
        boolean hasUberElement = GeneratorUtils.hasUberElementReference(classElement, processingEnvironment, getWidgetMethod);
        boolean isWidget = GeneratorUtils.getIsWidget(classElement, processingEnvironment);
        String getMenuBarMethodName = GeneratorUtils.getMenuBarMethodName(classElement, processingEnvironment);
        String getToolBarMethodName = GeneratorUtils.getToolBarMethodName(classElement, processingEnvironment);
        boolean needsElementWrapper = isWidgetMethodReturnTypeElement || isTitleWidgetMethodReturnTypeElement;
        List<String> qualifiers = GeneratorUtils.getAllQualifiersDeclarationFromType(classElement);
        if (GeneratorUtils.debugLoggingEnabled()) {
            messager.printMessage(Diagnostic.Kind.NOTE, "Package name: " + packageName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Class name: " + className);
            messager.printMessage(Diagnostic.Kind.NOTE, "Identifier: " + identifier);
            messager.printMessage(Diagnostic.Kind.NOTE, "Owning Perspective Identifier: " + owningPlace);
            messager.printMessage(Diagnostic.Kind.NOTE, "Preferred Height: " + preferredHeight);
            messager.printMessage(Diagnostic.Kind.NOTE, "Preferred Width: " + preferredWidth);
            messager.printMessage(Diagnostic.Kind.NOTE, "getContextIdMethodName: " + getContextIdMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onStartup0ParameterMethodName: " + onStartup0ParameterMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onStartup1ParameterMethodName: " + onStartup1ParameterMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onMayCloseMethodName: " + onMayCloseMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onCloseMethodName: " + onCloseMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onShutdownMethodName: " + onShutdownMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onOpenMethodName: " + onOpenMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onLostFocusMethodName: " + onLostFocusMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onFocusMethodName: " + onFocusMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getDefaultPositionMethodName: " + getDefaultPositionMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getTitleMethodName: " + getTitleMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getTitleWidgetMethodName: " + getTitleWidgetMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "isTitleWidgetMethodReturnTypeElement: " + isTitleWidgetMethodReturnTypeElement);
            messager.printMessage(Diagnostic.Kind.NOTE, "getWidgetMethodName: " + getWidgetMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "isWidgetMethodReturnTypeElement: " + isWidgetMethodReturnTypeElement);
            messager.printMessage(Diagnostic.Kind.NOTE, "isWidget: " + Boolean.toString(isWidget));
            messager.printMessage(Diagnostic.Kind.NOTE, "hasUberView: " + Boolean.toString(hasUberView));
            messager.printMessage(Diagnostic.Kind.NOTE, "hasUberElement: " + Boolean.toString(hasUberElement));
            messager.printMessage(Diagnostic.Kind.NOTE, "needsElementWrapper: " + Boolean.toString(needsElementWrapper));
            messager.printMessage(Diagnostic.Kind.NOTE, "getMenuBarMethodName: " + getMenuBarMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getToolBarMethodName: " + getToolBarMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Qualifiers: " + String.join((CharSequence)", ", qualifiers));
        }
        if (!isWidget && getWidgetMethodName == null) {
            throw new GenerationException("The WorkbenchScreen must either extend IsWidget or provide a @WorkbenchPartView annotated method to return a com.google.gwt.user.client.ui.IsWidget or preferably org.jboss.errai.common.client.api.IsElement.", packageName + "." + className);
        }
        if (isWidget && getWidgetMethodName != null) {
            String msg = "The WorkbenchScreen both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.";
            messager.printMessage(Diagnostic.Kind.WARNING, "The WorkbenchScreen both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.", classElement);
        }
        if (getTitleMethodName == null) {
            throw new GenerationException("The WorkbenchScreen must provide a @WorkbenchPartTitle annotated method to return a java.lang.String.", packageName + "." + className);
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("packageName", packageName);
        root.put("className", className);
        root.put("identifier", identifier);
        root.put("owningPlace", owningPlace);
        root.put("preferredHeight", preferredHeight);
        root.put("preferredWidth", preferredWidth);
        root.put("getContextIdMethodName", getContextIdMethodName);
        root.put("realClassName", classElement.getSimpleName().toString());
        root.put("beanActivatorClass", string);
        root.put("onStartup0ParameterMethodName", onStartup0ParameterMethodName);
        root.put("onStartup1ParameterMethodName", onStartup1ParameterMethodName);
        root.put("onMayCloseMethodName", onMayCloseMethodName);
        root.put("onCloseMethodName", onCloseMethodName);
        root.put("onShutdownMethodName", onShutdownMethodName);
        root.put("onOpenMethodName", onOpenMethodName);
        root.put("onLostFocusMethodName", onLostFocusMethodName);
        root.put("onFocusMethodName", onFocusMethodName);
        root.put("getDefaultPositionMethodName", getDefaultPositionMethodName);
        root.put("getTitleMethodName", getTitleMethodName);
        root.put("getTitleWidgetMethodName", getTitleWidgetMethodName);
        root.put("isTitleWidgetMethodReturnTypeElement", isTitleWidgetMethodReturnTypeElement);
        root.put("getWidgetMethodName", getWidgetMethodName);
        root.put("isWidgetMethodReturnTypeElement", isWidgetMethodReturnTypeElement);
        root.put("isWidget", isWidget);
        root.put("hasUberView", hasUberView);
        root.put("hasUberElement", hasUberElement);
        root.put("needsElementWrapper", needsElementWrapper);
        root.put("getMenuBarMethodName", getMenuBarMethodName);
        root.put("getToolBarMethodName", getToolBarMethodName);
        root.put("isDynamic", isDynamic);
        root.put("qualifiers", qualifiers);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = this.config.getTemplate("activityScreen.ftl");
            template.process(root, bw);
        }
        catch (IOException ioe) {
            throw new GenerationException(ioe);
        }
        catch (TemplateException te) {
            throw new GenerationException(te);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException(ioe);
            }
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "Successfully generated code for [" + className + "]");
        return sw.getBuffer();
    }
}

