/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.helix.ZNRecordDelta;
import org.apache.log4j.Logger;

public class HelixProperty {
    private static Logger LOG = Logger.getLogger(HelixProperty.class);
    protected final ZNRecord _record;

    public HelixProperty(String id) {
        this._record = new ZNRecord(id);
    }

    public HelixProperty(ZNRecord record) {
        this._record = new ZNRecord(record);
    }

    public final String getId() {
        return this._record.getId();
    }

    public final ZNRecord getRecord() {
        return this._record;
    }

    public final void setDeltaList(List<ZNRecordDelta> deltaList) {
        this._record.setDeltaList(deltaList);
    }

    public String toString() {
        return this._record.toString();
    }

    public int getBucketSize() {
        String bucketSizeStr = this._record.getSimpleField(HelixPropertyAttribute.BUCKET_SIZE.toString());
        int bucketSize = 0;
        if (bucketSizeStr != null) {
            try {
                bucketSize = Integer.parseInt(bucketSizeStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bucketSize;
    }

    public void setBucketSize(int bucketSize) {
        if (bucketSize <= 0) {
            bucketSize = 0;
        }
        this._record.setSimpleField(HelixPropertyAttribute.BUCKET_SIZE.toString(), "" + bucketSize);
    }

    public static <T extends HelixProperty> T convertToTypedInstance(Class<T> clazz, ZNRecord record) {
        if (record == null) {
            return null;
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(ZNRecord.class);
            return (T)((HelixProperty)constructor.newInstance(record));
        }
        catch (Exception e) {
            LOG.error((Object)("Exception convert znrecord: " + record + " to class: " + clazz), (Throwable)e);
            return null;
        }
    }

    public static <T extends HelixProperty> List<T> convertToTypedList(Class<T> clazz, Collection<ZNRecord> records) {
        if (records == null) {
            return null;
        }
        ArrayList<T> decorators = new ArrayList<T>();
        for (ZNRecord record : records) {
            T decorator = HelixProperty.convertToTypedInstance(clazz, record);
            if (decorator == null) continue;
            decorators.add(decorator);
        }
        return decorators;
    }

    public static <T extends HelixProperty> Map<String, T> convertListToMap(List<T> records) {
        if (records == null) {
            return Collections.emptyMap();
        }
        HashMap<String, HelixProperty> decorators = new HashMap<String, HelixProperty>();
        for (HelixProperty record : records) {
            decorators.put(record.getId(), record);
        }
        return decorators;
    }

    public static <T extends HelixProperty> List<ZNRecord> convertToList(List<T> typedInstances) {
        if (typedInstances == null) {
            return Collections.emptyList();
        }
        ArrayList<ZNRecord> records = new ArrayList<ZNRecord>();
        for (HelixProperty typedInstance : typedInstances) {
            records.add(typedInstance.getRecord());
        }
        return records;
    }

    public void setBatchMessageMode(boolean enable) {
        this._record.setSimpleField(HelixPropertyAttribute.BATCH_MESSAGE_MODE.toString(), "" + enable);
    }

    public boolean getBatchMessageMode() {
        String enableStr = this._record.getSimpleField(HelixPropertyAttribute.BATCH_MESSAGE_MODE.toString());
        if (enableStr == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(enableStr.toLowerCase());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean equals(Object obj) {
        HelixProperty that;
        if (obj == null) {
            return false;
        }
        if (obj instanceof HelixProperty && (that = (HelixProperty)obj).getRecord() != null) {
            return that.getRecord().equals(this.getRecord());
        }
        return false;
    }

    public static enum HelixPropertyAttribute {
        BUCKET_SIZE,
        BATCH_MESSAGE_MODE;

    }
}

