/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.timelogger;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.commons.timelogger.ReportWriter;
import org.wymiwyg.commons.timelogger.ReportWriterFactory;
import org.wymiwyg.commons.timelogger.Section;
import org.wymiwyg.commons.timelogger.SectionTimeLogger;
import org.wymiwyg.commons.util.io.IndentPrintWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLogger {
    private final Logger log = LoggerFactory.getLogger(TimeLogger.class);
    private SectionTimeLogger currentTimeSectionLogger;
    private List<Section> sections = new ArrayList<Section>();
    private static ReportWriterFactory reportWriterFactory = new ReportWriterFactory(){

        public ReportWriter getReportWriter() {
            return new IndentedReportWriter();
        }
    };
    private ReportWriter reportWriter = reportWriterFactory.getReportWriter();
    private static final List<TimeLogger> activeSectionsPath = new ArrayList<TimeLogger>();

    public TimeLogger startSection(String description) {
        if (this.currentTimeSectionLogger != null) {
            throw new RuntimeException("Previous section not ended");
        }
        this.currentTimeSectionLogger = new SectionTimeLogger(description);
        activeSectionsPath.add(this.currentTimeSectionLogger);
        return this.currentTimeSectionLogger;
    }

    public void endSection() {
        this.currentTimeSectionLogger.subLoggerEnd();
        activeSectionsPath.remove(this.currentTimeSectionLogger);
        this.sections.add(this.currentTimeSectionLogger);
        this.log.info("ending section {} after {} ms", this.currentTimeSectionLogger.getIdentifier(), (Object)this.currentTimeSectionLogger.getTimeElapsedInMillis());
        this.currentTimeSectionLogger = null;
    }

    public void writeReport(Writer writer) throws IOException {
        this.reportWriter.write(this.sections, writer);
    }

    public static TimeLogger getCurrentSectionTimeLogger() {
        return activeSectionsPath.get(activeSectionsPath.size() - 1);
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public ReportWriter getReportWriter() {
        return this.reportWriter;
    }

    public void setReportWriter(ReportWriter reportWriter) {
        this.reportWriter = reportWriter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IndentedReportWriter
    implements ReportWriter {
        private IndentedReportWriter() {
        }

        private void printSections(Iterable<Section> sections, PrintWriter writer) {
            for (Section section : sections) {
                writer.println(section.getTimeElapsedInMillis() + "ms - " + section.getIdentifier());
                this.printSections(section.subSections(), new IndentPrintWriter(writer));
            }
            writer.flush();
        }

        @Override
        public void write(Iterable<Section> sections, Writer writer) {
            PrintWriter printWriter = new PrintWriter(writer);
            this.printSections(sections, printWriter);
            printWriter.flush();
        }
    }
}

