/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util.dirbrowser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.wymiwyg.commons.util.dirbrowser.PathNameFilter;
import org.wymiwyg.commons.util.dirbrowser.PathNode;

public class FilePathNode
implements PathNode {
    private File file;

    public FilePathNode(String path) {
        this.file = new File(path);
    }

    public FilePathNode(File file) {
        this.file = file;
    }

    public PathNode getSubPath(String requestPath) {
        return new FilePathNode(new File(this.file, requestPath));
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public String[] list(final PathNameFilter filter) {
        return this.file.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return filter.accept(FilePathNode.this, name);
            }
        });
    }

    public String[] list() {
        return this.file.list();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public long getLength() {
        return this.file.length();
    }

    public String getPath() {
        return this.file.getPath();
    }

    public Date getLastModified() {
        return new Date(this.file.lastModified());
    }

    public boolean exists() {
        return this.file.exists();
    }
}

