/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.notifications;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.uberfire.client.resources.WorkbenchResources;
import org.uberfire.client.workbench.widgets.animations.LinearFadeInAnimation;
import org.uberfire.client.workbench.widgets.animations.Pause;
import org.uberfire.client.workbench.widgets.animations.SequencedAnimation;
import org.uberfire.client.workbench.widgets.animations.Sequencer;
import org.uberfire.workbench.events.NotificationEvent;

public class NotificationPopupView
extends DecoratedPopupPanel {
    private final Alert notification = new Alert();

    public NotificationPopupView() {
        this.setStyleName(WorkbenchResources.INSTANCE.CSS().notification());
        this.setWidget((Widget)this.notification);
        this.notification.setDismissable(true);
    }

    public void setNotification(String text) {
        this.notification.setText(text);
    }

    public void setType(NotificationEvent.NotificationType type) {
        AlertType bs3Type;
        switch (type) {
            case ERROR: {
                bs3Type = AlertType.DANGER;
                break;
            }
            case DEFAULT: {
                bs3Type = AlertType.INFO;
                break;
            }
            default: {
                bs3Type = AlertType.valueOf((String)type.toString());
            }
        }
        this.notification.setType(bs3Type);
    }

    public void setNotificationWidth(String width) {
        this.notification.setWidth(width);
    }

    public void show(final Command onCompleteCommand) {
        LinearFadeInAnimation fadeInAnimation = new LinearFadeInAnimation((Widget)this){

            public void onStart() {
                super.onStart();
                NotificationPopupView.this.show();
            }
        };
        Pause pauseAnimation = new Pause(){

            public void onComplete() {
                super.onComplete();
                onCompleteCommand.execute();
            }
        };
        Sequencer s = new Sequencer();
        s.add((SequencedAnimation)fadeInAnimation, 250);
        s.add((SequencedAnimation)pauseAnimation, 2000);
        s.run();
    }
}

