/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.uberfire.commons.regex.util.GlobToRegEx;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.AccessMode;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileTreeWalker;
import org.uberfire.java.nio.file.FileVisitOption;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.NotLinkException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.StandardCopyOption;
import org.uberfire.java.nio.file.StandardOpenOption;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.java.nio.file.attribute.PosixFilePermission;
import org.uberfire.java.nio.file.attribute.UserPrincipal;
import org.uberfire.java.nio.file.spi.FileSystemProvider;

public final class Files {
    private static File BASE_TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final Path TEMP_PATH = Paths.get(BASE_TEMP_DIR.toURI());
    private static final Set<StandardOpenOption> CREATE_NEW_FILE_OPTIONS = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private static final int BUFFER_SIZE = 8192;

    private Files() {
    }

    private static FileSystemProvider providerOf(Path path) {
        return path.getFileSystem().provider();
    }

    public static InputStream newInputStream(Path path, OpenOption ... options) throws IllegalArgumentException, NoSuchFileException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        return Files.providerOf(path).newInputStream(path, options);
    }

    public static OutputStream newOutputStream(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        return Files.providerOf(path).newOutputStream(path, options);
    }

    public static SeekableByteChannel newByteChannel(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        HashSet set = new HashSet(options.length);
        Collections.addAll(set, options);
        return Files.newByteChannel(path, set, new FileAttribute[0]);
    }

    public static SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"options", options);
        return Files.providerOf(path).newByteChannel(path, options, attrs);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir) throws IllegalArgumentException, NotDirectoryException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"dir", (Object)dir);
        return Files.newDirectoryStream(dir, new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return true;
            }
        });
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir, final String glob) throws IllegalArgumentException, UnsupportedOperationException, PatternSyntaxException, NotDirectoryException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"dir", (Object)dir);
        Preconditions.checkNotEmpty((String)"glob", (String)glob);
        String regex = GlobToRegEx.globToRegex((String)glob);
        final Pattern pattern = Pattern.compile(regex);
        return Files.newDirectoryStream(dir, new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                if (entry.getFileName() == null) {
                    return glob.equals("/");
                }
                return pattern.matcher(entry.getFileName().toString()).find();
            }
        });
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<Path> filter) throws IllegalArgumentException, NotDirectoryException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"dir", (Object)dir);
        Preconditions.checkNotNull((String)"filter", filter);
        return Files.providerOf(dir).newDirectoryStream(dir, filter);
    }

    public static Path createFile(Path path, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        try {
            Files.newByteChannel(path, CREATE_NEW_FILE_OPTIONS, attrs).close();
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)e);
        }
        return path;
    }

    public static Path createDirectory(Path dir, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"dir", (Object)dir);
        Files.providerOf(dir).createDirectory(dir, attrs);
        return dir;
    }

    public static Path createDirectories(Path dir, FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Path parent;
        Preconditions.checkNotNull((String)"dir", (Object)dir);
        Path absoluteDir = dir.toAbsolutePath();
        if (!Files.notExists(absoluteDir, new LinkOption[0])) {
            throw new FileAlreadyExistsException(absoluteDir.toString());
        }
        for (parent = absoluteDir.getParent(); parent != null; parent = parent.getParent()) {
            try {
                Files.providerOf(parent).checkAccess(parent, new AccessMode[0]);
                break;
            }
            catch (NoSuchFileException noSuchFileException) {
                continue;
            }
        }
        if (parent == null) {
            throw new IOException("Root directory does not exist");
        }
        Path child = parent;
        for (Path name : parent.relativize(dir)) {
            child = child.resolve(name);
            Files.providerOf(child).createDirectory(child, attrs);
        }
        return dir;
    }

    public static Path createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"link", (Object)link);
        Preconditions.checkNotNull((String)"target", (Object)target);
        Files.providerOf(link).createSymbolicLink(link, target, attrs);
        return link;
    }

    public static Path createLink(Path link, Path existing) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"link", (Object)link);
        Preconditions.checkNotNull((String)"existing", (Object)existing);
        Files.providerOf(link).createLink(link, existing);
        return link;
    }

    public static void delete(Path path, DeleteOption ... options) throws IllegalArgumentException, NoSuchFileException, DirectoryNotEmptyException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Files.providerOf(path).delete(path, options);
    }

    public static boolean deleteIfExists(Path path, DeleteOption ... options) throws IllegalArgumentException, DirectoryNotEmptyException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        return Files.providerOf(path).deleteIfExists(path, options);
    }

    public static Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return Files.createTempFile(TEMP_PATH, prefix, suffix, attrs);
    }

    public static Path createTempFile(Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"dir", (Object)dir);
        if (Files.notExists(dir, new LinkOption[0])) {
            throw new NoSuchFileException(dir.toString());
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null && prefix.trim().length() > 0) {
            sb.append(prefix).append("-");
        }
        String baseName = sb.append(System.currentTimeMillis()).append("-").toString();
        String realSufix = suffix != null && suffix.trim().length() > 0 ? Files.normalizeSuffix(suffix) : ".tmp";
        for (int counter = 0; counter < 10000; ++counter) {
            try {
                return Files.createFile(dir.resolve(baseName + counter + realSufix), attrs);
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    private static String normalizeSuffix(String suffix) {
        if (suffix.startsWith(".")) {
            return suffix;
        }
        return "." + suffix;
    }

    public static Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return Files.createTempDirectory(TEMP_PATH, prefix, attrs);
    }

    public static Path createTempDirectory(Path dir, String prefix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"dir", (Object)dir);
        if (Files.notExists(dir, new LinkOption[0])) {
            throw new NoSuchFileException(dir.toString());
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null && prefix.trim().length() > 0) {
            sb.append(prefix).append("-");
        }
        String baseName = sb.append(System.currentTimeMillis()).append("-").toString();
        for (int counter = 0; counter < 10000; ++counter) {
            Path path2Create = dir.resolve(baseName + counter);
            try {
                return Files.createDirectory(path2Create, attrs);
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    public static Path copy(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"source", (Object)source);
        Preconditions.checkNotNull((String)"target", (Object)target);
        FileSystemProvider provider = Files.providerOf(source);
        if (Files.providerOf(target) == provider) {
            provider.copy(source, target, options);
            return target;
        }
        throw new UnsupportedOperationException("can't copy from different providers");
    }

    public static Path move(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"source", (Object)source);
        Preconditions.checkNotNull((String)"target", (Object)target);
        FileSystemProvider provider = Files.providerOf(source);
        if (Files.providerOf(target) == provider) {
            provider.move(source, target, options);
            return target;
        }
        throw new UnsupportedOperationException("can't move from different providers");
    }

    public static Path readSymbolicLink(Path link) throws IllegalArgumentException, UnsupportedOperationException, NotLinkException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"link", (Object)link);
        return Files.providerOf(link).readSymbolicLink(link);
    }

    public static FileStore getFileStore(Path path) throws IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        return Files.providerOf(path).getFileStore(path);
    }

    public static String probeContentType(Path path) throws UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
        throw new UnsupportedOperationException("feature not available");
    }

    public static <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) throws IllegalArgumentException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"type", type);
        return (V)Files.providerOf(path).getFileAttributeView(path, type, options);
    }

    public static <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IllegalArgumentException, NoSuchFileException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"type", type);
        return (A)Files.providerOf(path).readAttributes(path, type, options);
    }

    public static Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws UnsupportedOperationException, NoSuchFileException, IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotEmpty((String)"attributes", (String)attributes);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
        return Files.providerOf(path).readAttributes(path, attributes, options);
    }

    public static Path setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotEmpty((String)"attribute", (String)attribute);
        Files.providerOf(path).setAttribute(path, attribute, value, options);
        return path;
    }

    public static Object getAttribute(Path path, String attribute, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotEmpty((String)"attribute", (String)attribute);
        if (attribute.indexOf(42) >= 0 || attribute.indexOf(44) >= 0) {
            throw new IllegalArgumentException(attribute);
        }
        Map<String, Object> map = Files.readAttributes(path, attribute, options);
        int pos = attribute.indexOf(58);
        String name = pos == -1 ? attribute : (pos == attribute.length() ? "" : attribute.substring(pos + 1));
        return map.get(name);
    }

    public static Set<PosixFilePermission> getPosixFilePermissions(Path path, LinkOption ... options) throws UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
        throw new UnsupportedOperationException("feature not available");
    }

    public static Path setPosixFilePermissions(Path path, Set<PosixFilePermission> perms) throws UnsupportedOperationException, ClassCastException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"perms", perms);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
        throw new UnsupportedOperationException("feature not available");
    }

    public static UserPrincipal getOwner(Path path, LinkOption ... options) throws UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
        throw new UnsupportedOperationException("feature not available");
    }

    public static Path setOwner(Path path, UserPrincipal owner) throws UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"owner", (Object)owner);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
        throw new UnsupportedOperationException("feature not available");
    }

    public static FileTime getLastModifiedTime(Path path, LinkOption ... options) throws IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        return Files.readAttributes(path, BasicFileAttributes.class, options).lastModifiedTime();
    }

    public static Path setLastModifiedTime(Path path, FileTime time) throws IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).setTimes(time, null, null);
        return path;
    }

    public static long size(Path path) throws IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).size();
    }

    public static boolean exists(Path path, LinkOption ... options) throws IllegalArgumentException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        try {
            Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean notExists(Path path, LinkOption ... options) throws IllegalArgumentException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        try {
            Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            return false;
        }
        catch (NoSuchFileException x) {
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isSameFile(Path path, Path path2) throws IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"path2", (Object)path2);
        return Files.providerOf(path).isSameFile(path, path2);
    }

    public static boolean isHidden(Path path) throws IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        return Files.providerOf(path).isHidden(path);
    }

    public static boolean isReadable(Path path) throws IllegalArgumentException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        try {
            Files.providerOf(path).checkAccess(path, new AccessMode[]{AccessMode.READ});
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isWritable(Path path) throws IllegalArgumentException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        try {
            Files.providerOf(path).checkAccess(path, new AccessMode[]{AccessMode.WRITE});
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isExecutable(Path path) throws IllegalArgumentException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        try {
            Files.providerOf(path).checkAccess(path, new AccessMode[]{AccessMode.EXECUTE});
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isSymbolicLink(Path path) throws IllegalArgumentException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS).isSymbolicLink();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDirectory(Path path, LinkOption ... options) throws IllegalArgumentException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, options).isDirectory();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isRegularFile(Path path, LinkOption ... options) throws IllegalAccessError, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, options).isRegularFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static Path walkFileTree(Path start, Set<FileVisitOption> options, int maxDepth, FileVisitor<Path> visitor) throws IllegalArgumentException, SecurityException, IOException {
        new FileTreeWalker(visitor, maxDepth).walk(start);
        return start;
    }

    public static Path walkFileTree(Path start, FileVisitor<Path> visitor) throws IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"start", (Object)start);
        Preconditions.checkNotNull((String)"visitor", visitor);
        Set<FileVisitOption> options = Collections.emptySet();
        return Files.walkFileTree(start, options, Integer.MAX_VALUE, visitor);
    }

    public static BufferedReader newBufferedReader(Path path, Charset cs) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"cs", (Object)cs);
        return new BufferedReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), cs.newDecoder()));
    }

    public static BufferedWriter newBufferedWriter(Path path, Charset cs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"cs", (Object)cs);
        return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(path, options), cs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, Path target, CopyOption ... options) throws IOException, FileAlreadyExistsException, DirectoryNotEmptyException, UnsupportedOperationException, SecurityException {
        Preconditions.checkNotNull((String)"in", (Object)in);
        Preconditions.checkNotNull((String)"target", (Object)target);
        Preconditions.checkNotNull((String)"options", (Object)options);
        boolean replaceExisting = false;
        CopyOption[] copyOptionArray = options;
        int n = copyOptionArray.length;
        int n2 = 0;
        if (n2 < n) {
            CopyOption opt = copyOptionArray[n2];
            if (opt == StandardCopyOption.REPLACE_EXISTING) {
                replaceExisting = true;
            } else {
                Preconditions.checkNotNull((String)"opt", (Object)opt);
                throw new UnsupportedOperationException(opt + " not supported");
            }
        }
        if (replaceExisting) {
            Files.deleteIfExists(target, new DeleteOption[0]);
        }
        OutputStream out = Files.newOutputStream(target, new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE});
        try {
            long l = Files.internalCopy(in, out);
            return l;
        }
        finally {
            try {
                out.close();
            }
            catch (java.io.IOException e) {
                throw new IOException((Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(Path source, OutputStream out) throws IOException, SecurityException {
        Preconditions.checkNotNull((String)"source", (Object)source);
        Preconditions.checkNotNull((String)"out", (Object)out);
        InputStream in = Files.newInputStream(source, new OpenOption[0]);
        try {
            long l = Files.internalCopy(in, out);
            return l;
        }
        finally {
            try {
                in.close();
            }
            catch (java.io.IOException e) {
                throw new IOException((Exception)e);
            }
        }
    }

    private static long internalCopy(InputStream in, OutputStream out) {
        long read = 0L;
        byte[] buf = new byte[8192];
        try {
            int n;
            while ((n = in.read(buf)) > 0) {
                out.write(buf, 0, n);
                read += (long)n;
            }
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)e);
        }
        return read;
    }

    public static byte[] readAllBytes(Path path) throws IOException, OutOfMemoryError, SecurityException {
        long size = Files.size(path);
        if (size > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("Required array size too large");
        }
        InputStream in = Files.newInputStream(path, new OpenOption[0]);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream((int)size);
        byte[] data = new byte[8192];
        try {
            int read;
            while ((read = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, read);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)e);
        }
        finally {
            try {
                in.close();
            }
            catch (java.io.IOException e) {
                throw new IOException((Exception)e);
            }
        }
    }

    public static List<String> readAllLines(Path path, Charset cs) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"cs", (Object)cs);
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = Files.newBufferedReader(path, cs);
            ArrayList<String> result = new ArrayList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (java.io.IOException ex) {
            throw new IOException("Failed to read contents of path: " + path, (Exception)ex);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (java.io.IOException e) {
                    throw new IOException("Could not close reader.", (Exception)e);
                }
            }
        }
    }

    public static Path write(Path path, byte[] bytes, OpenOption ... options) throws IOException, UnsupportedOperationException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"bytes", (Object)bytes);
        OutputStream out = Files.newOutputStream(path, options);
        try {
            int len;
            int n2;
            for (int rem = len = bytes.length; rem > 0; rem -= n2) {
                n2 = rem <= 8192 ? rem : 8192;
                out.write(bytes, len - rem, n2);
            }
            Path n2 = path;
            return n2;
        }
        catch (java.io.IOException e) {
            throw new IOException("Failed to write contents to path: " + path, (Exception)e);
        }
        finally {
            try {
                out.close();
            }
            catch (java.io.IOException e) {
                throw new IOException("Could not close output stream.", (Exception)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Path write(Path path, Iterable<? extends CharSequence> lines, Charset cs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"cs", (Object)cs);
        Preconditions.checkNotNull((String)"lines", lines);
        CharsetEncoder encoder = cs.newEncoder();
        OutputStream out = Files.newOutputStream(path, options);
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(out, encoder));
            for (CharSequence charSequence : lines) {
                try {
                    bufferedWriter.append(charSequence);
                    bufferedWriter.newLine();
                }
                catch (java.io.IOException e) {
                    throw new IOException("Failed to append line to writer for path: " + path, (Exception)e);
                    return path;
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (java.io.IOException e) {
                    throw new IOException("Could not close writer.", (Exception)e);
                }
            }
        }
    }
}

