/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.controller.stages.MessageGenerationOutput;
import org.apache.helix.controller.stages.MessageSelectionStageOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.StateModelDefinition;
import org.apache.log4j.Logger;

public class MessageSelectionStage
extends AbstractBaseStage {
    private static final Logger LOG = Logger.getLogger(MessageSelectionStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.toString());
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.toString());
        MessageGenerationOutput messageGenOutput = (MessageGenerationOutput)event.getAttribute(AttributeName.MESSAGES_ALL.toString());
        if (cache == null || resourceMap == null || currentStateOutput == null || messageGenOutput == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires DataCache|RESOURCES|CURRENT_STATE|MESSAGES_ALL");
        }
        MessageSelectionStageOutput output = new MessageSelectionStageOutput();
        for (String resourceName : resourceMap.keySet()) {
            Resource resource = (Resource)resourceMap.get(resourceName);
            StateModelDefinition stateModelDef = cache.getStateModelDef(resource.getStateModelDefRef());
            Map<String, Integer> stateTransitionPriorities = this.getStateTransitionPriorityMap(stateModelDef);
            IdealState idealState = cache.getIdealState(resourceName);
            Map<String, Bounds> stateConstraints = this.computeStateConstraints(stateModelDef, idealState, cache);
            for (Partition partition : resource.getPartitions()) {
                List<Message> messages = messageGenOutput.getMessages(resourceName, partition);
                List<Message> selectedMessages = this.selectMessages(cache.getLiveInstances(), currentStateOutput.getCurrentStateMap(resourceName, partition), currentStateOutput.getPendingMessageMap(resourceName, partition), messages, stateConstraints, stateTransitionPriorities, stateModelDef.getInitialState());
                output.addMessages(resourceName, partition, selectedMessages);
            }
        }
        event.addAttribute(AttributeName.MESSAGES_SELECTED.toString(), output);
    }

    private void increaseStateCnt(Map<String, Bounds> stateConstraints, String state, Map<String, Integer> stateCnts) {
        if (!stateConstraints.containsKey(state)) {
            return;
        }
        if (!stateCnts.containsKey(state)) {
            stateCnts.put(state, 0);
        }
        stateCnts.put(state, stateCnts.get(state) + 1);
    }

    List<Message> selectMessages(Map<String, LiveInstance> liveInstances, Map<String, String> currentStates, Map<String, Message> pendingMessages, List<Message> messages, Map<String, Bounds> stateConstraints, Map<String, Integer> stateTransitionPriorities, String initialState) {
        if (messages == null || messages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Message> selectedMessages = new ArrayList<Message>();
        HashMap<String, Integer> stateCnts = new HashMap<String, Integer>();
        for (String instance : liveInstances.keySet()) {
            String state = initialState;
            if (currentStates.containsKey(instance)) {
                state = currentStates.get(instance);
            }
            this.increaseStateCnt(stateConstraints, state, stateCnts);
        }
        for (String instance : pendingMessages.keySet()) {
            Message message = pendingMessages.get(instance);
            this.increaseStateCnt(stateConstraints, message.getToState(), stateCnts);
            this.increaseStateCnt(stateConstraints, message.getFromState(), stateCnts);
        }
        TreeMap messagesGroupByStateTransitPriority = new TreeMap();
        for (Message message : messages) {
            String fromState = message.getFromState();
            String toState = message.getToState();
            String transition = fromState + "-" + toState;
            int priority = Integer.MAX_VALUE;
            if (stateTransitionPriorities.containsKey(transition)) {
                priority = stateTransitionPriorities.get(transition);
            }
            if (!messagesGroupByStateTransitPriority.containsKey(priority)) {
                messagesGroupByStateTransitPriority.put(priority, new ArrayList());
            }
            ((List)messagesGroupByStateTransitPriority.get(priority)).add(message);
        }
        for (List messageList : messagesGroupByStateTransitPriority.values()) {
            for (Message message : messageList) {
                String toState = message.getToState();
                if (stateConstraints.containsKey(toState)) {
                    int newCnt;
                    int n = newCnt = stateCnts.containsKey(toState) ? (Integer)stateCnts.get(toState) + 1 : 1;
                    if (newCnt > stateConstraints.get(toState).getUpperBound()) {
                        LOG.info((Object)("Reach upper_bound: " + stateConstraints.get(toState).getUpperBound() + ", not send message: " + message));
                        continue;
                    }
                }
                this.increaseStateCnt(stateConstraints, message.getToState(), stateCnts);
                selectedMessages.add(message);
            }
        }
        return selectedMessages;
    }

    private Map<String, Bounds> computeStateConstraints(StateModelDefinition stateModelDefinition, IdealState idealState, ClusterDataCache cache) {
        HashMap<String, Bounds> stateConstraints = new HashMap<String, Bounds>();
        List<String> statePriorityList = stateModelDefinition.getStatesPriorityList();
        for (String state : statePriorityList) {
            String numInstancesPerState = stateModelDefinition.getNumInstancesPerState(state);
            int max = -1;
            if ("N".equals(numInstancesPerState)) {
                max = cache.getLiveInstances().size();
            } else if ("R".equals(numInstancesPerState)) {
                if (idealState != null) {
                    max = cache.getReplicas(idealState.getResourceName());
                }
            } else {
                try {
                    max = Integer.parseInt(numInstancesPerState);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (max <= -1) continue;
            stateConstraints.put(state, new Bounds(0, max));
        }
        return stateConstraints;
    }

    private Map<String, Integer> getStateTransitionPriorityMap(StateModelDefinition stateModelDef) {
        HashMap<String, Integer> stateTransitionPriorities = new HashMap<String, Integer>();
        List<String> stateTransitionPriorityList = stateModelDef.getStateTransitionPriorityList();
        for (int i = 0; i < stateTransitionPriorityList.size(); ++i) {
            stateTransitionPriorities.put(stateTransitionPriorityList.get(i), i);
        }
        return stateTransitionPriorities;
    }

    public static class Bounds {
        private int upper;
        private int lower;

        public Bounds(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public void increaseUpperBound() {
            ++this.upper;
        }

        public void increaseLowerBound() {
            ++this.lower;
        }

        public void decreaseUpperBound() {
            --this.upper;
        }

        public void decreaseLowerBound() {
            --this.lower;
        }

        public int getLowerBound() {
            return this.lower;
        }

        public int getUpperBound() {
            return this.upper;
        }
    }
}

