/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.SimpleEventBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import jsinterop.annotations.JsMethod;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.api.EnabledByProperty;
import org.jboss.errai.ioc.client.api.SharedSingleton;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityLifecycleError;
import org.uberfire.client.mvp.ActivityLifecycleErrorHandler;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceHistoryHandler;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.mvp.PopupActivity;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.client.mvp.UIPart;
import org.uberfire.client.mvp.WorkbenchActivity;
import org.uberfire.client.workbench.LayoutSelection;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.WorkbenchLayout;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.client.workbench.events.ClosePlaceEvent;
import org.uberfire.client.workbench.events.NewSplashScreenActiveEvent;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.events.PlaceLostFocusEvent;
import org.uberfire.client.workbench.events.SelectPlaceEvent;
import org.uberfire.client.workbench.panels.impl.UnanchoredStaticWorkbenchPanelPresenter;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.Commands;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.ConditionalPlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.ForcedPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.plugin.PluginUtil;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@SharedSingleton
@EnabledByProperty(value="uberfire.plugin.mode.active", negated=true)
public class PlaceManagerImpl
implements PlaceManager {
    private final Map<PlaceRequest, Activity> existingWorkbenchActivities = new HashMap<PlaceRequest, Activity>();
    private final Map<PlaceRequest, PartDefinition> visibleWorkbenchParts = new HashMap<PlaceRequest, PartDefinition>();
    private final Map<PlaceRequest, PanelDefinition> customPanels = new HashMap<PlaceRequest, PanelDefinition>();
    private final Map<PlaceRequest, Command> onOpenCallbacks = new HashMap<PlaceRequest, Command>();
    private EventBus tempBus = null;
    @Inject
    private Event<BeforeClosePlaceEvent> workbenchPartBeforeCloseEvent;
    @Inject
    private Event<ClosePlaceEvent> workbenchPartCloseEvent;
    @Inject
    private Event<NewSplashScreenActiveEvent> newSplashScreenActiveEvent;
    @Inject
    private ActivityManager activityManager;
    @Inject
    private PlaceHistoryHandler placeHistoryHandler;
    @Inject
    private Event<SelectPlaceEvent> selectWorkbenchPartEvent;
    @Inject
    private PanelManager panelManager;
    @Inject
    private PerspectiveManager perspectiveManager;
    @Inject
    private ActivityLifecycleErrorHandler lifecycleErrorHandler;
    private WorkbenchLayout workbenchLayout;
    @Inject
    private LayoutSelection layoutSelection;
    private final Map<String, SplashScreenActivity> availableSplashScreens = new HashMap<String, SplashScreenActivity>();
    private final Map<String, PopupActivity> activePopups = new HashMap<String, PopupActivity>();
    private final Map<PlaceRequest, Activity> onMayCloseList = new HashMap<PlaceRequest, Activity>();

    @PostConstruct
    public void initPlaceHistoryHandler() {
        this.getPlaceHistoryHandler().register(this, this.produceEventBus(), DefaultPlaceRequest.NOWHERE);
        this.workbenchLayout = this.layoutSelection.get();
    }

    private PlaceHistoryHandler getPlaceHistoryHandler() {
        return this.placeHistoryHandler;
    }

    @Override
    public void goTo(String identifier, PanelDefinition panel) {
        DefaultPlaceRequest place = new DefaultPlaceRequest(identifier);
        this.goTo((PlaceRequest)place, panel);
    }

    @Override
    public void goTo(String identifier) {
        DefaultPlaceRequest place = new DefaultPlaceRequest(identifier);
        this.goTo((PlaceRequest)place, (PanelDefinition)null);
    }

    @Override
    public void goTo(PlaceRequest place) {
        this.goTo(place, (PanelDefinition)null);
    }

    @Override
    public void goTo(Path path, PanelDefinition panel) {
        this.goTo((PlaceRequest)new PathPlaceRequest(path), panel);
    }

    @Override
    public void goTo(Path path) {
        this.goTo((PlaceRequest)new PathPlaceRequest(path), (PanelDefinition)null);
    }

    @Override
    public void goTo(Path path, PlaceRequest placeRequest, PanelDefinition panel) {
        this.goTo(this.getPlace(path, placeRequest), panel);
    }

    @Override
    public void goTo(Path path, PlaceRequest placeRequest) {
        this.goTo(this.getPlace(path, placeRequest), (PanelDefinition)null);
    }

    @Override
    public void goTo(PlaceRequest place, PanelDefinition panel) {
        this.goTo(place, panel, Commands.DO_NOTHING);
    }

    @Override
    public void goTo(PlaceRequest place, HasWidgets addTo) {
        this.goToTargetPanel(place, this.panelManager.addCustomPanel(addTo, UnanchoredStaticWorkbenchPanelPresenter.class.getName()));
    }

    @Override
    public void goTo(PlaceRequest place, HTMLElement addTo) {
        this.goToTargetPanel(place, this.panelManager.addCustomPanel(addTo, UnanchoredStaticWorkbenchPanelPresenter.class.getName()));
    }

    private void goToTargetPanel(PlaceRequest place, PanelDefinition adoptedPanel) {
        if (this.existingWorkbenchActivities.containsKey(place)) {
            this.goTo(place, null, Commands.DO_NOTHING);
        } else {
            this.customPanels.put(place, adoptedPanel);
            this.goTo(place, adoptedPanel, Commands.DO_NOTHING);
        }
    }

    private void goTo(final PlaceRequest place, final PanelDefinition panel, final Command doWhenFinished) {
        if (place == null || place.equals(DefaultPlaceRequest.NOWHERE)) {
            return;
        }
        ResolvedRequest resolved = this.resolveActivity(place);
        if (resolved.getActivity() != null) {
            Activity activity = resolved.getActivity();
            if (activity.isType(ActivityResourceType.SCREEN.name()) || activity.isType(ActivityResourceType.EDITOR.name())) {
                WorkbenchActivity workbenchActivity = (WorkbenchActivity)activity;
                if (workbenchActivity.getOwningPlace() != null && this.getStatus(workbenchActivity.getOwningPlace()) == PlaceStatus.CLOSE) {
                    this.goTo(workbenchActivity.getOwningPlace(), null, new Command(){

                        public void execute() {
                            PlaceManagerImpl.this.goTo(place, panel, doWhenFinished);
                        }
                    });
                    return;
                }
                this.launchWorkbenchActivityAtPosition(resolved.getPlaceRequest(), workbenchActivity, workbenchActivity.getDefaultPosition(), panel);
                doWhenFinished.execute();
            } else if (activity.isType(ActivityResourceType.POPUP.name())) {
                this.launchPopupActivity(resolved.getPlaceRequest(), (PopupActivity)activity);
                doWhenFinished.execute();
            } else if (activity.isType(ActivityResourceType.PERSPECTIVE.name())) {
                this.launchPerspectiveActivity(place, (PerspectiveActivity)activity, doWhenFinished);
            }
        } else {
            this.goTo(resolved.getPlaceRequest(), panel, doWhenFinished);
        }
    }

    private boolean closePlaces(Collection<PlaceRequest> placeRequests) {
        boolean result = true;
        for (PlaceRequest placeRequest : placeRequests) {
            Activity activity = this.existingWorkbenchActivities.get(placeRequest);
            if (!activity.isType(ActivityResourceType.SCREEN.name()) && !activity.isType(ActivityResourceType.EDITOR.name())) continue;
            if (((WorkbenchActivity)activity).onMayClose()) {
                this.onMayCloseList.put(placeRequest, activity);
                continue;
            }
            result = false;
            break;
        }
        if (!result) {
            this.onMayCloseList.clear();
        } else {
            for (PlaceRequest placeRequest : placeRequests) {
                this.closePlace(placeRequest);
            }
        }
        return result;
    }

    private ResolvedRequest resolveActivity(PlaceRequest place) {
        PlaceRequest resolvedPlaceRequest = this.resolvePlaceRequest(place);
        ResolvedRequest existingDestination = this.resolveExistingParts(resolvedPlaceRequest);
        if (existingDestination != null) {
            return existingDestination;
        }
        Set<Activity> activities = this.activityManager.getActivities(resolvedPlaceRequest);
        if (activities == null || activities.size() == 0) {
            DefaultPlaceRequest notFoundPopup = new DefaultPlaceRequest("workbench.activity.notfound");
            notFoundPopup.addParameter("requestedPlaceIdentifier", resolvedPlaceRequest.getIdentifier());
            if (this.activityManager.containsActivity((PlaceRequest)notFoundPopup)) {
                return new ResolvedRequest(null, (PlaceRequest)notFoundPopup);
            }
            DefaultPlaceRequest ufNotFoundPopup = new DefaultPlaceRequest("uf.workbench.activity.notfound");
            ufNotFoundPopup.addParameter("requestedPlaceIdentifier", place.getIdentifier());
            return new ResolvedRequest(null, (PlaceRequest)ufNotFoundPopup);
        }
        if (activities.size() > 1) {
            PlaceRequest multiplePlaces = new DefaultPlaceRequest("workbench.activities.multiple").addParameter("requestedPlaceIdentifier", null);
            return new ResolvedRequest(null, multiplePlaces);
        }
        Activity unambigousActivity = activities.iterator().next();
        this.existingWorkbenchActivities.put(resolvedPlaceRequest, unambigousActivity);
        return new ResolvedRequest(unambigousActivity, resolvedPlaceRequest);
    }

    private PlaceRequest resolvePlaceRequest(PlaceRequest place) {
        if (this.isaConditionalPlaceRequest(place)) {
            return this.resolveConditionalPlaceRequest((ConditionalPlaceRequest)place);
        }
        return place;
    }

    private PlaceRequest resolveConditionalPlaceRequest(ConditionalPlaceRequest conditionalPlaceRequest) {
        return conditionalPlaceRequest.resolveConditionalPlaceRequest();
    }

    private boolean isaConditionalPlaceRequest(PlaceRequest place) {
        return place instanceof ConditionalPlaceRequest;
    }

    private ResolvedRequest resolveExistingParts(PlaceRequest place) {
        Activity activity = this.getActivity(place);
        if (activity != null) {
            return new ResolvedRequest(activity, place);
        }
        if (place instanceof PathPlaceRequest) {
            ObservablePath path = ((PathPlaceRequest)place).getPath();
            for (Map.Entry<PlaceRequest, PartDefinition> entry : this.visibleWorkbenchParts.entrySet()) {
                ObservablePath visiblePath;
                String visiblePathURI;
                PlaceRequest pr = entry.getKey();
                if (!(pr instanceof PathPlaceRequest) || ((visiblePathURI = (visiblePath = ((PathPlaceRequest)pr).getPath()).toURI()) == null || visiblePathURI.compareTo(path.toURI()) != 0) && visiblePath.compareTo((Object)path) != 0) continue;
                return new ResolvedRequest(this.getActivity(pr), pr);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void goTo(PartDefinition part, PanelDefinition panel) {
        PlaceRequest place = part.getPlace();
        if (place == null) {
            return;
        }
        ResolvedRequest resolved = this.resolveActivity(place);
        if (resolved.getActivity() != null) {
            Activity activity = resolved.getActivity();
            if (!activity.isType(ActivityResourceType.EDITOR.name()) && !activity.isType(ActivityResourceType.SCREEN.name())) throw new IllegalArgumentException("placeRequest does not represent a WorkbenchActivity. Only WorkbenchActivities can be launched in a specific targetPanel.");
            WorkbenchActivity workbenchActivity = (WorkbenchActivity)activity;
            this.launchWorkbenchActivityInPanel(place, workbenchActivity, part, panel);
            return;
        } else {
            this.goTo(resolved.getPlaceRequest());
        }
    }

    private PlaceRequest getPlace(Path path, PlaceRequest placeRequest) {
        PathPlaceRequest request = new PathPlaceRequest(path);
        for (String name : PluginUtil.ensureIterable((Set)placeRequest.getParameterNames())) {
            request.addParameter(name, (String)placeRequest.getParameters().get(name));
        }
        return request;
    }

    @Override
    public Activity getActivity(PlaceRequest place) {
        if (place == null) {
            return null;
        }
        Activity activity = this.existingWorkbenchActivities.get(place);
        return activity;
    }

    @Override
    public PlaceStatus getStatus(String id) {
        return this.getStatus((PlaceRequest)new DefaultPlaceRequest(id));
    }

    @Override
    public PlaceStatus getStatus(PlaceRequest place) {
        PerspectiveActivity currentPerspective = this.perspectiveManager.getCurrentPerspective();
        if (currentPerspective != null && currentPerspective.getPlace().equals(place)) {
            return PlaceStatus.OPEN;
        }
        return this.resolveExistingParts(place) != null ? PlaceStatus.OPEN : PlaceStatus.CLOSE;
    }

    @Override
    @JsMethod
    public void closePlace(String id) {
        this.closePlace((PlaceRequest)new DefaultPlaceRequest(id));
    }

    @Override
    @JsMethod
    public void closePlace(PlaceRequest placeToClose) {
        if (placeToClose == null) {
            return;
        }
        this.closePlace(placeToClose, false);
    }

    @Override
    public void tryClosePlace(PlaceRequest placeToClose, Command onAfterClose) {
        boolean execute = false;
        execute = placeToClose == null ? true : this.closePlaces(Arrays.asList(placeToClose));
        if (execute) {
            onAfterClose.execute();
        }
    }

    @Override
    public void forceClosePlace(String id) {
        this.forceClosePlace((PlaceRequest)new DefaultPlaceRequest(id));
    }

    @Override
    public void forceClosePlace(PlaceRequest placeToClose) {
        if (placeToClose == null) {
            return;
        }
        this.closePlace(placeToClose, true);
    }

    @Override
    public void closeAllPlaces() {
        ArrayList<PlaceRequest> placesToClose = new ArrayList<PlaceRequest>(this.visibleWorkbenchParts.keySet());
        for (PlaceRequest placeToClose : placesToClose) {
            this.closePlace(placeToClose);
        }
    }

    private boolean closeAllCurrentPanels() {
        return this.closePlaces(new ArrayList<PlaceRequest>(this.visibleWorkbenchParts.keySet()));
    }

    @Override
    public void registerOnOpenCallback(PlaceRequest place, Command command) {
        PortablePreconditions.checkNotNull((String)"place", (Object)place);
        PortablePreconditions.checkNotNull((String)"command", (Object)command);
        this.onOpenCallbacks.put(place, command);
    }

    @Override
    public void unregisterOnOpenCallback(PlaceRequest place) {
        PortablePreconditions.checkNotNull((String)"place", (Object)place);
        this.onOpenCallbacks.remove(place);
    }

    private void addSplashScreenFor(PlaceRequest place) {
        SplashScreenActivity splashScreen = this.activityManager.getSplashScreenInterceptor(place);
        if (splashScreen != null) {
            this.availableSplashScreens.put(place.getIdentifier(), splashScreen);
            try {
                splashScreen.onOpen();
            }
            catch (Exception ex) {
                this.availableSplashScreens.remove(place.getIdentifier());
                this.lifecycleErrorHandler.handle(splashScreen, ActivityLifecycleError.LifecyclePhase.OPEN, ex);
                this.activityManager.destroyActivity(splashScreen);
                return;
            }
        }
        this.newSplashScreenActiveEvent.fire((Object)new NewSplashScreenActiveEvent());
    }

    private void closeSplashScreen(PlaceRequest place) {
        SplashScreenActivity splashScreenActivity = this.availableSplashScreens.remove(place.getIdentifier());
        if (splashScreenActivity != null) {
            try {
                splashScreenActivity.closeIfOpen();
            }
            catch (Exception ex) {
                this.lifecycleErrorHandler.handle(splashScreenActivity, ActivityLifecycleError.LifecyclePhase.CLOSE, ex);
            }
            this.activityManager.destroyActivity(splashScreenActivity);
            this.newSplashScreenActiveEvent.fire((Object)new NewSplashScreenActiveEvent());
        }
    }

    private void closeAllSplashScreens() {
        for (String placeId : new ArrayList<String>(this.availableSplashScreens.keySet())) {
            this.closeSplashScreen((PlaceRequest)new DefaultPlaceRequest(placeId));
        }
    }

    @Override
    public Collection<SplashScreenActivity> getActiveSplashScreens() {
        return Collections.unmodifiableCollection(this.availableSplashScreens.values());
    }

    @Override
    public Collection<PathPlaceRequest> getActivitiesForResourceType(ResourceTypeDefinition type) {
        ArrayList<PathPlaceRequest> activities = new ArrayList<PathPlaceRequest>();
        for (PlaceRequest placeRequest : this.existingWorkbenchActivities.keySet()) {
            PathPlaceRequest ppr;
            if (!(placeRequest instanceof PathPlaceRequest) || !type.accept((Path)(ppr = (PathPlaceRequest)placeRequest).getPath())) continue;
            activities.add(ppr);
        }
        return Collections.unmodifiableCollection(activities);
    }

    public Collection<PlaceRequest> getActivePlaceRequests() {
        return Collections.unmodifiableCollection(this.existingWorkbenchActivities.keySet());
    }

    public Collection<PathPlaceRequest> getActivePlaceRequestsWithPath() {
        ArrayList<PathPlaceRequest> pprs = new ArrayList<PathPlaceRequest>();
        for (PlaceRequest placeRequest : this.existingWorkbenchActivities.keySet()) {
            if (!(placeRequest instanceof PathPlaceRequest)) continue;
            pprs.add((PathPlaceRequest)placeRequest);
        }
        return pprs;
    }

    private void launchWorkbenchActivityAtPosition(PlaceRequest place, WorkbenchActivity activity, Position position, PanelDefinition _panel) {
        if (this.visibleWorkbenchParts.containsKey(place)) {
            this.selectWorkbenchPartEvent.fire((Object)new SelectPlaceEvent(place));
            return;
        }
        PartDefinitionImpl part = new PartDefinitionImpl(place);
        PanelDefinition panel = _panel != null ? _panel : this.panelManager.addWorkbenchPanel(this.panelManager.getRoot(), position, activity.preferredHeight(), activity.preferredWidth(), null, null);
        this.launchWorkbenchActivityInPanel(place, activity, (PartDefinition)part, panel);
    }

    private void launchWorkbenchActivityInPanel(PlaceRequest place, WorkbenchActivity activity, PartDefinition part, PanelDefinition panel) {
        this.visibleWorkbenchParts.put(place, part);
        this.getPlaceHistoryHandler().onPlaceChange(place);
        IsWidget titleDecoration = this.maybeWrapExternalWidget(activity, () -> activity.getTitleDecorationElement(), () -> activity.getTitleDecoration());
        IsWidget widget = this.maybeWrapExternalWidget(activity, () -> activity.getWidgetElement(), () -> activity.getWidget());
        UIPart uiPart = new UIPart(activity.getTitle(), titleDecoration, widget);
        this.panelManager.addWorkbenchPart(place, part, panel, activity.getMenus(), uiPart, activity.contextId(), PluginUtil.toInteger((int)panel.getWidthAsInt()), PluginUtil.toInteger((int)panel.getHeightAsInt()));
        this.addSplashScreenFor(place);
        try {
            activity.onOpen();
        }
        catch (Exception ex) {
            this.lifecycleErrorHandler.handle(activity, ActivityLifecycleError.LifecyclePhase.OPEN, ex);
            this.closePlace(place);
        }
    }

    private IsWidget maybeWrapExternalWidget(WorkbenchActivity activity, Supplier<Element> element, Supplier<IsWidget> widget) {
        if (activity.isDynamic()) {
            Element e = element.get();
            return e == null ? null : ElementWrapperWidget.getWidget((Element)e);
        }
        return widget.get();
    }

    private void launchPopupActivity(PlaceRequest place, PopupActivity activity) {
        if (this.activePopups.get(place.getIdentifier()) != null) {
            return;
        }
        this.getPlaceHistoryHandler().onPlaceChange(place);
        this.activePopups.put(place.getIdentifier(), activity);
        try {
            activity.onOpen();
        }
        catch (Exception ex) {
            this.activePopups.remove(place.getIdentifier());
            this.lifecycleErrorHandler.handle(activity, ActivityLifecycleError.LifecyclePhase.OPEN, ex);
        }
    }

    private void launchPerspectiveActivity(final PlaceRequest place, final PerspectiveActivity activity, final Command doWhenFinished) {
        PortablePreconditions.checkNotNull((String)"doWhenFinished", (Object)doWhenFinished);
        if (place instanceof ForcedPlaceRequest) {
            this.switchToPerspective(place, activity, new ParameterizedCommand<PerspectiveDefinition>(){

                public void execute(PerspectiveDefinition perspectiveDef) {
                    PlaceManagerImpl.this.openPartsRecursively(perspectiveDef.getRoot());
                    doWhenFinished.execute();
                    PlaceManagerImpl.this.workbenchLayout.onResize();
                }
            });
        } else {
            final PerspectiveActivity oldPerspectiveActivity = this.perspectiveManager.getCurrentPerspective();
            if (oldPerspectiveActivity != null && place.equals(oldPerspectiveActivity.getPlace())) {
                return;
            }
            this.perspectiveManager.savePerspectiveState(new Command(){

                public void execute() {
                    try {
                        activity.onOpen();
                    }
                    catch (Exception ex) {
                        PlaceManagerImpl.this.lifecycleErrorHandler.handle(activity, ActivityLifecycleError.LifecyclePhase.OPEN, ex);
                        try {
                            activity.onClose();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        PlaceManagerImpl.this.existingWorkbenchActivities.remove(place);
                        PlaceManagerImpl.this.activityManager.destroyActivity(activity);
                        return;
                    }
                    PlaceManagerImpl.this.switchToPerspective(place, activity, (ParameterizedCommand<PerspectiveDefinition>)((ParameterizedCommand)new ParameterizedCommand<PerspectiveDefinition>(){

                        public void execute(PerspectiveDefinition perspectiveDef) {
                            if (oldPerspectiveActivity != null) {
                                try {
                                    oldPerspectiveActivity.onClose();
                                }
                                catch (Exception ex) {
                                    PlaceManagerImpl.this.lifecycleErrorHandler.handle(oldPerspectiveActivity, ActivityLifecycleError.LifecyclePhase.CLOSE, ex);
                                }
                                PlaceManagerImpl.this.existingWorkbenchActivities.remove(oldPerspectiveActivity.getPlace());
                                PlaceManagerImpl.this.activityManager.destroyActivity(oldPerspectiveActivity);
                            }
                            PlaceManagerImpl.this.openPartsRecursively(perspectiveDef.getRoot());
                            doWhenFinished.execute();
                            PlaceManagerImpl.this.workbenchLayout.onResize();
                        }
                    }));
                }
            });
        }
    }

    private void switchToPerspective(PlaceRequest place, PerspectiveActivity newPerspectiveActivity, ParameterizedCommand<PerspectiveDefinition> closeOldPerspectiveOpenPartsAndExecuteChainedCallback) {
        if (this.closeAllCurrentPanels()) {
            this.closeAllSplashScreens();
            this.addSplashScreenFor(place);
            this.perspectiveManager.switchToPerspective(place, newPerspectiveActivity, closeOldPerspectiveOpenPartsAndExecuteChainedCallback);
        } else {
            try {
                newPerspectiveActivity.onClose();
            }
            catch (Exception ex) {
                this.lifecycleErrorHandler.handle(newPerspectiveActivity, ActivityLifecycleError.LifecyclePhase.OPEN, ex);
            }
            this.existingWorkbenchActivities.remove(newPerspectiveActivity.getPlace());
            this.activityManager.destroyActivity(newPerspectiveActivity);
        }
    }

    private void openPartsRecursively(PanelDefinition panel) {
        for (PartDefinition part : PluginUtil.ensureIterable((Set)panel.getParts())) {
            PlaceRequest place = part.getPlace().clone();
            part.setPlace(place);
            this.goTo(part, panel);
        }
        for (PanelDefinition child : PluginUtil.ensureIterable((List)panel.getChildren())) {
            this.openPartsRecursively(child);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void closePlace(PlaceRequest place, boolean force) {
        Activity activity1;
        Activity activity = this.existingWorkbenchActivities.get(place);
        if (activity == null) {
            return;
        }
        this.workbenchPartBeforeCloseEvent.fire((Object)new BeforeClosePlaceEvent(place, force, true));
        this.closeSplashScreen(place);
        this.activePopups.remove(place.getIdentifier());
        if (activity.isType(ActivityResourceType.SCREEN.name()) || activity.isType(ActivityResourceType.EDITOR.name())) {
            activity1 = (WorkbenchActivity)activity;
            if (!force && !this.onMayCloseList.containsKey(place) && !activity1.onMayClose()) return;
            this.onMayCloseList.remove(place);
            try {
                activity1.onClose();
            }
            catch (Exception ex) {
                this.lifecycleErrorHandler.handle(activity1, ActivityLifecycleError.LifecyclePhase.CLOSE, ex);
            }
        } else if (activity.isType(ActivityResourceType.POPUP.name())) {
            activity1 = (PopupActivity)activity;
            if (!force && !activity1.onMayClose()) return;
            try {
                activity1.onClose();
            }
            catch (Exception ex) {
                this.lifecycleErrorHandler.handle(activity1, ActivityLifecycleError.LifecyclePhase.CLOSE, ex);
            }
        }
        this.workbenchPartCloseEvent.fire((Object)new ClosePlaceEvent(place));
        this.panelManager.removePartForPlace(place);
        this.existingWorkbenchActivities.remove(place);
        this.visibleWorkbenchParts.remove(place);
        this.activityManager.destroyActivity(activity);
        PanelDefinition customPanelDef = this.customPanels.remove(place);
        if (customPanelDef != null) {
            this.panelManager.removeWorkbenchPanel(customPanelDef);
        }
        if (!(place instanceof PathPlaceRequest)) return;
        ((PathPlaceRequest)place).getPath().dispose();
    }

    private void onWorkbenchPartOnFocus(@Observes PlaceGainFocusEvent event) {
        PlaceRequest place = event.getPlace();
        Activity activity = this.getActivity(place);
        if (activity == null) {
            return;
        }
        if (activity instanceof WorkbenchActivity) {
            ((WorkbenchActivity)activity).onFocus();
        }
    }

    private void onWorkbenchPartLostFocus(@Observes PlaceLostFocusEvent event) {
        Activity activity = this.getActivity(event.getPlace());
        if (activity == null) {
            return;
        }
        if (activity instanceof WorkbenchActivity) {
            ((WorkbenchActivity)activity).onLostFocus();
        }
    }

    @Produces
    @ApplicationScoped
    private EventBus produceEventBus() {
        if (this.tempBus == null) {
            this.tempBus = new SimpleEventBus();
        }
        return this.tempBus;
    }

    @Override
    public Command getOpenCallback(PlaceRequest place) {
        return this.onOpenCallbacks.get(place);
    }

    private static class ResolvedRequest {
        private final Activity activity;
        private final PlaceRequest placeRequest;

        public ResolvedRequest(Activity resolvedActivity, PlaceRequest substitutePlace) {
            this.activity = resolvedActivity;
            this.placeRequest = substitutePlace;
        }

        public Activity getActivity() {
            return this.activity;
        }

        public PlaceRequest getPlaceRequest() {
            return this.placeRequest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedRequest resolvedRequest = (ResolvedRequest)o;
            if (this.activity != null ? !this.activity.equals(resolvedRequest.activity) : resolvedRequest.activity != null) {
                return false;
            }
            return !(this.placeRequest != null ? !this.placeRequest.equals(resolvedRequest.placeRequest) : resolvedRequest.placeRequest != null);
        }

        public int hashCode() {
            int result = 0;
            result = this.activity != null ? this.activity.hashCode() : 0;
            result = 31 * result + (this.placeRequest != null ? this.placeRequest.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "{activity=" + this.activity + ", placeRequest=" + this.placeRequest + "}";
        }
    }
}

