/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl.graphmatching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.rdf.core.impl.graphmatching.PermutationIterator;

class MappingIterator<T, U>
implements Iterator<Map<T, U>> {
    private List<T> list1;
    private Iterator<List<U>> permutationList2Iterator;

    public MappingIterator(Set<T> set1, Set<U> set2) {
        if (set1.size() != set2.size()) {
            throw new IllegalArgumentException();
        }
        this.list1 = new ArrayList<T>(set1);
        this.permutationList2Iterator = new PermutationIterator<U>(new ArrayList<U>(set2));
    }

    @Override
    public boolean hasNext() {
        return this.permutationList2Iterator.hasNext();
    }

    @Override
    public Map<T, U> next() {
        List<U> list2 = this.permutationList2Iterator.next();
        HashMap<T, U> result = new HashMap<T, U>(this.list1.size());
        for (int i = 0; i < this.list1.size(); ++i) {
            result.put(this.list1.get(i), list2.get(i));
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

