/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.event.FilterTriple;
import org.apache.clerezza.rdf.core.event.GraphListener;

public class PrivilegedTripleCollectionWrapper
implements TripleCollection {
    private TripleCollection tripleCollection;

    public PrivilegedTripleCollectionWrapper(TripleCollection tripleCollection) {
        this.tripleCollection = tripleCollection;
    }

    @Override
    public Iterator<Triple> filter(final NonLiteral subject, final UriRef predicate, final Resource object) {
        return AccessController.doPrivileged(new PrivilegedAction<Iterator<Triple>>(){

            @Override
            public Iterator<Triple> run() {
                return PrivilegedTripleCollectionWrapper.this.tripleCollection.filter(subject, predicate, object);
            }
        });
    }

    @Override
    public int size() {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return PrivilegedTripleCollectionWrapper.this.tripleCollection.size();
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return PrivilegedTripleCollectionWrapper.this.tripleCollection.isEmpty();
            }
        });
    }

    @Override
    public boolean contains(final Object o) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return PrivilegedTripleCollectionWrapper.this.tripleCollection.contains(o);
            }
        });
    }

    @Override
    public Iterator<Triple> iterator() {
        return AccessController.doPrivileged(new PrivilegedAction<Iterator<Triple>>(){

            @Override
            public Iterator<Triple> run() {
                return PrivilegedTripleCollectionWrapper.this.tripleCollection.iterator();
            }
        });
    }

    @Override
    public Object[] toArray() {
        return AccessController.doPrivileged(new PrivilegedAction<Object[]>(){

            @Override
            public Object[] run() {
                return PrivilegedTripleCollectionWrapper.this.tripleCollection.toArray();
            }
        });
    }

    @Override
    public <T> T[] toArray(final T[] a) {
        return AccessController.doPrivileged(new PrivilegedAction<T[]>(){

            @Override
            public T[] run() {
                return PrivilegedTripleCollectionWrapper.this.tripleCollection.toArray(a);
            }
        });
    }

    @Override
    public boolean add(final Triple triple) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return PrivilegedTripleCollectionWrapper.this.tripleCollection.add(triple);
            }
        });
    }

    @Override
    public boolean remove(final Object o) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return PrivilegedTripleCollectionWrapper.this.tripleCollection.remove(o);
            }
        });
    }

    @Override
    public boolean containsAll(final Collection<?> c) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return PrivilegedTripleCollectionWrapper.this.tripleCollection.containsAll(c);
            }
        });
    }

    @Override
    public boolean addAll(final Collection<? extends Triple> c) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return PrivilegedTripleCollectionWrapper.this.tripleCollection.addAll(c);
            }
        });
    }

    @Override
    public boolean removeAll(final Collection<?> c) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return PrivilegedTripleCollectionWrapper.this.tripleCollection.removeAll(c);
            }
        });
    }

    @Override
    public boolean retainAll(final Collection<?> c) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return PrivilegedTripleCollectionWrapper.this.tripleCollection.retainAll(c);
            }
        });
    }

    @Override
    public void clear() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                PrivilegedTripleCollectionWrapper.this.tripleCollection.clear();
                return null;
            }
        });
    }

    @Override
    public void addGraphListener(GraphListener listener, FilterTriple filter, long delay) {
        this.tripleCollection.addGraphListener(listener, filter, delay);
    }

    @Override
    public void addGraphListener(GraphListener listener, FilterTriple filter) {
        this.tripleCollection.addGraphListener(listener, filter);
    }

    @Override
    public void removeGraphListener(GraphListener listener) {
        this.tripleCollection.removeGraphListener(listener);
    }

    private static class PriviledgedTripleIterator
    implements Iterator<Triple> {
        private final Iterator<Triple> wrappedIterator;

        public PriviledgedTripleIterator(Iterator<Triple> wrappedIterator) {
            this.wrappedIterator = wrappedIterator;
        }

        @Override
        public boolean hasNext() {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return PriviledgedTripleIterator.this.wrappedIterator.hasNext();
                }
            });
        }

        @Override
        public Triple next() {
            return AccessController.doPrivileged(new PrivilegedAction<Triple>(){

                @Override
                public Triple run() {
                    return (Triple)PriviledgedTripleIterator.this.wrappedIterator.next();
                }
            });
        }

        @Override
        public void remove() {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    PriviledgedTripleIterator.this.wrappedIterator.remove();
                    return null;
                }
            });
        }
    }
}

