/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.backend;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.annotations.Customizable;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.PreferenceStore;
import org.uberfire.preferences.shared.annotations.PortablePreference;
import org.uberfire.preferences.shared.annotations.Property;
import org.uberfire.preferences.shared.annotations.WorkbenchPreference;
import org.uberfire.preferences.shared.bean.BasePreference;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.bean.Preference;
import org.uberfire.preferences.shared.bean.PreferenceBeanServerStore;
import org.uberfire.preferences.shared.bean.PreferenceHierarchyElement;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;

@Service
public class PreferenceBeanStoreImpl
implements PreferenceBeanServerStore {
    private static final AnnotationLiteral<PortablePreference> portablePreferenceAnnotation = new AnnotationLiteral<PortablePreference>(){};
    private PreferenceStore preferenceStore;
    private PreferenceScopeResolutionStrategy defaultScopeResolutionStrategy;
    private Instance<Preference> preferences;
    private Map<String, List<BasePreferencePortable>> childrenByParent;

    public PreferenceBeanStoreImpl() {
    }

    @Inject
    public PreferenceBeanStoreImpl(PreferenceStore preferenceStore, @Customizable PreferenceScopeResolutionStrategy defaultScopeResolutionStrategy, @PortablePreference Instance<Preference> preferences) {
        this.preferenceStore = preferenceStore;
        this.defaultScopeResolutionStrategy = defaultScopeResolutionStrategy;
        this.preferences = preferences;
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> T load(T emptyPortablePreference) {
        return this.load(emptyPortablePreference, this.defaultScopeResolutionStrategy.getInfo());
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> T load(T emptyPortablePreference, PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo) {
        Class clazz = emptyPortablePreference.getPojoClass();
        BasePreferencePortable portablePreference = (BasePreferencePortable)this.preferenceStore.get(scopeResolutionStrategyInfo, emptyPortablePreference.identifier());
        try {
            return (T)this.load(clazz, portablePreference, scopeResolutionStrategyInfo);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void load(T emptyPortablePreference, ParameterizedCommand<T> successCallback, ParameterizedCommand<Throwable> errorCallback) {
        this.load(emptyPortablePreference, this.defaultScopeResolutionStrategy.getInfo(), successCallback, errorCallback);
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void load(T emptyPortablePreference, PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, ParameterizedCommand<T> successCallback, ParameterizedCommand<Throwable> errorCallback) {
        Object loadedPreference;
        block3: {
            loadedPreference = null;
            try {
                loadedPreference = this.load(emptyPortablePreference, scopeResolutionStrategyInfo);
            }
            catch (Exception e) {
                if (errorCallback == null) break block3;
                errorCallback.execute((Object)e);
            }
        }
        if (successCallback != null) {
            successCallback.execute(loadedPreference);
        }
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void save(T portablePreference) {
        this.save(portablePreference, this.defaultScopeResolutionStrategy.getInfo());
    }

    private <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void save(T portablePreference, PreferenceScope scope) {
        try {
            Class clazz = portablePreference.getPojoClass();
            this.save(clazz, portablePreference, scope);
            if (portablePreference.isPersistable()) {
                this.preferenceStore.put(scope, portablePreference.identifier(), portablePreference);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void save(T portablePreference, PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo) {
        this.save(portablePreference, scopeResolutionStrategyInfo.defaultScope());
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void save(T portablePreference, Command successCallback, ParameterizedCommand<Throwable> errorCallback) {
        this.save(portablePreference, this.defaultScopeResolutionStrategy.getInfo(), successCallback, errorCallback);
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void save(T portablePreference, PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, Command successCallback, ParameterizedCommand<Throwable> errorCallback) {
        block3: {
            try {
                this.save(portablePreference, scopeResolutionStrategyInfo);
            }
            catch (Exception e) {
                if (errorCallback == null) break block3;
                errorCallback.execute((Object)e);
            }
        }
        if (successCallback != null) {
            successCallback.execute();
        }
    }

    public void save(Collection<BasePreferencePortable<? extends BasePreference<?>>> portablePreferences) {
        this.save(portablePreferences, this.defaultScopeResolutionStrategy.getInfo());
    }

    public void save(Collection<BasePreferencePortable<? extends BasePreference<?>>> portablePreferences, PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo) {
        for (BasePreferencePortable<BasePreference<?>> basePreferencePortable : portablePreferences) {
            this.saveOne(basePreferencePortable, scopeResolutionStrategyInfo.defaultScope());
        }
    }

    public void save(Collection<BasePreferencePortable<? extends BasePreference<?>>> portablePreferences, Command successCallback, ParameterizedCommand<Throwable> errorCallback) {
        this.save(portablePreferences, this.defaultScopeResolutionStrategy.getInfo(), successCallback, errorCallback);
    }

    public void save(Collection<BasePreferencePortable<? extends BasePreference<?>>> portablePreferences, PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo, Command successCallback, ParameterizedCommand<Throwable> errorCallback) {
        block3: {
            try {
                this.save(portablePreferences, scopeResolutionStrategyInfo);
            }
            catch (Exception e) {
                if (errorCallback == null) break block3;
                errorCallback.execute((Object)e);
            }
        }
        if (successCallback != null) {
            successCallback.execute();
        }
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void saveDefaultValue(T defaultValue) {
        List scopeOrder = this.defaultScopeResolutionStrategy.getInfo().order();
        int lastIndex = scopeOrder.size() - 1;
        PreferenceScope lastScope = (PreferenceScope)scopeOrder.get(lastIndex);
        this.save(defaultValue, lastScope);
    }

    public <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void saveDefaultValue(T defaultValue, Command successCallback, ParameterizedCommand<Throwable> errorCallback) {
        block3: {
            try {
                this.saveDefaultValue(defaultValue);
            }
            catch (Exception e) {
                if (errorCallback == null) break block3;
                errorCallback.execute((Object)e);
            }
        }
        if (successCallback != null) {
            successCallback.execute();
        }
    }

    public PreferenceHierarchyElement<?> buildHierarchyStructureForPreference(String identifier) {
        return this.buildHierarchyStructureForPreference(identifier, this.defaultScopeResolutionStrategy.getInfo());
    }

    public PreferenceHierarchyElement<?> buildHierarchyStructureForPreference(String identifier, PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo) {
        BasePreferencePortable preference = this.getPortablePreferenceByIdentifier(identifier);
        preference = this.load(preference, scopeResolutionStrategyInfo);
        PreferenceHierarchyElement rootElement = this.buildHierarchyElement(preference, null, false, true, preference.bundleKey(), scopeResolutionStrategyInfo);
        return rootElement;
    }

    private <U extends BasePreference<U>, T extends BasePreferencePortable<U>> T load(Class<U> clazz, T portablePreference, PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo) throws IllegalAccessException {
        if (portablePreference == null) {
            portablePreference = this.lookupPortablePreference(clazz);
        }
        for (Field field : portablePreference.getPojoClass().getDeclaredFields()) {
            Property propertyAnnotation = field.getAnnotation(Property.class);
            if (propertyAnnotation == null || !field.getType().isAnnotationPresent(WorkbenchPreference.class)) continue;
            Class<?> propertyType = field.getType();
            boolean shared = propertyAnnotation.shared();
            field.setAccessible(true);
            if (shared) {
                T loadedSharedProperty = this.loadSharedPreference(field, scopeResolutionStrategyInfo);
                field.set(portablePreference, loadedSharedProperty);
                continue;
            }
            T subPreferenceValue = this.loadSubPreferenceValue(portablePreference, field, scopeResolutionStrategyInfo);
            field.set(portablePreference, subPreferenceValue);
        }
        return portablePreference;
    }

    private <U extends BasePreference<U>, T extends BasePreferencePortable<U>> T loadSharedPreference(Field field, PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo) {
        BasePreferencePortable loadedPreference;
        Class<?> propertyType = field.getType();
        try {
            T emptyPortablePreference = this.lookupPortablePreference(propertyType);
            BasePreferencePortable portablePreference = (BasePreferencePortable)this.preferenceStore.get(scopeResolutionStrategyInfo, emptyPortablePreference.identifier());
            loadedPreference = this.load(propertyType, portablePreference, scopeResolutionStrategyInfo);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)loadedPreference;
    }

    private <U extends BasePreference<U>, T extends BasePreferencePortable<U>> T loadSubPreferenceValue(Object portablePreference, Field field, PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo) throws IllegalAccessException {
        Class<?> propertyType = field.getType();
        BasePreferencePortable subPreferenceValue = (BasePreferencePortable)field.get(portablePreference);
        return (T)this.load(propertyType, subPreferenceValue, scopeResolutionStrategyInfo);
    }

    private <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void save(Class<U> clazz, T portablePreference, PreferenceScope scope) throws IllegalAccessException {
        for (Field field : portablePreference.getPojoClass().getDeclaredFields()) {
            Property propertyAnnotation = field.getAnnotation(Property.class);
            if (propertyAnnotation == null || !field.getType().isAnnotationPresent(WorkbenchPreference.class)) continue;
            boolean shared = propertyAnnotation.shared();
            field.setAccessible(true);
            if (shared) {
                this.saveSharedPreference(portablePreference, field, scope);
                continue;
            }
            this.saveSubPreference(portablePreference, field, scope);
        }
    }

    private <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void saveSharedPreference(Object portablePreference, Field field, PreferenceScope scope) throws IllegalAccessException {
        Class<?> propertyType = field.getType();
        BasePreferencePortable sharedPropertyValue = (BasePreferencePortable)field.get(portablePreference);
        this.save(sharedPropertyValue, scope);
    }

    private <U extends BasePreference<U>, T extends BasePreferencePortable<U>> void saveSubPreference(Object portablePreference, Field field, PreferenceScope scope) throws IllegalAccessException {
        Class<?> propertyType = field.getType();
        BasePreferencePortable subPreferenceValue = (BasePreferencePortable)field.get(portablePreference);
        this.save(propertyType, subPreferenceValue, scope);
    }

    private <T extends BasePreference<T>> void saveOne(BasePreferencePortable<?> portablePreference, PreferenceScope scope) {
        Class clazz = portablePreference.getPojoClass();
        try {
            this.save(clazz, portablePreference, scope);
            if (portablePreference.isPersistable()) {
                this.preferenceStore.put(scope, portablePreference.identifier(), portablePreference);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private List<BasePreferencePortable> getAnnotatedChildren(String parentIdentifier) {
        if (this.childrenByParent == null) {
            this.childrenByParent = new HashMap<String, List<BasePreferencePortable>>();
            Iterable<Preference> portablePreferences = this.getPortablePreferences();
            portablePreferences.forEach(preference -> {
                String[] parents;
                BasePreferencePortable portablePreference = (BasePreferencePortable)preference;
                for (String parent : parents = portablePreference.parents()) {
                    if (!(parent != null & !parent.isEmpty())) continue;
                    List<BasePreferencePortable> children = this.childrenByParent.get(parent);
                    if (children == null) {
                        children = new ArrayList<BasePreferencePortable>();
                        this.childrenByParent.put(parent, children);
                    }
                    children.add(portablePreference);
                }
            });
        }
        return this.childrenByParent.get(parentIdentifier);
    }

    private <T> PreferenceHierarchyElement<T> buildHierarchyElement(BasePreferencePortable<T> portablePreference, PreferenceHierarchyElement<?> parent, boolean shared, boolean root, String bundleKey, PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo) {
        PreferenceHierarchyElement hierarchyElement = new PreferenceHierarchyElement(UUID.randomUUID().toString(), portablePreference, shared, root, bundleKey);
        this.buildHierarchyElementForAnnotatedChildren(portablePreference, hierarchyElement, scopeResolutionStrategyInfo);
        try {
            hierarchyElement.setPortablePreference(portablePreference);
            for (Field field : portablePreference.getPojoClass().getDeclaredFields()) {
                Property propertyAnnotation = field.getAnnotation(Property.class);
                if (propertyAnnotation == null) continue;
                String propertyBundleKey = "";
                if (!propertyAnnotation.bundleKey().isEmpty()) {
                    propertyBundleKey = propertyAnnotation.bundleKey();
                }
                if (field.getType().isAnnotationPresent(WorkbenchPreference.class)) {
                    field.setAccessible(true);
                    BasePreferencePortable fieldValue = (BasePreferencePortable)field.get(portablePreference);
                    if (propertyBundleKey.isEmpty()) {
                        propertyBundleKey = fieldValue.bundleKey();
                    }
                    PreferenceHierarchyElement<T> childElement = this.buildHierarchyElement(fieldValue, hierarchyElement, propertyAnnotation.shared(), false, propertyBundleKey, scopeResolutionStrategyInfo);
                    hierarchyElement.getChildren().add(childElement);
                    continue;
                }
                if (propertyBundleKey.isEmpty()) {
                    propertyBundleKey = field.getName();
                }
                hierarchyElement.addPropertyBundleKey(field.getName(), propertyBundleKey);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return hierarchyElement;
    }

    private <T> void buildHierarchyElementForAnnotatedChildren(BasePreferencePortable<T> portablePreference, PreferenceHierarchyElement<T> hierarchyElement, PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo) {
        List<BasePreferencePortable> annotatedChildren = this.getAnnotatedChildren(portablePreference.identifier());
        if (annotatedChildren != null) {
            annotatedChildren.forEach(childPreference -> {
                BasePreferencePortable loadedChild = this.load(childPreference, scopeResolutionStrategyInfo);
                PreferenceHierarchyElement childElement = this.buildHierarchyElement(loadedChild, hierarchyElement, false, true, childPreference.bundleKey(), scopeResolutionStrategyInfo);
                hierarchyElement.getChildren().add(childElement);
            });
        }
    }

    BasePreferencePortable getPortablePreferenceByIdentifier(String identifier) {
        for (Preference preference : this.getPortablePreferences()) {
            BasePreferencePortable portablePreference = (BasePreferencePortable)preference;
            if (!portablePreference.identifier().equals(identifier)) continue;
            return portablePreference;
        }
        return null;
    }

    Iterable<Preference> getPortablePreferences() {
        return this.preferences.select(new Annotation[]{portablePreferenceAnnotation});
    }

    <U extends BasePreference<U>, T extends BasePreferencePortable<U>> T lookupPortablePreference(Class<U> clazz) {
        return (T)((BasePreferencePortable)this.preferences.select(clazz, new Annotation[]{portablePreferenceAnnotation}).get());
    }
}

