/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.menu;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.resources.i18n.WorkbenchConstants;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.events.PlaceMaximizedEvent;
import org.uberfire.client.workbench.events.PlaceMinimizedEvent;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBar;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@Dependent
public class WorkbenchViewModeSwitcherPresenter
implements IsWidget {
    private final WorkbenchMenuBar menubar;
    private final View view;
    private WorkbenchConstants constants = WorkbenchConstants.INSTANCE;
    private Command collapseCommand;
    private Command expandCommand;

    @Inject
    public WorkbenchViewModeSwitcherPresenter(final View view, final WorkbenchMenuBar menubar) {
        this.view = (View)PortablePreconditions.checkNotNull((String)"view", (Object)view);
        this.menubar = (WorkbenchMenuBar)PortablePreconditions.checkNotNull((String)"menubar", (Object)menubar);
        view.init(this);
        view.setText(this.constants.switchToCompactView());
        view.addClickHandler(new Command(){

            public void execute() {
                if (menubar.isExpanded()) {
                    menubar.collapse();
                    if (WorkbenchViewModeSwitcherPresenter.this.collapseCommand != null) {
                        WorkbenchViewModeSwitcherPresenter.this.collapseCommand.execute();
                    }
                } else {
                    menubar.expand();
                    if (WorkbenchViewModeSwitcherPresenter.this.expandCommand != null) {
                        WorkbenchViewModeSwitcherPresenter.this.expandCommand.execute();
                    }
                }
            }
        });
        menubar.addCollapseHandler(new Command(){

            public void execute() {
                view.setText(WorkbenchViewModeSwitcherPresenter.this.constants.switchToDefaultView());
            }
        });
        menubar.addExpandHandler(new Command(){

            public void execute() {
                view.setText(WorkbenchViewModeSwitcherPresenter.this.constants.switchToCompactView());
            }
        });
    }

    public void setCollapseHandler(Command command) {
        this.collapseCommand = command;
    }

    public void setExpandHandler(Command command) {
        this.expandCommand = command;
    }

    protected void onPerspectiveChange(@Observes PerspectiveChange perspectiveChange) {
        this.view.enable();
    }

    protected void onPlaceMinimized(@Observes PlaceMinimizedEvent event) {
        this.view.enable();
    }

    protected void onPlaceMaximized(@Observes PlaceMaximizedEvent event) {
        this.view.disable();
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public static interface View
    extends UberView<WorkbenchViewModeSwitcherPresenter> {
        public void setText(String var1);

        public void enable();

        public void disable();

        public void addClickHandler(Command var1);
    }
}

