/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.menu.AuthFilterMenuVisitor;
import org.uberfire.client.views.pfly.menu.DropdownMenuVisitor;
import org.uberfire.client.views.pfly.menu.HasMenuItems;
import org.uberfire.client.workbench.widgets.menu.HasMenus;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
public class UserMenu
implements MenuFactory.CustomMenuBuilder,
HasMenus {
    @Inject
    private UserMenuView userMenuView;
    @Inject
    private User user;
    @Inject
    private AuthorizationManager authzManager;

    @PostConstruct
    protected void setup() {
        this.userMenuView.setUserName(this.formattedUsername());
    }

    public void addMenus(Menus menus) {
        menus.accept((MenuVisitor)new AuthFilterMenuVisitor(this.authzManager, this.user, (MenuVisitor)new DropdownMenuVisitor(this.userMenuView)));
    }

    private String formattedUsername() {
        StringBuilder sb = new StringBuilder();
        if (this.user.getProperty("org.jboss.errai.security.FIRST_NAME") != null) {
            sb.append(this.user.getProperty("org.jboss.errai.security.FIRST_NAME"));
        }
        if (this.user.getProperty("org.jboss.errai.security.LAST_NAME") != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(this.user.getProperty("org.jboss.errai.security.LAST_NAME"));
        }
        if (sb.length() == 0) {
            sb.append(this.user.getIdentifier());
        }
        return sb.toString();
    }

    public IsWidget getView() {
        return this.userMenuView;
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return new BaseMenuCustom<IsWidget>(){

            public IsWidget build() {
                return UserMenu.this.getView();
            }

            public MenuPosition getPosition() {
                return MenuPosition.RIGHT;
            }
        };
    }

    public static interface UserMenuView
    extends HasMenuItems {
        public void setUserName(String var1);
    }
}

