/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.wymiwyg.commons.util.ContentUnavailableException;
import org.wymiwyg.commons.util.HashStoreException;
import org.wymiwyg.commons.util.MD5;
import org.wymiwyg.commons.util.UnsupportedURIType;

public class HashStore {
    private static HashStore defaultStore;
    private File directory;

    public HashStore(File directory) {
        directory.mkdirs();
        this.directory = directory;
    }

    public InputStream getContent(URI uri) throws HashStoreException {
        File resultFile = this.getStoringFile(uri);
        try {
            return new FileInputStream(resultFile);
        }
        catch (FileNotFoundException e) {
            throw new ContentUnavailableException("No content for urn: " + uri);
        }
    }

    private File getStoringFile(URI uri) throws UnsupportedURIType {
        String schemeSpecific = uri.getSchemeSpecificPart();
        if (!schemeSpecific.startsWith("hash::md5")) {
            throw new UnsupportedURIType("must start with hash::md5");
        }
        String hash = schemeSpecific.substring(10);
        return new File(this.directory, hash);
    }

    public URI storeContent(byte[] content) throws IOException {
        File storingFile;
        URI imageContentURN;
        MD5 md5 = new MD5();
        byte[] hash = new byte[16];
        md5.update(content);
        md5.md5final(hash);
        String imageContentURNString = "urn:hash::md5:" + MD5.dumpBytes(hash);
        try {
            imageContentURN = new URI(imageContentURNString);
            storingFile = this.getStoringFile(imageContentURN);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        catch (UnsupportedURIType ex) {
            throw new RuntimeException(ex);
        }
        FileOutputStream out = new FileOutputStream(storingFile);
        out.write(content);
        out.close();
        return imageContentURN;
    }

    public void writeContent(URI uri, byte[] content) throws UnsupportedURIType, IOException {
        File storingFile = this.getStoringFile(uri);
        FileOutputStream out = new FileOutputStream(storingFile);
        out.write(content);
        out.close();
    }

    public long getSize(URI uri) throws HashStoreException {
        File resultFile = this.getStoringFile(uri);
        return resultFile.length();
    }

    public static HashStore getDefaultStore() {
        if (defaultStore == null) {
            File home = new File(System.getProperty("user.home"));
            File directory = new File(home, ".hashstore");
            directory.mkdir();
            HashStore.setDefaultStorePath(directory);
        }
        return defaultStore;
    }

    static void setDefaultStorePath(File directory) {
        defaultStore = new HashStore(directory);
    }
}

