/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils;

import java.io.StringWriter;
import java.util.BitSet;
import org.apache.clerezza.utils.Uri;
import org.apache.clerezza.utils.UriException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.util.EncodingUtils;

public class UriUtil {
    protected static final BitSet empty = new BitSet(1);

    public static String getName(String uri) {
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        String path = UriUtil.getPath(uri);
        int at = path.lastIndexOf("/");
        int to = path.length();
        return at >= 0 ? path.substring(at + 1, to) : path;
    }

    public static String getQuery(String uri) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        int at = uri.indexOf("//");
        int from = uri.indexOf("/", at >= 0 ? (uri.lastIndexOf("/", at - 1) >= 0 ? 0 : at + 2) : 0);
        int to = uri.length();
        at = uri.indexOf("?", from);
        if (at < 0) {
            return null;
        }
        from = at + 1;
        if (uri.lastIndexOf("#") > from) {
            to = uri.lastIndexOf("#");
        }
        return from < 0 || from == to ? null : uri.substring(from, to);
    }

    public static String getPath(String uri) {
        if (uri == null) {
            return null;
        }
        int at = uri.indexOf("//");
        int from = uri.indexOf("/", at >= 0 ? (uri.lastIndexOf("/", at - 1) >= 0 ? 0 : at + 2) : 0);
        int to = uri.length();
        if (uri.indexOf(63, from) != -1) {
            to = uri.indexOf(63, from);
        }
        if (uri.lastIndexOf("#") > from && uri.lastIndexOf("#") < to) {
            to = uri.lastIndexOf("#");
        }
        return from < 0 ? (at >= 0 ? "/" : uri) : uri.substring(from, to);
    }

    public static String getPathQuery(String uri) {
        if (uri == null) {
            return null;
        }
        int at = uri.indexOf("//");
        int from = uri.indexOf("/", at >= 0 ? (uri.lastIndexOf("/", at - 1) >= 0 ? 0 : at + 2) : 0);
        int to = uri.length();
        if (uri.lastIndexOf("#") > from) {
            to = uri.lastIndexOf("#");
        }
        return from < 0 ? (at >= 0 ? "/" : uri) : uri.substring(from, to);
    }

    public static String getFromPath(String uri) {
        if (uri == null) {
            return null;
        }
        int at = uri.indexOf("//");
        int from = uri.indexOf("/", at >= 0 ? (uri.lastIndexOf("/", at - 1) >= 0 ? 0 : at + 2) : 0);
        return from < 0 ? (at >= 0 ? "/" : uri) : uri.substring(from);
    }

    public static String encodeAll(String unescaped) throws UriException {
        return UriUtil.encodeAll(unescaped, Uri.getDefaultProtocolCharset());
    }

    public static String encodeAll(String unescaped, String charset) throws UriException {
        return UriUtil.encode(unescaped, empty, charset);
    }

    public static String encodePartlyEncodedPath(String partlyEscaped, String charset) throws UriException {
        StringWriter sw = new StringWriter();
        for (int i = 0; i < partlyEscaped.length(); ++i) {
            char c = partlyEscaped.charAt(i);
            if (c == '%') {
                try {
                    String hexString = partlyEscaped.substring(i + 1, i + 3);
                    Integer.parseInt(hexString, 16);
                    sw.append(c);
                    sw.append(hexString);
                    i += 2;
                    continue;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            sw.append(UriUtil.encodePath(String.valueOf(c), charset));
        }
        return sw.toString();
    }

    public static String encodeWithinAuthority(String unescaped) throws UriException {
        return UriUtil.encodeWithinAuthority(unescaped, Uri.getDefaultProtocolCharset());
    }

    public static String encodeWithinAuthority(String unescaped, String charset) throws UriException {
        return UriUtil.encode(unescaped, Uri.allowed_within_authority, charset);
    }

    public static String encodePathQuery(String unescaped) throws UriException {
        return UriUtil.encodePathQuery(unescaped, Uri.getDefaultProtocolCharset());
    }

    public static String encodePathQuery(String unescaped, String charset) throws UriException {
        int at = unescaped.indexOf(63);
        if (at < 0) {
            return UriUtil.encode(unescaped, Uri.allowed_abs_path, charset);
        }
        return UriUtil.encode(unescaped.substring(0, at), Uri.allowed_abs_path, charset) + '?' + UriUtil.encode(unescaped.substring(at + 1), Uri.allowed_query, charset);
    }

    public static String encodeWithinPath(String unescaped) throws UriException {
        return UriUtil.encodeWithinPath(unescaped, Uri.getDefaultProtocolCharset());
    }

    public static String encodeWithinPath(String unescaped, String charset) throws UriException {
        return UriUtil.encode(unescaped, Uri.allowed_within_path, charset);
    }

    public static String encodePath(String unescaped) throws UriException {
        return UriUtil.encodePath(unescaped, Uri.getDefaultProtocolCharset());
    }

    public static String encodePath(String unescaped, String charset) throws UriException {
        return UriUtil.encode(unescaped, Uri.allowed_abs_path, charset);
    }

    public static String encodeWithinQuery(String unescaped) throws UriException {
        return UriUtil.encodeWithinQuery(unescaped, Uri.getDefaultProtocolCharset());
    }

    public static String encodeWithinQuery(String unescaped, String charset) throws UriException {
        return UriUtil.encode(unescaped, Uri.allowed_within_query, charset);
    }

    public static String encodeQuery(String unescaped) throws UriException {
        return UriUtil.encodeQuery(unescaped, Uri.getDefaultProtocolCharset());
    }

    public static String encodeQuery(String unescaped, String charset) throws UriException {
        return UriUtil.encode(unescaped, Uri.allowed_query, charset);
    }

    public static String encode(String unescaped, BitSet allowed) throws UriException {
        return UriUtil.encode(unescaped, allowed, Uri.getDefaultProtocolCharset());
    }

    public static String encode(String unescaped, BitSet allowed, String charset) throws UriException {
        byte[] rawdata = URLCodec.encodeUrl((BitSet)allowed, (byte[])EncodingUtils.getBytes((String)unescaped, (String)charset));
        return EncodingUtils.getAsciiString((byte[])rawdata);
    }

    public static String decode(String escaped) throws UriException {
        try {
            byte[] rawdata = URLCodec.decodeUrl((byte[])EncodingUtils.getAsciiBytes((String)escaped));
            return EncodingUtils.getString((byte[])rawdata, (String)Uri.getDefaultProtocolCharset());
        }
        catch (DecoderException e) {
            throw new UriException(e.getMessage());
        }
    }

    public static String decode(String escaped, String charset) throws UriException {
        return Coder.decode(escaped.toCharArray(), charset);
    }

    protected static class Coder
    extends Uri {
        protected Coder() {
        }

        public static char[] encode(String unescapedComponent, BitSet allowed, String charset) throws UriException {
            return Uri.encode(unescapedComponent, allowed, charset);
        }

        public static String decode(char[] escapedComponent, String charset) throws UriException {
            return Uri.decode(escapedComponent, charset);
        }

        public static boolean verifyEscaped(char[] original) {
            for (int i = 0; i < original.length; ++i) {
                char c = original[i];
                if (c > '\u0080') {
                    return false;
                }
                if (c != '%' || Character.digit(original[++i], 16) != -1 && Character.digit(original[++i], 16) != -1) continue;
                return false;
            }
            return true;
        }

        public static String replace(String original, char[] from, char[] to) {
            for (int i = from.length; i > 0; --i) {
                original = Coder.replace(original, from[i], to[i]);
            }
            return original;
        }

        public static String replace(String original, char from, char to) {
            int at;
            StringBuffer result = new StringBuffer(original.length());
            int saved = 0;
            do {
                if ((at = original.indexOf(from)) >= 0) {
                    result.append(original.substring(0, at));
                    result.append(to);
                } else {
                    result.append(original.substring(saved));
                }
                saved = at;
            } while (at >= 0);
            return result.toString();
        }
    }
}

