/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.IdentityHashMap;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.uberfire.client.mvp.TemplatedActivity;
import org.uberfire.client.workbench.LayoutSelection;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.TemplatedWorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.workbench.model.NamedPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.Position;

@Dependent
@Named(value="TemplatedWorkbenchPanelView")
public class TemplatedWorkbenchPanelView
implements WorkbenchPanelView<TemplatedWorkbenchPanelPresenter> {
    private final IdentityHashMap<WorkbenchPanelView<?>, NamedPosition> childPanelPositions = new IdentityHashMap();
    private TemplatedWorkbenchPanelPresenter presenter;
    private TemplatedActivity activity;
    private String elementId;
    @Inject
    private LayoutSelection layoutSelection;

    public void init(TemplatedWorkbenchPanelPresenter presenter) {
        this.presenter = presenter;
    }

    public void setActivity(TemplatedActivity activity) {
        this.activity = (TemplatedActivity)PortablePreconditions.checkNotNull((String)"activity", (Object)activity);
        this.setElementId(this.elementId);
    }

    public Widget asWidget() {
        if (this.activity == null) {
            return null;
        }
        return ElementWrapperWidget.getWidget((HTMLElement)this.activity.getRootElement());
    }

    public void onResize() {
        Widget root = this.asWidget();
        if (root instanceof RequiresResize) {
            ((RequiresResize)root).onResize();
        }
    }

    @Override
    public TemplatedWorkbenchPanelPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    public void addPanel(PanelDefinition panel, WorkbenchPanelView<?> view, Position p) {
        NamedPosition position = (NamedPosition)p;
        HTMLElement panelContainer = this.activity.resolvePosition(position);
        if (panelContainer.hasChildNodes()) {
            GWT.log((String)("----> " + panelContainer.getInnerHTML()));
            throw new IllegalStateException("Child position " + position + " is already occupied");
        }
        DOMUtil.appendWidgetToElement((HTMLElement)panelContainer, (Widget)view.asWidget());
        this.childPanelPositions.put(view, position);
    }

    @Override
    public boolean removePanel(WorkbenchPanelView<?> child) {
        NamedPosition removedFromPosition = this.childPanelPositions.remove(child);
        if (removedFromPosition == null) {
            return false;
        }
        HTMLElement panelContainer = this.activity.resolvePosition(removedFromPosition);
        DOMUtil.removeAllChildren((Node)panelContainer);
        return true;
    }

    @Override
    public void setFocus(boolean hasFocus) {
    }

    @Override
    public void addPart(WorkbenchPartPresenter.View view) {
        throw new UnsupportedOperationException("This view doesn't support parts");
    }

    @Override
    public Collection<PartDefinition> getParts() {
        throw new UnsupportedOperationException("This view doesn't support parts");
    }

    @Override
    public void changeTitle(PartDefinition part, String title, IsWidget titleDecoration) {
        throw new UnsupportedOperationException("This view doesn't support parts");
    }

    @Override
    public boolean selectPart(PartDefinition part) {
        throw new UnsupportedOperationException("This view doesn't support parts");
    }

    @Override
    public boolean removePart(PartDefinition part) {
        throw new UnsupportedOperationException("This view doesn't support parts");
    }

    @Override
    public Widget getPartDropRegion() {
        return null;
    }

    @Override
    public void setElementId(String elementId) {
        this.elementId = elementId;
        if (this.asWidget() != null && elementId != null) {
            this.asWidget().getElement().setAttribute("id", elementId);
        }
    }

    @Override
    public void maximize() {
        this.layoutSelection.get().maximize(this.asWidget());
    }

    @Override
    public void unmaximize() {
        this.layoutSelection.get().unmaximize(this.asWidget());
    }
}

