/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.base.Function;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.controller.strategy.AutoRebalanceStrategy;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.TaskRebalancer;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;

public class GenericTaskRebalancer
extends TaskRebalancer {
    private RetryPolicy _retryPolicy = new DefaultRetryReassigner();

    @Override
    public Set<Integer> getAllTaskPartitions(JobConfig jobCfg, JobContext jobCtx, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, ClusterDataCache cache) {
        Map<String, TaskConfig> taskMap = jobCfg.getTaskConfigMap();
        Map<String, Integer> taskIdMap = jobCtx.getTaskIdPartitionMap();
        for (TaskConfig taskCfg : taskMap.values()) {
            String taskId = taskCfg.getId();
            int nextPartition = jobCtx.getPartitionSet().size();
            if (taskIdMap.containsKey(taskId)) continue;
            jobCtx.setTaskIdForPartition(nextPartition, taskId);
        }
        return jobCtx.getPartitionSet();
    }

    @Override
    public Map<String, SortedSet<Integer>> getTaskAssignment(CurrentStateOutput currStateOutput, ResourceAssignment prevAssignment, Collection<String> instances, JobConfig jobCfg, JobContext jobContext, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, Set<Integer> partitionSet, ClusterDataCache cache) {
        LinkedHashMap<String, Integer> states = new LinkedHashMap<String, Integer>();
        states.put("ONLINE", 1);
        HashSet honoredStates = Sets.newHashSet((Object[])new TaskPartitionState[]{TaskPartitionState.INIT, TaskPartitionState.RUNNING, TaskPartitionState.STOPPED});
        HashSet filteredPartitionSet = Sets.newHashSet();
        for (Integer p : partitionSet) {
            TaskPartitionState state;
            TaskPartitionState taskPartitionState = state = jobContext == null ? null : jobContext.getPartitionState(p);
            if (state != null && !honoredStates.contains((Object)state)) continue;
            filteredPartitionSet.add(p);
        }
        ArrayList partitionNums = Lists.newArrayList(partitionSet);
        Collections.sort(partitionNums);
        final String resourceId = prevAssignment.getResourceName();
        ArrayList<String> partitions = new ArrayList<String>(Lists.transform((List)partitionNums, (Function)new Function<Integer, String>(){

            public String apply(Integer partitionNum) {
                return resourceId + "_" + partitionNum;
            }
        }));
        HashMap currentMapping = Maps.newHashMap();
        for (Partition partition : currStateOutput.getCurrentStateMappedPartitions(resourceId)) {
            if (!filteredPartitionSet.contains(GenericTaskRebalancer.pId(partition.getPartitionName()))) continue;
            HashMap allPreviousDecisionMap = Maps.newHashMap();
            if (prevAssignment != null) {
                allPreviousDecisionMap.putAll(prevAssignment.getReplicaMap(partition));
            }
            allPreviousDecisionMap.putAll(currStateOutput.getCurrentStateMap(resourceId, partition));
            allPreviousDecisionMap.putAll(currStateOutput.getPendingStateMap(resourceId, partition));
            currentMapping.put(partition.getPartitionName(), allPreviousDecisionMap);
        }
        AutoRebalanceStrategy strategy = new AutoRebalanceStrategy(resourceId, partitions, states, Integer.MAX_VALUE, new AutoRebalanceStrategy.DefaultPlacementScheme());
        ArrayList allNodes = Lists.newArrayList(this.getEligibleInstances(jobCfg, currStateOutput, instances, cache));
        Collections.sort(allNodes);
        ZNRecord record = strategy.computePartitionAssignment(allNodes, currentMapping, allNodes);
        Map<String, List<String>> preferenceLists = record.getListFields();
        Map<Object, Object> taskAssignment = Maps.newHashMap();
        for (Map.Entry<String, List<String>> e : preferenceLists.entrySet()) {
            String partitionName = e.getKey();
            partitionName = String.valueOf(GenericTaskRebalancer.pId(partitionName));
            List<String> preferenceList = e.getValue();
            for (String participantName : preferenceList) {
                if (!taskAssignment.containsKey(participantName)) {
                    taskAssignment.put(participantName, new TreeSet());
                }
                ((SortedSet)taskAssignment.get(participantName)).add(Integer.valueOf(partitionName));
            }
        }
        taskAssignment = this._retryPolicy.reassign(jobCfg, jobContext, allNodes, (Map<String, SortedSet<Integer>>)taskAssignment);
        return taskAssignment;
    }

    private Set<String> getEligibleInstances(JobConfig jobCfg, CurrentStateOutput currStateOutput, Iterable<String> instances, ClusterDataCache cache) {
        HashSet allInstances = Sets.newHashSet(instances);
        String targetResource = jobCfg.getTargetResource();
        if (targetResource == null) {
            return allInstances;
        }
        IdealState idealState = cache.getIdealState(targetResource);
        if (idealState == null) {
            return Collections.emptySet();
        }
        Set<String> partitions = idealState.getPartitionSet();
        List<String> targetPartitions = jobCfg.getTargetPartitions();
        if (targetPartitions != null && !targetPartitions.isEmpty()) {
            partitions.retainAll(targetPartitions);
        }
        HashSet eligibleInstances = Sets.newHashSet();
        Set<String> targetStates = jobCfg.getTargetPartitionStates();
        for (String partition : partitions) {
            Map<String, String> stateMap = currStateOutput.getCurrentStateMap(targetResource, new Partition(partition));
            Map<String, String> pendingStateMap = currStateOutput.getPendingStateMap(targetResource, new Partition(partition));
            for (Map.Entry<String, String> e : stateMap.entrySet()) {
                String instanceName = e.getKey();
                String state = e.getValue();
                String pending = pendingStateMap.get(instanceName);
                if (pending != null || targetStates != null && !targetStates.isEmpty() && !targetStates.contains(state)) continue;
                eligibleInstances.add(instanceName);
            }
        }
        allInstances.retainAll(eligibleInstances);
        return allInstances;
    }

    private static class DefaultRetryReassigner
    implements RetryPolicy {
        private DefaultRetryReassigner() {
        }

        @Override
        public Map<String, SortedSet<Integer>> reassign(JobConfig jobCfg, JobContext jobCtx, Collection<String> instances, Map<String, SortedSet<Integer>> origAssignment) {
            HashBiMap instanceMap = HashBiMap.create((int)instances.size());
            int instanceIndex = 0;
            for (String instance : instances) {
                instanceMap.put((Object)instance, (Object)instanceIndex++);
            }
            HashMap newAssignment = Maps.newHashMap();
            for (Map.Entry<String, SortedSet<Integer>> e : origAssignment.entrySet()) {
                String instance = e.getKey();
                SortedSet<Integer> partitions = e.getValue();
                Integer instanceId = (Integer)instanceMap.get((Object)instance);
                if (instanceId != null) {
                    Iterator i$ = partitions.iterator();
                    while (i$.hasNext()) {
                        int p = (Integer)i$.next();
                        int shiftValue = this.getNumInstancesToShift(jobCfg, jobCtx, instances, p);
                        int newInstanceId = (instanceId + shiftValue) % instances.size();
                        String newInstance = (String)instanceMap.inverse().get((Object)newInstanceId);
                        if (newInstance == null) {
                            newInstance = instance;
                        }
                        if (!newAssignment.containsKey(newInstance)) {
                            newAssignment.put(newInstance, new TreeSet());
                        }
                        ((SortedSet)newAssignment.get(newInstance)).add(p);
                    }
                    continue;
                }
                newAssignment.put(instance, partitions);
            }
            return newAssignment;
        }

        private int getNumInstancesToShift(JobConfig jobCfg, JobContext jobCtx, Collection<String> instances, int p) {
            int numAttempts = jobCtx.getPartitionNumAttempts(p);
            int maxNumAttempts = jobCfg.getMaxAttemptsPerTask();
            int numInstances = Math.min(instances.size(), jobCfg.getMaxForcedReassignmentsPerTask() + 1);
            return numAttempts / (maxNumAttempts / numInstances);
        }
    }

    public static interface RetryPolicy {
        public Map<String, SortedSet<Integer>> reassign(JobConfig var1, JobContext var2, Collection<String> var3, Map<String, SortedSet<Integer>> var4);
    }
}

