/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.pipeline;

import java.util.ArrayList;
import java.util.List;
import org.apache.helix.controller.pipeline.Stage;
import org.apache.helix.controller.pipeline.StageContext;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.log4j.Logger;

public class Pipeline {
    private static final Logger logger = Logger.getLogger((String)Pipeline.class.getName());
    List<Stage> _stages = new ArrayList<Stage>();

    public void addStage(Stage stage) {
        this._stages.add(stage);
        StageContext context = null;
        stage.init(context);
    }

    public void handle(ClusterEvent event) throws Exception {
        if (this._stages == null) {
            return;
        }
        for (Stage stage : this._stages) {
            stage.preProcess();
            stage.process(event);
            stage.postProcess();
        }
    }

    public void finish() {
    }

    public List<Stage> getStages() {
        return this._stages;
    }
}

