/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Map;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.rebalancer.AutoRebalancer;
import org.apache.helix.controller.rebalancer.CustomRebalancer;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.rebalancer.SemiAutoRebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.helix.util.HelixUtil;
import org.apache.log4j.Logger;

public class BestPossibleStateCalcStage
extends AbstractBaseStage {
    private static final Logger logger = Logger.getLogger((String)BestPossibleStateCalcStage.class.getName());

    @Override
    public void process(ClusterEvent event) throws Exception {
        long startTime = System.currentTimeMillis();
        logger.info((Object)"START BestPossibleStateCalcStage.process()");
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.toString());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.toString());
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        if (currentStateOutput == null || resourceMap == null || cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires CURRENT_STATE|RESOURCES|DataCache");
        }
        BestPossibleStateOutput bestPossibleStateOutput = this.compute(event, resourceMap, currentStateOutput);
        event.addAttribute(AttributeName.BEST_POSSIBLE_STATE.name(), bestPossibleStateOutput);
        try {
            ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute("clusterStatusMonitor");
            if (clusterStatusMonitor != null) {
                clusterStatusMonitor.setPerInstanceResourceStatus(bestPossibleStateOutput, cache.getInstanceConfigMap(), resourceMap, cache.getStateModelDefMap());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not update cluster status metrics!", (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        logger.info((Object)("END BestPossibleStateCalcStage.process(). took: " + (endTime - startTime) + " ms"));
    }

    private BestPossibleStateOutput compute(ClusterEvent event, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput) {
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        BestPossibleStateOutput output = new BestPossibleStateOutput();
        for (String resourceName : resourceMap.keySet()) {
            logger.debug((Object)("Processing resource:" + resourceName));
            Resource resource = resourceMap.get(resourceName);
            IdealState idealState = cache.getIdealState(resourceName);
            if (idealState == null) {
                logger.info((Object)("resource:" + resourceName + " does not exist anymore"));
                idealState = new IdealState(resourceName);
                idealState.setStateModelDefRef(resource.getStateModelDefRef());
            }
            Rebalancer rebalancer = null;
            MappingCalculator mappingCalculator = null;
            switch (idealState.getRebalanceMode()) {
                case FULL_AUTO: {
                    AutoRebalancer autoRebalancer = new AutoRebalancer();
                    rebalancer = autoRebalancer;
                    mappingCalculator = autoRebalancer;
                    break;
                }
                case SEMI_AUTO: {
                    SemiAutoRebalancer semiAutoRebalancer = new SemiAutoRebalancer();
                    rebalancer = semiAutoRebalancer;
                    mappingCalculator = semiAutoRebalancer;
                    break;
                }
                case CUSTOMIZED: {
                    CustomRebalancer customRebalancer = new CustomRebalancer();
                    rebalancer = customRebalancer;
                    mappingCalculator = customRebalancer;
                    break;
                }
                case USER_DEFINED: 
                case TASK: {
                    String rebalancerClassName = idealState.getRebalancerClassName();
                    logger.info((Object)("resource " + resourceName + " use idealStateRebalancer " + rebalancerClassName));
                    try {
                        rebalancer = (Rebalancer)Rebalancer.class.cast(HelixUtil.loadClass(this.getClass(), rebalancerClassName).newInstance());
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Exception while invoking custom rebalancer class:" + rebalancerClassName), (Throwable)e);
                    }
                    if (rebalancer != null) {
                        try {
                            mappingCalculator = (MappingCalculator)MappingCalculator.class.cast(rebalancer);
                        }
                        catch (ClassCastException e) {
                            logger.info((Object)"Rebalancer does not have a mapping calculator, defaulting to SEMI_AUTO");
                        }
                    }
                    if (mappingCalculator != null) break;
                    mappingCalculator = new SemiAutoRebalancer();
                    break;
                }
            }
            if (rebalancer == null || mappingCalculator == null) continue;
            try {
                HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
                rebalancer.init(manager);
                idealState = rebalancer.computeNewIdealState(resourceName, idealState, currentStateOutput, cache);
                ResourceAssignment partitionStateAssignment = mappingCalculator.computeBestPossiblePartitionState(cache, idealState, resource, currentStateOutput);
                for (Partition partition : resource.getPartitions()) {
                    Map<String, String> newStateMap = partitionStateAssignment.getReplicaMap(partition);
                    output.setState(resourceName, partition, newStateMap);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error computing assignment for resource " + resourceName + ". Skipping."), (Throwable)e);
            }
        }
        return output;
    }
}

