/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.docks;

import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.uberfire.client.workbench.docks.UberfireDockContainerReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class UberfireDocksContainer {
    @Inject
    private Event<UberfireDockContainerReadyEvent> event;
    private DockLayoutPanel rootContainer;
    private Command resizeCommand;

    public void setup(DockLayoutPanel rootContainer, Command resizeCommand) {
        this.rootContainer = rootContainer;
        this.resizeCommand = resizeCommand;
        this.event.fire((Object)new UberfireDockContainerReadyEvent());
    }

    public void add(UberfireDockPosition position, Widget widget, Double size) {
        if (position == UberfireDockPosition.SOUTH) {
            this.rootContainer.addSouth(widget, size.doubleValue());
        } else if (position == UberfireDockPosition.EAST) {
            this.rootContainer.addEast(widget, size.doubleValue());
        } else if (position == UberfireDockPosition.WEST) {
            this.rootContainer.addWest(widget, size.doubleValue());
        }
    }

    public void addBreadcrumbs(IsElement isElement, Double size) {
        this.rootContainer.addNorth((Widget)ElementWrapperWidget.getWidget((HTMLElement)isElement.getElement()), size.doubleValue());
    }

    @Deprecated
    public void show(Widget widget) {
        this.rootContainer.setWidgetHidden(widget, false);
    }

    public void show(IsElement isElement) {
        this.rootContainer.setWidgetHidden((Widget)ElementWrapperWidget.getWidget((HTMLElement)isElement.getElement()), false);
    }

    @Deprecated
    public void hide(Widget widget) {
        this.rootContainer.setWidgetHidden(widget, true);
    }

    public void hide(IsElement isElement) {
        this.rootContainer.setWidgetHidden((Widget)ElementWrapperWidget.getWidget((HTMLElement)isElement.getElement()), true);
    }

    public void setWidgetSize(Widget widget, double size) {
        this.rootContainer.setWidgetSize(widget, size);
    }

    public void resize() {
        this.resizeCommand.execute();
    }

    public int getOffsetHeight() {
        return this.rootContainer.getOffsetHeight();
    }

    public int getOffsetWidth() {
        return this.rootContainer.getOffsetWidth();
    }

    public int getClientWidth() {
        return this.rootContainer.getElement().getClientWidth();
    }

    public boolean isReady() {
        return this.rootContainer != null;
    }
}

