/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util.arguments;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import org.wymiwyg.commons.util.arguments.CommandLine;
import org.wymiwyg.commons.util.arguments.InvalidArgumentsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingArgumentException
extends InvalidArgumentsException {
    private static final long serialVersionUID = -2086386201152724340L;

    public MissingArgumentException(Set<CommandLine> missingArguments) {
        super(MissingArgumentException.getMessageFromMissing(missingArguments));
    }

    private static String getMessageFromMissing(Set<CommandLine> missingArguments) {
        StringWriter messageWriter = new StringWriter();
        messageWriter.write("Missing required argument");
        if (missingArguments.size() > 1) {
            messageWriter.write(115);
        }
        messageWriter.write(": ");
        boolean first = true;
        for (CommandLine current : missingArguments) {
            if (!first) {
                messageWriter.write(", ");
            } else {
                first = false;
            }
            try {
                MissingArgumentException.printArgument(current, messageWriter);
            }
            catch (IOException e) {
                throw new RuntimeException("never happens");
            }
        }
        return messageWriter.toString();
    }

    private static void printArgument(CommandLine argument, Writer messageWriter) throws IOException {
        String name;
        int i;
        boolean first = true;
        for (i = 0; i < argument.shortName().length; ++i) {
            name = argument.shortName()[i];
            if (!first) {
                messageWriter.write(124);
            } else {
                first = false;
            }
            messageWriter.write("-");
            messageWriter.write(name);
        }
        for (i = 0; i < argument.longName().length; ++i) {
            name = argument.longName()[i];
            if (!first) {
                messageWriter.write(124);
            } else {
                first = false;
            }
            messageWriter.write("--");
            messageWriter.write(name);
        }
    }
}

