/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.WorkbenchServicesProxy;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.plugin.PluginUtil;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;

@ApplicationScoped
public class PerspectiveManagerImpl
implements PerspectiveManager {
    @Inject
    private PanelManager panelManager;
    @Inject
    private WorkbenchServicesProxy wbServices;
    @Inject
    private Event<PerspectiveChange> perspectiveChangeEvent;
    @Inject
    private ActivityBeansCache activityBeansCache;
    private PerspectiveActivity currentPerspective;
    private PerspectiveDefinition livePerspectiveDef;

    @Override
    public void switchToPerspective(PlaceRequest placeRequest, PerspectiveActivity activity, ParameterizedCommand<PerspectiveDefinition> doWhenFinished) {
        NotifyOthersOfPerspectiveChangeCommand fourthOperation = new NotifyOthersOfPerspectiveChangeCommand(placeRequest, doWhenFinished);
        BuildPerspectiveFromDefinitionCommand thirdOperation = new BuildPerspectiveFromDefinitionCommand(activity, fourthOperation);
        FetchPerspectiveCommand secondOperation = new FetchPerspectiveCommand(activity, thirdOperation);
        secondOperation.execute();
    }

    @Override
    public PerspectiveActivity getCurrentPerspective() {
        return this.currentPerspective;
    }

    @Override
    public PerspectiveDefinition getLivePerspectiveDefinition() {
        return this.livePerspectiveDef;
    }

    @Override
    public void savePerspectiveState(Command doWhenFinished) {
        if (this.currentPerspective != null && !this.currentPerspective.isTransient()) {
            this.wbServices.save(this.currentPerspective.getIdentifier(), this.livePerspectiveDef, doWhenFinished);
        } else {
            doWhenFinished.execute();
        }
    }

    @Override
    public void loadPerspectiveStates(ParameterizedCommand<Set<PerspectiveDefinition>> doWhenFinished) {
        this.wbServices.loadPerspectives(doWhenFinished);
    }

    @Override
    public void removePerspectiveState(String perspectiveId, Command doWhenFinished) {
        this.wbServices.removePerspectiveState(perspectiveId, doWhenFinished);
    }

    @Override
    public void removePerspectiveStates(Command doWhenFinished) {
        this.wbServices.removePerspectiveStates(doWhenFinished);
    }

    class NotifyOthersOfPerspectiveChangeCommand
    implements ParameterizedCommand<PerspectiveDefinition> {
        private final PlaceRequest placeRequest;
        private final ParameterizedCommand<PerspectiveDefinition> doWhenFinished;

        public NotifyOthersOfPerspectiveChangeCommand(PlaceRequest placeRequest, ParameterizedCommand<PerspectiveDefinition> doWhenFinished) {
            this.placeRequest = (PlaceRequest)PortablePreconditions.checkNotNull((String)"placeRequest", (Object)placeRequest);
            this.doWhenFinished = (ParameterizedCommand)PortablePreconditions.checkNotNull((String)"doWhenFinished", doWhenFinished);
        }

        public void execute(PerspectiveDefinition perspectiveDef) {
            PerspectiveManagerImpl.this.perspectiveChangeEvent.fire((Object)new PerspectiveChange(this.placeRequest, perspectiveDef, PerspectiveManagerImpl.this.currentPerspective.getMenus(), PerspectiveManagerImpl.this.currentPerspective.getIdentifier()));
            this.doWhenFinished.execute((Object)perspectiveDef);
        }
    }

    class BuildPerspectiveFromDefinitionCommand
    implements ParameterizedCommand<PerspectiveDefinition> {
        private final ParameterizedCommand<PerspectiveDefinition> doWhenFinished;
        private final PerspectiveActivity activity;

        public BuildPerspectiveFromDefinitionCommand(PerspectiveActivity activity, ParameterizedCommand<PerspectiveDefinition> doWhenFinished) {
            this.activity = (PerspectiveActivity)PortablePreconditions.checkNotNull((String)"activity", (Object)activity);
            this.doWhenFinished = (ParameterizedCommand)PortablePreconditions.checkNotNull((String)"doWhenFinished", doWhenFinished);
        }

        public void execute(PerspectiveDefinition perspectiveDef) {
            if (PerspectiveManagerImpl.this.livePerspectiveDef != null) {
                this.tearDownChildPanelsRecursively(PerspectiveManagerImpl.this.livePerspectiveDef.getRoot());
            }
            PerspectiveManagerImpl.this.livePerspectiveDef = perspectiveDef;
            PerspectiveManagerImpl.this.panelManager.setRoot(this.activity, perspectiveDef.getRoot());
            this.setupPanelRecursively(perspectiveDef.getRoot());
            this.doWhenFinished.execute((Object)perspectiveDef);
        }

        private void tearDownChildPanelsRecursively(PanelDefinition panel) {
            for (PanelDefinition child : PluginUtil.ensureIterable((List)panel.getChildren())) {
                this.tearDownChildPanelsRecursively(child);
                PerspectiveManagerImpl.this.panelManager.removeWorkbenchPanel(child);
            }
        }

        private void setupPanelRecursively(PanelDefinition panel) {
            for (PanelDefinition child : PluginUtil.ensureIterable((List)panel.getChildren())) {
                PanelDefinition target = PerspectiveManagerImpl.this.panelManager.addWorkbenchPanel(panel, child, child.getPosition());
                this.setupPanelRecursively(target);
            }
        }
    }

    class FetchPerspectiveCommand
    implements Command {
        private final PerspectiveActivity perspective;
        private final ParameterizedCommand<PerspectiveDefinition> doAfterFetch;

        public FetchPerspectiveCommand(PerspectiveActivity perspective, ParameterizedCommand<PerspectiveDefinition> doAfterFetch) {
            this.perspective = (PerspectiveActivity)PortablePreconditions.checkNotNull((String)"perspective", (Object)perspective);
            this.doAfterFetch = (ParameterizedCommand)PortablePreconditions.checkNotNull((String)"doAfterFetch", doAfterFetch);
        }

        public void execute() {
            PerspectiveManagerImpl.this.currentPerspective = this.perspective;
            if (this.perspective.isTransient()) {
                this.doAfterFetch.execute((Object)this.perspective.getDefaultPerspectiveLayout());
            } else {
                PerspectiveManagerImpl.this.wbServices.loadPerspective(this.perspective.getIdentifier(), new ParameterizedCommand<PerspectiveDefinition>(){

                    public void execute(PerspectiveDefinition response) {
                        if (FetchPerspectiveCommand.this.isAValidDefinition(response)) {
                            FetchPerspectiveCommand.this.doAfterFetch.execute((Object)response);
                        } else {
                            FetchPerspectiveCommand.this.doAfterFetch.execute((Object)FetchPerspectiveCommand.this.perspective.getDefaultPerspectiveLayout());
                        }
                    }
                });
            }
        }

        boolean isAValidDefinition(PerspectiveDefinition response) {
            return response != null && this.allThePartsAreValid(response.getRoot());
        }

        private boolean allThePartsAreValid(PanelDefinition panel) {
            if (!this.checkIfAllPlacesAreValidActivities(panel)) {
                return false;
            }
            for (PanelDefinition child : PluginUtil.ensureIterable((List)panel.getChildren())) {
                if (this.allThePartsAreValid(child)) continue;
                return false;
            }
            return true;
        }

        private boolean checkIfAllPlacesAreValidActivities(PanelDefinition child) {
            for (PartDefinition partDefinition : PluginUtil.ensureIterable((Set)child.getParts())) {
                PlaceRequest place = partDefinition.getPlace();
                if (PerspectiveManagerImpl.this.activityBeansCache.hasActivity(place.getIdentifier())) continue;
                return false;
            }
            return true;
        }
    }
}

