/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;

@Portable
public class DotNamedPermission
implements Permission,
Comparable<Permission> {
    private String name;
    private AuthorizationResult result;
    private boolean _immutable;

    public DotNamedPermission() {
    }

    public DotNamedPermission(String name) {
        this(name, AuthorizationResult.ACCESS_ABSTAIN);
    }

    public DotNamedPermission(String name, Boolean granted) {
        this.name = name;
        this.result = granted == null ? AuthorizationResult.ACCESS_ABSTAIN : (granted != false ? AuthorizationResult.ACCESS_GRANTED : AuthorizationResult.ACCESS_DENIED);
    }

    public DotNamedPermission(String name, AuthorizationResult result) {
        this.name = name;
        this.result = result;
    }

    protected void _enableImmutability() {
        this._immutable = true;
    }

    protected void _checkImmutability() {
        if (this._immutable) {
            throw new IllegalStateException("The permission is non mutable: " + this);
        }
    }

    public <T extends DotNamedPermission> T nonMutable() {
        this._enableImmutability();
        return (T)this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this._checkImmutability();
        this.name = name;
    }

    @Override
    public AuthorizationResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(AuthorizationResult result) {
        this._checkImmutability();
        this.result = result;
    }

    @Override
    public boolean implies(Permission other) {
        return this.impliesName(other) && this.impliesResult(other);
    }

    @Override
    public boolean impliesName(Permission other) {
        int otherLastDot;
        if (this.equalsName(other)) {
            return true;
        }
        if (this.name == null) {
            return false;
        }
        String otherName = other.getName();
        int lastDot = this.name.trim().length();
        int n = otherLastDot = otherName != null ? otherName.lastIndexOf(46) : -1;
        if (lastDot != otherLastDot) {
            return false;
        }
        return other.getName().substring(0, lastDot).equals(this.name);
    }

    @Override
    public boolean impliesResult(Permission other) {
        if (this.result == null || AuthorizationResult.ACCESS_ABSTAIN.equals((Object)this.result)) {
            return other.getResult() == null || AuthorizationResult.ACCESS_ABSTAIN.equals((Object)other.getResult());
        }
        boolean otherDenied = other.getResult() != null && AuthorizationResult.ACCESS_DENIED.equals((Object)other.getResult());
        return AuthorizationResult.ACCESS_DENIED.equals((Object)this.result) == otherDenied;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)obj;
        return this.equalsName(other) && this.equalsResult(other);
    }

    public boolean equalsName(Permission other) {
        if (this.name != null && !this.name.equals(other.getName())) {
            return false;
        }
        return this.name != null || other.getName() == null;
    }

    public boolean equalsResult(Permission other) {
        if (this.result == null && other.getResult() != null) {
            return false;
        }
        return this.result == null || this.result.equals((Object)other.getResult());
    }

    @Override
    public int compareTo(Permission o) {
        if (this.name == null) {
            return o.getName() == null ? 0 : -1;
        }
        return this.name.compareTo(o.getName());
    }

    @Override
    public Permission clone() {
        return new DotNamedPermission(this.name, this.result);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.name).append(" ").append((Object)this.result);
        return out.toString();
    }
}

