/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl.graphmatching;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.Triple;

public class Utils {
    static Set<BNode> getBNodes(Collection<Triple> s) {
        HashSet<BNode> result = new HashSet<BNode>();
        for (Triple triple : s) {
            if (triple.getSubject() instanceof BNode) {
                result.add((BNode)triple.getSubject());
            }
            if (!(triple.getObject() instanceof BNode)) continue;
            result.add((BNode)triple.getObject());
        }
        return result;
    }

    static boolean removeGrounded(Collection<Triple> s1, Collection<Triple> s2) {
        Iterator<Triple> triplesIter = s1.iterator();
        while (triplesIter.hasNext()) {
            Triple triple = triplesIter.next();
            if (!Utils.isGrounded(triple)) continue;
            if (!s2.remove(triple)) {
                return false;
            }
            triplesIter.remove();
        }
        for (Triple triple : s2) {
            if (!Utils.isGrounded(triple)) continue;
            return false;
        }
        return true;
    }

    private static boolean isGrounded(Triple triple) {
        if (triple.getSubject() instanceof BNode) {
            return false;
        }
        return !(triple.getObject() instanceof BNode);
    }
}

