/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.client.views.pfly.widgets.InlineNotification;
import org.uberfire.client.views.pfly.widgets.Modal;

@Dependent
@Templated
public class ErrorPopup {
    @Inject
    @DataField(value="alert")
    private InlineNotification notification;
    @Inject
    @DataField(value="modal")
    private Modal modal;

    @PostConstruct
    public void init() {
        this.notification.setType(InlineNotification.InlineNotificationType.DANGER);
    }

    public void showError(String message) {
        this.notification.setMessage(message);
        this.modal.show();
    }

    public void hide() {
        this.modal.hide();
    }

    public HTMLElement getElement() {
        return this.modal.getElement();
    }

    @EventHandler(value={"confirm-ok"})
    public void onOkClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"confirm-close"})
    public void onCloseClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }
}

