/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Closeable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.TP;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Bits;
import org.jgroups.util.DirectExecutor;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class RoundTrip
extends ReceiverAdapter {
    protected JChannel channel;
    protected int num_msgs = 20000;
    protected int num_senders = 1;
    protected boolean oob = true;
    protected boolean dont_bundle;
    protected boolean details;
    protected static final byte REQ = 0;
    protected static final byte RSP = 1;
    protected Sender[] senders;

    protected void start(String props, String name) throws Exception {
        this.channel = new JChannel(props).name(name);
        this.channel.setReceiver(this);
        TP transport = this.channel.getProtocolStack().getTransport();
        transport.setOOBThreadPool(new DirectExecutor());
        transport.setDefaultThreadPool(new DirectExecutor());
        this.channel.connect("rt");
        View view = this.channel.getView();
        if (view.size() > 2) {
            System.err.printf("More than 2 members found (%s); terminating\n", view);
        } else {
            this.loop();
        }
        Util.close((Closeable)this.channel);
    }

    @Override
    public void receive(Message msg) {
        byte[] req_buf = msg.getRawBuffer();
        byte type = req_buf[0];
        short id = Bits.readShort(req_buf, 1);
        switch (type) {
            case 0: {
                byte[] rsp_buf = new byte[3];
                rsp_buf[0] = 1;
                Bits.writeShort(id, rsp_buf, 1);
                Message rsp = new Message(msg.src(), rsp_buf);
                try {
                    this.channel.send(rsp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                this.senders[id].promise.setResult(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("first byte needs to be either REQ or RSP but not " + req_buf[0]);
            }
        }
    }

    @Override
    public void viewAccepted(View view) {
        System.out.println("view = " + view);
    }

    protected void loop() {
        boolean looping = true;
        while (looping) {
            int c = Util.keyPress(String.format("[1] send [2] num_msgs (%d) [3] senders (%d)\n[o] oob (%b) [b] dont_bundle (%b) [d] details (%b) [x] exit\n", this.num_msgs, this.num_senders, this.oob, this.dont_bundle, this.details));
            try {
                switch (c) {
                    case 49: {
                        this.sendRequests();
                        break;
                    }
                    case 50: {
                        this.num_msgs = Util.readIntFromStdin("num_msgs: ");
                        break;
                    }
                    case 51: {
                        this.num_senders = Util.readIntFromStdin("num_senders: ");
                        break;
                    }
                    case 111: {
                        this.oob = !this.oob;
                        break;
                    }
                    case 98: {
                        this.dont_bundle = !this.dont_bundle;
                        break;
                    }
                    case 100: {
                        this.details = !this.details;
                        break;
                    }
                    case 120: {
                        looping = false;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected void sendRequests() throws Exception {
        View view = this.channel.getView();
        if (view.size() != 2) {
            System.err.printf("Cluster must have exactly 2 members: %s\n", view);
            return;
        }
        Address target = Util.pickNext(view.getMembers(), this.channel.getAddress());
        CountDownLatch latch = new CountDownLatch(this.num_senders + 1);
        AtomicInteger sent_msgs = new AtomicInteger(0);
        this.senders = new Sender[this.num_senders];
        for (int i = 0; i < this.num_senders; ++i) {
            this.senders[i] = new Sender((short)i, latch, sent_msgs, target);
            this.senders[i].start();
        }
        long start = System.nanoTime();
        latch.countDown();
        for (Sender sender : this.senders) {
            sender.join();
        }
        long total_time = System.nanoTime() - start;
        double msgs_sec = (double)this.num_msgs / ((double)total_time / 1.0E9);
        AverageMinMax avg = null;
        if (this.details) {
            System.out.println("");
        }
        for (Sender sender : this.senders) {
            if (this.details) {
                System.out.printf("%d: %s\n", sender.id, RoundTrip.print(sender.avg));
            }
            if (avg == null) {
                avg = sender.avg;
                continue;
            }
            avg.merge(sender.avg);
        }
        System.out.printf(Util.bold("\n\nreqs/sec = %.2f, round-trip = min/avg/max: %.2f / %.2f / %.2f us\n\n"), msgs_sec, (double)avg.min() / 1000.0, avg.average() / 1000.0, (double)avg.max() / 1000.0);
    }

    protected static String print(AverageMinMax avg) {
        return String.format("round-trip min/avg/max = %.2f / %.2f / %.2f us", (double)avg.min() / 1000.0, avg.average() / 1000.0, (double)avg.max() / 1000.0);
    }

    public static void main(String[] args) throws Exception {
        String props = null;
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            RoundTrip.help();
            return;
        }
        new RoundTrip().start(props, name);
    }

    private static void help() {
        System.out.println("RoundTrip [-props <properties>] [-name name]");
    }

    protected class Sender
    extends Thread {
        protected final short id;
        protected final byte[] req_buf = new byte[3];
        protected final CountDownLatch latch;
        protected final AtomicInteger sent_msgs;
        protected final Promise<Boolean> promise = new Promise();
        protected final int print;
        protected final Address target;
        protected final AverageMinMax avg = new AverageMinMax();

        public Sender(short id, CountDownLatch latch, AtomicInteger sent_msgs, Address target) {
            this.id = id;
            this.latch = latch;
            this.sent_msgs = sent_msgs;
            this.target = target;
            this.req_buf[0] = 0;
            Bits.writeShort(id, this.req_buf, 1);
            this.print = RoundTrip.this.num_msgs / 10;
        }

        @Override
        public void run() {
            int num;
            while ((num = this.sent_msgs.getAndIncrement()) < RoundTrip.this.num_msgs) {
                if (num > 0 && num % this.print == 0) {
                    System.out.printf(".", new Object[0]);
                }
                this.promise.reset(false);
                Message req = new Message(this.target, this.req_buf);
                if (RoundTrip.this.oob) {
                    req.setFlag(Message.Flag.OOB);
                }
                if (RoundTrip.this.dont_bundle) {
                    req.setFlag(Message.Flag.DONT_BUNDLE);
                }
                try {
                    long start = System.nanoTime();
                    RoundTrip.this.channel.send(req);
                    this.promise.getResult(0L);
                    long time = System.nanoTime() - start;
                    this.avg.add(time);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

