/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.lib.Ref;
import org.uberfire.commons.data.Pair;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;

public class SyncRemote {
    private final GitImpl git;
    private final Pair<String, String> remote;

    public SyncRemote(GitImpl git, Pair<String, String> remote) {
        this.git = git;
        this.remote = remote;
    }

    public Optional execute() throws InvalidRemoteException {
        try {
            List branches = this.git._branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            HashSet<String> remoteBranches = new HashSet<String>();
            HashSet<String> localBranches = new HashSet<String>();
            for (Ref ref : branches) {
                String branchName = ref.getName().substring(ref.getName().lastIndexOf("/") + 1);
                if (ref.getName().startsWith("refs/remotes/" + (String)this.remote.getK1())) {
                    remoteBranches.add(branchName);
                    continue;
                }
                localBranches.add(branchName);
            }
            for (String string : localBranches) {
                if (string.equals("HEAD") || !remoteBranches.contains(string)) continue;
                try {
                    this.git._branchCreate().setName(string).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM).setStartPoint((String)this.remote.getK1() + "/" + string).setForce(true).call();
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error creating branch [" + string + "].");
                }
            }
            remoteBranches.removeAll(localBranches);
            for (String string : remoteBranches) {
                if (string.equals("HEAD")) continue;
                try {
                    this.git._branchCreate().setName(string).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM).setStartPoint((String)this.remote.getK1() + "/" + string).setForce(true).call();
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error creating branch [" + string + "].");
                }
            }
            return null;
        }
        catch (InvalidRemoteException e) {
            throw e;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

