/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

public class ChannelAgentForwarding
extends AbstractServerChannel {
    public static final String FORWARDER_BUFFER_SIZE = "channel-agent-fwd-buf-size";
    public static final int MIN_FORWARDER_BUF_SIZE = 127;
    public static final int DEFAULT_FORWARDER_BUF_SIZE = 1024;
    public static final int MAX_FORWARDER_BUF_SIZE = Short.MAX_VALUE;
    private String authSocket;
    private long pool;
    private long handle;
    private OutputStream out;
    private ExecutorService forwardService;
    private Future<?> forwarder;
    private boolean shutdownForwarder;

    @Override
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f = new DefaultOpenFuture(this);
        try {
            ExecutorService service;
            this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            this.authSocket = this.getString("SSH_AUTH_SOCK");
            this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
            this.handle = Local.create((String)this.authSocket, (long)this.pool);
            int result = Local.connect((long)this.handle, (long)0L);
            if (result != 0) {
                ChannelAgentForwarding.throwException(result);
            }
            this.forwardService = (service = this.getExecutorService()) == null ? ThreadUtils.newSingleThreadExecutor("ChannelAgentForwarding[" + this.authSocket + "]") : service;
            this.shutdownForwarder = service != this.forwardService || this.isShutdownOnExit();
            int copyBufSize = this.getIntProperty(FORWARDER_BUFFER_SIZE, 1024);
            ValidateUtils.checkTrue(copyBufSize >= 127, "Copy buf size below min.: %d", copyBufSize);
            ValidateUtils.checkTrue(copyBufSize <= Short.MAX_VALUE, "Copy buf size above max.: %d", copyBufSize);
            this.forwarder = this.forwardService.submit(() -> {
                try {
                    byte[] buf = new byte[copyBufSize];
                    while (true) {
                        int len;
                        if ((len = Socket.recv((long)this.handle, (byte[])buf, (int)0, (int)buf.length)) <= 0) {
                            continue;
                        }
                        this.out.write(buf, 0, len);
                        this.out.flush();
                    }
                }
                catch (IOException e) {
                    this.close(true);
                    return;
                }
            });
            this.signalChannelOpenSuccess();
            f.setOpened();
        }
        catch (Throwable t) {
            Throwable e = GenericUtils.peelException(t);
            this.signalChannelOpenFailure(e);
            f.setException(e);
        }
        return f;
    }

    private void closeImmediately0() {
        super.close(true);
        Socket.close((long)this.handle);
        try {
            if (this.forwarder != null && !this.forwarder.isDone()) {
                this.forwarder.cancel(true);
            }
        }
        finally {
            this.forwarder = null;
        }
        try {
            if (this.forwardService != null && this.shutdownForwarder) {
                List<Runnable> runners = this.forwardService.shutdownNow();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Shut down runners count=" + GenericUtils.size(runners));
                }
            }
        }
        finally {
            this.forwardService = null;
            this.shutdownForwarder = false;
        }
    }

    @Override
    public CloseFuture close(boolean immediately) {
        return super.close(immediately).addListener(sshFuture -> this.closeImmediately0());
    }

    @Override
    protected void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len);
        int result = Socket.send((long)this.handle, (byte[])data, (int)off, (int)((int)len));
        if (result < 0) {
            ChannelAgentForwarding.throwException(result);
        }
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        throw new UnsupportedOperationException("AgentForward channel does not support extended data");
    }

    private static void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }
}

