/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import freemarker.cache.StatefulTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class MultiTemplateLoader
implements StatefulTemplateLoader {
    private final List<TemplateLoader> loaders = new ArrayList<TemplateLoader>();

    public void addTemplateLoader(TemplateLoader loader) {
        this.loaders.add(loader);
    }

    public Object findTemplateSource(String name) throws IOException {
        for (TemplateLoader loader : this.loaders) {
            Object source = loader.findTemplateSource(name);
            if (source == null) continue;
            return new MultiSource(source, loader);
        }
        return null;
    }

    public long getLastModified(Object templateSource) {
        return ((MultiSource)templateSource).getLastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return ((MultiSource)templateSource).getReader(encoding);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        ((MultiSource)templateSource).close();
    }

    public void resetState() {
        this.loaders.stream().filter(l -> l instanceof StatefulTemplateLoader).forEach(l -> ((StatefulTemplateLoader)l).resetState());
    }

    static final class MultiSource {
        private final Object source;
        private final TemplateLoader loader;

        MultiSource(Object source, TemplateLoader loader) {
            this.source = source;
            this.loader = loader;
        }

        long getLastModified() {
            return this.loader.getLastModified(this.source);
        }

        Reader getReader(String encoding) throws IOException {
            return this.loader.getReader(this.source, encoding);
        }

        void close() throws IOException {
            this.loader.closeTemplateSource(this.source);
        }

        public boolean equals(Object o) {
            if (o instanceof MultiSource) {
                MultiSource m = (MultiSource)o;
                return m.loader.equals(this.loader) && m.source.equals(this.source);
            }
            return false;
        }

        public int hashCode() {
            return this.loader.hashCode() + 31 * this.source.hashCode();
        }

        public String toString() {
            return this.source.toString();
        }
    }
}

