/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.BusLifecycleAdapter;
import org.jboss.errai.bus.client.api.BusLifecycleEvent;
import org.jboss.errai.bus.client.api.BusLifecycleListener;
import org.jboss.errai.bus.client.api.ClientMessageBus;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.slf4j.Logger;
import org.uberfire.client.workbench.WorkbenchServicesProxy;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mvp.ParameterizedCommand;

@EntryPoint
public class WorkbenchBackendEntryPoint {
    private Logger logger;
    private ClientMessageBus bus;
    private WorkbenchServicesProxy workbenchServices;
    private ErrorPopupPresenter errorPopupPresenter;
    private boolean isWorkbenchOnCluster = false;
    private boolean showedError = false;

    public WorkbenchBackendEntryPoint() {
    }

    @Inject
    public WorkbenchBackendEntryPoint(Logger logger, ClientMessageBus bus, WorkbenchServicesProxy workbenchServices, ErrorPopupPresenter errorPopupPresenter) {
        this.logger = logger;
        this.bus = bus;
        this.workbenchServices = workbenchServices;
        this.errorPopupPresenter = errorPopupPresenter;
    }

    @PostConstruct
    public void init() {
        this.bus.addLifecycleListener((BusLifecycleListener)new BusLifecycleAdapter(){

            public void busOnline(BusLifecycleEvent e) {
                WorkbenchBackendEntryPoint.this.logger.info("Bus is back online.");
                WorkbenchBackendEntryPoint.this.showedError = false;
            }

            public void busOffline(BusLifecycleEvent e) {
                if (WorkbenchBackendEntryPoint.this.showedError) {
                    return;
                }
                WorkbenchBackendEntryPoint.this.logger.error("Bus is offline. [" + e.getReason().getErrorMessage() + "]");
                if (!WorkbenchBackendEntryPoint.this.isWorkbenchOnCluster) {
                    WorkbenchBackendEntryPoint.this.errorPopupPresenter.showMessage("You've been disconnected.");
                }
                WorkbenchBackendEntryPoint.this.showedError = true;
            }
        });
        this.workbenchServices.isWorkbenchOnCluster((ParameterizedCommand)new ParameterizedCommand<Boolean>(){

            public void execute(Boolean parameter) {
                WorkbenchBackendEntryPoint.this.isWorkbenchOnCluster = parameter != null && !parameter.equals(Boolean.FALSE);
            }
        });
    }
}

