/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.metadata;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jboss.resteasy.spi.metadata.MethodParameter;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.util.Types;

public class ResourceLocator {
    protected ResourceClass resourceClass;
    protected Class<?> returnType;
    protected Type genericReturnType;
    protected Method method;
    protected Method annotatedMethod;
    protected MethodParameter[] params = new MethodParameter[0];
    protected String fullpath;
    protected String path;

    public ResourceLocator(ResourceClass resourceClass, Method method, Method annotatedMethod) {
        this.resourceClass = resourceClass;
        this.annotatedMethod = annotatedMethod;
        this.method = method;
        this.genericReturnType = Types.resolveTypeVariables(resourceClass.getClazz(), method.getGenericReturnType());
        this.returnType = Types.getRawType(this.genericReturnType);
        this.params = new MethodParameter[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            this.params[i] = new MethodParameter(this, method.getParameterTypes()[i], method.getGenericParameterTypes()[i], annotatedMethod.getParameterAnnotations()[i]);
        }
    }

    public ResourceClass getResourceClass() {
        return this.resourceClass;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Type getGenericReturnType() {
        return this.genericReturnType;
    }

    public Method getMethod() {
        return this.method;
    }

    public Method getAnnotatedMethod() {
        return this.annotatedMethod;
    }

    public MethodParameter[] getParams() {
        return this.params;
    }

    public String getFullpath() {
        return this.fullpath;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.method.toString();
    }
}

