/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.core.BugException;
import freemarker.core._JavaVersions;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.ClassBasedModelFactory;
import freemarker.ext.beans.ClassChangeNotifier;
import freemarker.ext.beans.ClassIntrospectorBuilder;
import freemarker.ext.beans.MethodAppearanceFineTuner;
import freemarker.ext.beans.MethodSorter;
import freemarker.ext.beans.OverloadedMethods;
import freemarker.ext.beans.SimpleMethod;
import freemarker.ext.beans.UnsafeMethods;
import freemarker.ext.beans._MethodUtil;
import freemarker.ext.util.ModelCache;
import freemarker.log.Logger;
import freemarker.template.utility.NullArgumentException;
import freemarker.template.utility.SecurityUtilities;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassIntrospector {
    private static final Logger LOG;
    private static final String JREBEL_SDK_CLASS_NAME = "org.zeroturnaround.javarebel.ClassEventListener";
    private static final String JREBEL_INTEGRATION_ERROR_MSG = "Error initializing JRebel integration. JRebel integration disabled.";
    static final boolean DEVELOPMENT_MODE;
    private static final ClassChangeNotifier CLASS_CHANGE_NOTIFIER;
    private static final Object ARG_TYPES_BY_METHOD_KEY;
    static final Object CONSTRUCTORS_KEY;
    static final Object GENERIC_GET_KEY;
    final int exposureLevel;
    final boolean exposeFields;
    final MethodAppearanceFineTuner methodAppearanceFineTuner;
    final MethodSorter methodSorter;
    final boolean treatDefaultMethodsAsBeanMembers;
    final boolean bugfixed;
    private final boolean hasSharedInstanceRestrictons;
    private final boolean shared;
    private final Object sharedLock;
    private final Map<Class<?>, Map<Object, Object>> cache = new ConcurrentHashMap(0, 0.75f, 16);
    private final Set<String> cacheClassNames = new HashSet<String>(0);
    private final Set<Class<?>> classIntrospectionsInProgress = new HashSet(0);
    private final List<WeakReference<Object>> modelFactories = new LinkedList<WeakReference<Object>>();
    private final ReferenceQueue<Object> modelFactoriesRefQueue = new ReferenceQueue();
    private int clearingCounter;

    ClassIntrospector(ClassIntrospectorBuilder pa, Object sharedLock) {
        this(pa, sharedLock, false, false);
    }

    ClassIntrospector(ClassIntrospectorBuilder builder, Object sharedLock, boolean hasSharedInstanceRestrictons, boolean shared) {
        NullArgumentException.check("sharedLock", sharedLock);
        this.exposureLevel = builder.getExposureLevel();
        this.exposeFields = builder.getExposeFields();
        this.methodAppearanceFineTuner = builder.getMethodAppearanceFineTuner();
        this.methodSorter = builder.getMethodSorter();
        this.treatDefaultMethodsAsBeanMembers = builder.getTreatDefaultMethodsAsBeanMembers();
        this.bugfixed = builder.isBugfixed();
        this.sharedLock = sharedLock;
        this.hasSharedInstanceRestrictons = hasSharedInstanceRestrictons;
        this.shared = shared;
        if (CLASS_CHANGE_NOTIFIER != null) {
            CLASS_CHANGE_NOTIFIER.subscribe(this);
        }
    }

    ClassIntrospectorBuilder createBuilder() {
        return new ClassIntrospectorBuilder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Object, Object> get(Class<?> clazz) {
        String className;
        Map<Object, Object> introspData = this.cache.get(clazz);
        if (introspData != null) {
            return introspData;
        }
        Object object = this.sharedLock;
        synchronized (object) {
            Map<Object, Object> introspData2 = this.cache.get(clazz);
            if (introspData2 != null) {
                return introspData2;
            }
            className = clazz.getName();
            if (this.cacheClassNames.contains(className)) {
                this.onSameNameClassesDetected(className);
            }
            while (introspData2 == null && this.classIntrospectionsInProgress.contains(clazz)) {
                try {
                    this.sharedLock.wait();
                    introspData2 = this.cache.get(clazz);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Class inrospection data lookup aborded: " + e);
                }
            }
            if (introspData2 != null) {
                return introspData2;
            }
            this.classIntrospectionsInProgress.add(clazz);
        }
        try {
            Map<Object, Object> introspData3 = this.createClassIntrospectionData(clazz);
            Map<Object, Object> map = this.sharedLock;
            synchronized (map) {
                this.cache.put(clazz, introspData3);
                this.cacheClassNames.add(className);
            }
            map = introspData3;
            return map;
        }
        finally {
            Object object2 = this.sharedLock;
            synchronized (object2) {
                this.classIntrospectionsInProgress.remove(clazz);
                this.sharedLock.notifyAll();
            }
        }
    }

    private Map<Object, Object> createClassIntrospectionData(Class<?> clazz) {
        HashMap<Object, Object> introspData = new HashMap<Object, Object>();
        if (this.exposeFields) {
            this.addFieldsToClassIntrospectionData(introspData, clazz);
        }
        Map<MethodSignature, List<Method>> accessibleMethods = ClassIntrospector.discoverAccessibleMethods(clazz);
        this.addGenericGetToClassIntrospectionData(introspData, accessibleMethods);
        if (this.exposureLevel != 3) {
            try {
                this.addBeanInfoToClassIntrospectionData(introspData, clazz, accessibleMethods);
            }
            catch (IntrospectionException e) {
                LOG.warn("Couldn't properly perform introspection for class " + clazz, e);
                introspData.clear();
            }
        }
        this.addConstructorsToClassIntrospectionData(introspData, clazz);
        if (introspData.size() > 1) {
            return introspData;
        }
        if (introspData.size() == 0) {
            return Collections.emptyMap();
        }
        Map.Entry e = introspData.entrySet().iterator().next();
        return Collections.singletonMap(e.getKey(), e.getValue());
    }

    private void addFieldsToClassIntrospectionData(Map<Object, Object> introspData, Class<?> clazz) throws SecurityException {
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if ((field.getModifiers() & 8) != 0) continue;
            introspData.put(field.getName(), field);
        }
    }

    private void addBeanInfoToClassIntrospectionData(Map<Object, Object> introspData, Class<?> clazz, Map<MethodSignature, List<Method>> accessibleMethods) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        List<PropertyDescriptor> pdas = this.getPropertyDescriptors(beanInfo, clazz);
        int pdasLength = pdas.size();
        for (int i = pdasLength - 1; i >= 0; --i) {
            this.addPropertyDescriptorToClassIntrospectionData(introspData, pdas.get(i), clazz, accessibleMethods);
        }
        if (this.exposureLevel < 2) {
            BeansWrapper.MethodAppearanceDecision decision = new BeansWrapper.MethodAppearanceDecision();
            BeansWrapper.MethodAppearanceDecisionInput decisionInput = null;
            List<MethodDescriptor> mds = this.getMethodDescriptors(beanInfo, clazz);
            this.sortMethodDescriptors(mds);
            int mdsSize = mds.size();
            IdentityHashMap<Method, Object> argTypesUsedByIndexerPropReaders = null;
            for (int i = mdsSize - 1; i >= 0; --i) {
                String methodKey;
                PropertyDescriptor propDesc;
                MethodDescriptor md = mds.get(i);
                Method method = ClassIntrospector.getMatchingAccessibleMethod(md.getMethod(), accessibleMethods);
                if (method == null || !this.isAllowedToExpose(method)) continue;
                decision.setDefaults(method);
                if (this.methodAppearanceFineTuner != null) {
                    if (decisionInput == null) {
                        decisionInput = new BeansWrapper.MethodAppearanceDecisionInput();
                    }
                    decisionInput.setContainingClass(clazz);
                    decisionInput.setMethod(method);
                    this.methodAppearanceFineTuner.process(decisionInput, decision);
                }
                if ((propDesc = decision.getExposeAsProperty()) != null && !(introspData.get(propDesc.getName()) instanceof PropertyDescriptor)) {
                    this.addPropertyDescriptorToClassIntrospectionData(introspData, propDesc, clazz, accessibleMethods);
                }
                if ((methodKey = decision.getExposeMethodAs()) == null) continue;
                Object previous = introspData.get(methodKey);
                if (previous instanceof Method) {
                    OverloadedMethods overloadedMethods = new OverloadedMethods(this.bugfixed);
                    overloadedMethods.addMethod((Method)previous);
                    overloadedMethods.addMethod(method);
                    introspData.put(methodKey, overloadedMethods);
                    if (argTypesUsedByIndexerPropReaders != null && argTypesUsedByIndexerPropReaders.containsKey(previous)) continue;
                    ClassIntrospector.getArgTypesByMethod(introspData).remove(previous);
                    continue;
                }
                if (previous instanceof OverloadedMethods) {
                    ((OverloadedMethods)previous).addMethod(method);
                    continue;
                }
                if (!decision.getMethodShadowsProperty() && previous instanceof PropertyDescriptor) continue;
                introspData.put(methodKey, method);
                Class<?>[] replaced = ClassIntrospector.getArgTypesByMethod(introspData).put(method, method.getParameterTypes());
                if (replaced == null) continue;
                if (argTypesUsedByIndexerPropReaders == null) {
                    argTypesUsedByIndexerPropReaders = new IdentityHashMap<Method, Object>();
                }
                argTypesUsedByIndexerPropReaders.put(method, null);
            }
        }
    }

    private List<PropertyDescriptor> getPropertyDescriptors(BeanInfo beanInfo, Class<?> clazz) {
        List<PropertyDescriptor> introspectorPDs;
        PropertyDescriptor[] introspectorPDsArray = beanInfo.getPropertyDescriptors();
        List<PropertyDescriptor> list = introspectorPDs = introspectorPDsArray != null ? Arrays.asList(introspectorPDsArray) : Collections.emptyList();
        if (!this.treatDefaultMethodsAsBeanMembers || _JavaVersions.JAVA_8 == null) {
            return introspectorPDs;
        }
        LinkedHashMap<String, Object> mergedPRMPs = null;
        for (Method method : clazz.getMethods()) {
            String propName;
            Class<?>[] paramTypes;
            if (!_JavaVersions.JAVA_8.isDefaultMethod(method) || method.getReturnType() == Void.TYPE || method.isBridge() || (paramTypes = method.getParameterTypes()).length != 0 && (paramTypes.length != 1 || paramTypes[0] != Integer.TYPE) || (propName = _MethodUtil.getBeanPropertyNameFromReaderMethodName(method.getName(), method.getReturnType())) == null) continue;
            if (mergedPRMPs == null) {
                mergedPRMPs = new LinkedHashMap<String, Object>();
            }
            if (paramTypes.length == 0) {
                this.mergeInPropertyReaderMethod(mergedPRMPs, propName, method);
                continue;
            }
            this.mergeInPropertyReaderMethodPair(mergedPRMPs, propName, new PropertyReaderedMethodPair(null, method));
        }
        if (mergedPRMPs == null) {
            return introspectorPDs;
        }
        for (PropertyDescriptor introspectorPD : introspectorPDs) {
            this.mergeInPropertyDescriptor(mergedPRMPs, introspectorPD);
        }
        ArrayList<PropertyDescriptor> mergedPDs = new ArrayList<PropertyDescriptor>(mergedPRMPs.size());
        for (Map.Entry entry : mergedPRMPs.entrySet()) {
            Method indexedReadMethod;
            Method readMethod;
            String propName = (String)entry.getKey();
            Object propDescObj = entry.getValue();
            if (propDescObj instanceof PropertyDescriptor) {
                mergedPDs.add((PropertyDescriptor)propDescObj);
                continue;
            }
            if (propDescObj instanceof Method) {
                readMethod = (Method)propDescObj;
                indexedReadMethod = null;
            } else if (propDescObj instanceof PropertyReaderedMethodPair) {
                PropertyReaderedMethodPair prmp = (PropertyReaderedMethodPair)propDescObj;
                readMethod = prmp.readMethod;
                indexedReadMethod = prmp.indexedReadMethod;
                if (readMethod != null && indexedReadMethod != null && indexedReadMethod.getReturnType() != readMethod.getReturnType().getComponentType()) {
                    indexedReadMethod = null;
                }
            } else {
                throw new BugException();
            }
            try {
                mergedPDs.add(indexedReadMethod != null ? new IndexedPropertyDescriptor(propName, readMethod, null, indexedReadMethod, null) : new PropertyDescriptor(propName, readMethod, null));
            }
            catch (IntrospectionException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Failed creating property descriptor for " + clazz.getName() + " property " + propName, e);
            }
        }
        return mergedPDs;
    }

    private void mergeInPropertyDescriptor(LinkedHashMap<String, Object> mergedPRMPs, PropertyDescriptor pd) {
        String propName = pd.getName();
        Object replaced = mergedPRMPs.put(propName, pd);
        if (replaced != null) {
            PropertyReaderedMethodPair newPRMP = new PropertyReaderedMethodPair(pd);
            this.putIfMergedPropertyReaderMethodPairDiffers(mergedPRMPs, propName, replaced, newPRMP);
        }
    }

    private void mergeInPropertyReaderMethodPair(LinkedHashMap<String, Object> mergedPRMPs, String propName, PropertyReaderedMethodPair newPRM) {
        Object replaced = mergedPRMPs.put(propName, newPRM);
        if (replaced != null) {
            this.putIfMergedPropertyReaderMethodPairDiffers(mergedPRMPs, propName, replaced, newPRM);
        }
    }

    private void mergeInPropertyReaderMethod(LinkedHashMap<String, Object> mergedPRMPs, String propName, Method readerMethod) {
        Object replaced = mergedPRMPs.put(propName, readerMethod);
        if (replaced != null) {
            this.putIfMergedPropertyReaderMethodPairDiffers(mergedPRMPs, propName, replaced, new PropertyReaderedMethodPair(readerMethod, null));
        }
    }

    private void putIfMergedPropertyReaderMethodPairDiffers(LinkedHashMap<String, Object> mergedPRMPs, String propName, Object replaced, PropertyReaderedMethodPair newPRMP) {
        PropertyReaderedMethodPair replacedPRMP = PropertyReaderedMethodPair.from(replaced);
        PropertyReaderedMethodPair mergedPRMP = PropertyReaderedMethodPair.merge(replacedPRMP, newPRMP);
        if (!mergedPRMP.equals(newPRMP)) {
            mergedPRMPs.put(propName, mergedPRMP);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<MethodDescriptor> getMethodDescriptors(BeanInfo beanInfo, Class<?> clazz) {
        void var8_10;
        List<MethodDescriptor> introspectionMDs;
        MethodDescriptor[] introspectorMDArray = beanInfo.getMethodDescriptors();
        List<MethodDescriptor> list = introspectionMDs = introspectorMDArray != null && introspectorMDArray.length != 0 ? Arrays.asList(introspectorMDArray) : Collections.emptyList();
        if (!this.treatDefaultMethodsAsBeanMembers || _JavaVersions.JAVA_8 == null) {
            return introspectionMDs;
        }
        HashMap<String, ArrayList<Method>> defaultMethodsToAddByName = null;
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        boolean bl = false;
        while (var8_10 < n) {
            Method method = methodArray[var8_10];
            if (_JavaVersions.JAVA_8.isDefaultMethod(method) && !method.isBridge()) {
                ArrayList<Method> overloads;
                if (defaultMethodsToAddByName == null) {
                    defaultMethodsToAddByName = new HashMap<String, ArrayList<Method>>();
                }
                if ((overloads = (ArrayList<Method>)defaultMethodsToAddByName.get(method.getName())) == null) {
                    overloads = new ArrayList<Method>(0);
                    defaultMethodsToAddByName.put(method.getName(), overloads);
                }
                overloads.add(method);
            }
            ++var8_10;
        }
        if (defaultMethodsToAddByName == null) {
            return introspectionMDs;
        }
        ArrayList<MethodDescriptor> newIntrospectionMDs = new ArrayList<MethodDescriptor>(introspectionMDs.size() + 16);
        for (MethodDescriptor methodDescriptor : introspectionMDs) {
            Method introspectorM = methodDescriptor.getMethod();
            if (this.containsMethodWithSameParameterTypes((List)defaultMethodsToAddByName.get(introspectorM.getName()), introspectorM)) continue;
            newIntrospectionMDs.add(methodDescriptor);
        }
        introspectionMDs = newIntrospectionMDs;
        for (Map.Entry entry : defaultMethodsToAddByName.entrySet()) {
            for (Method method : (List)entry.getValue()) {
                introspectionMDs.add(new MethodDescriptor(method));
            }
        }
        return introspectionMDs;
    }

    private boolean containsMethodWithSameParameterTypes(List<Method> overloads, Method m) {
        if (overloads == null) {
            return false;
        }
        Object[] paramTypes = m.getParameterTypes();
        for (Method overload : overloads) {
            if (!Arrays.equals(overload.getParameterTypes(), paramTypes)) continue;
            return true;
        }
        return false;
    }

    private void addPropertyDescriptorToClassIntrospectionData(Map<Object, Object> introspData, PropertyDescriptor pd, Class<?> clazz, Map<MethodSignature, List<Method>> accessibleMethods) {
        if (pd instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
            Method readMethod = ipd.getIndexedReadMethod();
            Method publicReadMethod = ClassIntrospector.getMatchingAccessibleMethod(readMethod, accessibleMethods);
            if (publicReadMethod != null && this.isAllowedToExpose(publicReadMethod)) {
                try {
                    if (readMethod != publicReadMethod) {
                        ipd = new IndexedPropertyDescriptor(ipd.getName(), ipd.getReadMethod(), null, publicReadMethod, null);
                    }
                    introspData.put(ipd.getName(), ipd);
                    ClassIntrospector.getArgTypesByMethod(introspData).put(publicReadMethod, publicReadMethod.getParameterTypes());
                }
                catch (IntrospectionException e) {
                    LOG.warn("Failed creating a publicly-accessible property descriptor for " + clazz.getName() + " indexed property " + pd.getName() + ", read method " + publicReadMethod, e);
                }
            }
        } else {
            Method readMethod = pd.getReadMethod();
            Method publicReadMethod = ClassIntrospector.getMatchingAccessibleMethod(readMethod, accessibleMethods);
            if (publicReadMethod != null && this.isAllowedToExpose(publicReadMethod)) {
                try {
                    if (readMethod != publicReadMethod) {
                        pd = new PropertyDescriptor(pd.getName(), publicReadMethod, null);
                    }
                    introspData.put(pd.getName(), pd);
                }
                catch (IntrospectionException e) {
                    LOG.warn("Failed creating a publicly-accessible property descriptor for " + clazz.getName() + " property " + pd.getName() + ", read method " + publicReadMethod, e);
                }
            }
        }
    }

    private void addGenericGetToClassIntrospectionData(Map<Object, Object> introspData, Map<MethodSignature, List<Method>> accessibleMethods) {
        Method genericGet = ClassIntrospector.getFirstAccessibleMethod(MethodSignature.GET_STRING_SIGNATURE, accessibleMethods);
        if (genericGet == null) {
            genericGet = ClassIntrospector.getFirstAccessibleMethod(MethodSignature.GET_OBJECT_SIGNATURE, accessibleMethods);
        }
        if (genericGet != null) {
            introspData.put(GENERIC_GET_KEY, genericGet);
        }
    }

    private void addConstructorsToClassIntrospectionData(Map<Object, Object> introspData, Class<?> clazz) {
        try {
            Constructor<?>[] ctors = clazz.getConstructors();
            if (ctors.length == 1) {
                Constructor<?> ctor = ctors[0];
                introspData.put(CONSTRUCTORS_KEY, new SimpleMethod(ctor, ctor.getParameterTypes()));
            } else if (ctors.length > 1) {
                OverloadedMethods overloadedCtors = new OverloadedMethods(this.bugfixed);
                for (int i = 0; i < ctors.length; ++i) {
                    overloadedCtors.addConstructor(ctors[i]);
                }
                introspData.put(CONSTRUCTORS_KEY, overloadedCtors);
            }
        }
        catch (SecurityException e) {
            LOG.warn("Can't discover constructors for class " + clazz.getName(), e);
        }
    }

    private static Map<MethodSignature, List<Method>> discoverAccessibleMethods(Class<?> clazz) {
        HashMap<MethodSignature, List<Method>> accessibles = new HashMap<MethodSignature, List<Method>>();
        ClassIntrospector.discoverAccessibleMethods(clazz, accessibles);
        return accessibles;
    }

    private static void discoverAccessibleMethods(Class<?> clazz, Map<MethodSignature, List<Method>> accessibles) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                Method[] methods = clazz.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    MethodSignature sig = new MethodSignature(method);
                    List<Method> methodList = accessibles.get(sig);
                    if (methodList == null) {
                        methodList = new LinkedList<Method>();
                        accessibles.put(sig, methodList);
                    }
                    methodList.add(method);
                }
                return;
            }
            catch (SecurityException e) {
                LOG.warn("Could not discover accessible methods of class " + clazz.getName() + ", attemping superclasses/interfaces.", e);
            }
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ClassIntrospector.discoverAccessibleMethods(interfaces[i], accessibles);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            ClassIntrospector.discoverAccessibleMethods(superclass, accessibles);
        }
    }

    private static Method getMatchingAccessibleMethod(Method m, Map<MethodSignature, List<Method>> accessibles) {
        if (m == null) {
            return null;
        }
        MethodSignature sig = new MethodSignature(m);
        List<Method> ams = accessibles.get(sig);
        if (ams == null) {
            return null;
        }
        for (Method am : ams) {
            if (am.getReturnType() != m.getReturnType()) continue;
            return am;
        }
        return null;
    }

    private static Method getFirstAccessibleMethod(MethodSignature sig, Map<MethodSignature, List<Method>> accessibles) {
        List<Method> ams = accessibles.get(sig);
        if (ams == null || ams.isEmpty()) {
            return null;
        }
        return ams.get(0);
    }

    private void sortMethodDescriptors(List<MethodDescriptor> methodDescriptors) {
        if (this.methodSorter != null) {
            this.methodSorter.sortMethodDescriptors(methodDescriptors);
        }
    }

    boolean isAllowedToExpose(Method method) {
        return this.exposureLevel < 1 || !UnsafeMethods.isUnsafeMethod(method);
    }

    private static Map<Method, Class<?>[]> getArgTypesByMethod(Map<Object, Object> classInfo) {
        HashMap argTypes = (HashMap)classInfo.get(ARG_TYPES_BY_METHOD_KEY);
        if (argTypes == null) {
            argTypes = new HashMap();
            classInfo.put(ARG_TYPES_BY_METHOD_KEY, argTypes);
        }
        return argTypes;
    }

    void clearCache() {
        if (this.getHasSharedInstanceRestrictons()) {
            throw new IllegalStateException("It's not allowed to clear the whole cache in a read-only " + this.getClass().getName() + "instance. Use removeFromClassIntrospectionCache(String prefix) instead.");
        }
        this.forcedClearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forcedClearCache() {
        Object object = this.sharedLock;
        synchronized (object) {
            this.cache.clear();
            this.cacheClassNames.clear();
            ++this.clearingCounter;
            for (WeakReference<Object> regedMfREf : this.modelFactories) {
                Object regedMf = regedMfREf.get();
                if (regedMf == null) continue;
                if (regedMf instanceof ClassBasedModelFactory) {
                    ((ClassBasedModelFactory)regedMf).clearCache();
                    continue;
                }
                if (regedMf instanceof ModelCache) {
                    ((ModelCache)regedMf).clearCache();
                    continue;
                }
                throw new BugException();
            }
            this.removeClearedModelFactoryReferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Class<?> clazz) {
        Object object = this.sharedLock;
        synchronized (object) {
            this.cache.remove(clazz);
            this.cacheClassNames.remove(clazz.getName());
            ++this.clearingCounter;
            for (WeakReference<Object> regedMfREf : this.modelFactories) {
                Object regedMf = regedMfREf.get();
                if (regedMf == null) continue;
                if (regedMf instanceof ClassBasedModelFactory) {
                    ((ClassBasedModelFactory)regedMf).removeFromCache(clazz);
                    continue;
                }
                if (regedMf instanceof ModelCache) {
                    ((ModelCache)regedMf).clearCache();
                    continue;
                }
                throw new BugException();
            }
            this.removeClearedModelFactoryReferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getClearingCounter() {
        Object object = this.sharedLock;
        synchronized (object) {
            return this.clearingCounter;
        }
    }

    private void onSameNameClassesDetected(String className) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Detected multiple classes with the same name, \"" + className + "\". Assuming it was a class-reloading. Clearing class introspection caches to release old data.");
        }
        this.forcedClearCache();
    }

    void registerModelFactory(ClassBasedModelFactory mf) {
        this.registerModelFactory((Object)mf);
    }

    void registerModelFactory(ModelCache mf) {
        this.registerModelFactory((Object)mf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerModelFactory(Object mf) {
        Object object = this.sharedLock;
        synchronized (object) {
            this.modelFactories.add(new WeakReference<Object>(mf, this.modelFactoriesRefQueue));
            this.removeClearedModelFactoryReferences();
        }
    }

    void unregisterModelFactory(ClassBasedModelFactory mf) {
        this.unregisterModelFactory((Object)mf);
    }

    void unregisterModelFactory(ModelCache mf) {
        this.unregisterModelFactory((Object)mf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterModelFactory(Object mf) {
        Object object = this.sharedLock;
        synchronized (object) {
            Iterator<WeakReference<Object>> it = this.modelFactories.iterator();
            while (it.hasNext()) {
                Object regedMf = it.next().get();
                if (regedMf != mf) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClearedModelFactoryReferences() {
        Reference<Object> cleardRef;
        while ((cleardRef = this.modelFactoriesRefQueue.poll()) != null) {
            Object object = this.sharedLock;
            synchronized (object) {
                Iterator<WeakReference<Object>> it = this.modelFactories.iterator();
                while (it.hasNext()) {
                    if (it.next() != cleardRef) continue;
                    it.remove();
                    break;
                }
            }
        }
    }

    static Class<?>[] getArgTypes(Map<Object, Object> classInfo, Method method) {
        Map argTypesByMethod = (Map)classInfo.get(ARG_TYPES_BY_METHOD_KEY);
        return (Class[])argTypesByMethod.get(method);
    }

    int keyCount(Class<?> clazz) {
        Map<Object, Object> map = this.get(clazz);
        int count = map.size();
        if (map.containsKey(CONSTRUCTORS_KEY)) {
            --count;
        }
        if (map.containsKey(GENERIC_GET_KEY)) {
            --count;
        }
        if (map.containsKey(ARG_TYPES_BY_METHOD_KEY)) {
            --count;
        }
        return count;
    }

    Set<Object> keySet(Class<?> clazz) {
        HashSet<Object> set = new HashSet<Object>(this.get(clazz).keySet());
        set.remove(CONSTRUCTORS_KEY);
        set.remove(GENERIC_GET_KEY);
        set.remove(ARG_TYPES_BY_METHOD_KEY);
        return set;
    }

    int getExposureLevel() {
        return this.exposureLevel;
    }

    boolean getExposeFields() {
        return this.exposeFields;
    }

    boolean getTreatDefaultMethodsAsBeanMembers() {
        return this.treatDefaultMethodsAsBeanMembers;
    }

    MethodAppearanceFineTuner getMethodAppearanceFineTuner() {
        return this.methodAppearanceFineTuner;
    }

    MethodSorter getMethodSorter() {
        return this.methodSorter;
    }

    boolean getHasSharedInstanceRestrictons() {
        return this.hasSharedInstanceRestrictons;
    }

    boolean isShared() {
        return this.shared;
    }

    Object getSharedLock() {
        return this.sharedLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getRegisteredModelFactoriesSnapshot() {
        Object object = this.sharedLock;
        synchronized (object) {
            return this.modelFactories.toArray();
        }
    }

    static {
        ClassChangeNotifier classChangeNotifier;
        boolean jRebelAvailable;
        LOG = Logger.getLogger("freemarker.beans");
        DEVELOPMENT_MODE = "true".equals(SecurityUtilities.getSystemProperty("freemarker.development", "false"));
        try {
            Class.forName(JREBEL_SDK_CLASS_NAME);
            jRebelAvailable = true;
        }
        catch (Throwable e) {
            jRebelAvailable = false;
            try {
                if (!(e instanceof ClassNotFoundException)) {
                    LOG.error(JREBEL_INTEGRATION_ERROR_MSG, e);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (jRebelAvailable) {
            try {
                classChangeNotifier = (ClassChangeNotifier)Class.forName("freemarker.ext.beans.JRebelClassChangeNotifier").newInstance();
            }
            catch (Throwable e) {
                classChangeNotifier = null;
                try {
                    LOG.error(JREBEL_INTEGRATION_ERROR_MSG, e);
                }
                catch (Throwable throwable) {}
            }
        } else {
            classChangeNotifier = null;
        }
        CLASS_CHANGE_NOTIFIER = classChangeNotifier;
        ARG_TYPES_BY_METHOD_KEY = new Object();
        CONSTRUCTORS_KEY = new Object();
        GENERIC_GET_KEY = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MethodSignature {
        private static final MethodSignature GET_STRING_SIGNATURE = new MethodSignature("get", new Class[]{String.class});
        private static final MethodSignature GET_OBJECT_SIGNATURE = new MethodSignature("get", new Class[]{Object.class});
        private final String name;
        private final Class<?>[] args;

        private MethodSignature(String name, Class<?>[] args) {
            this.name = name;
            this.args = args;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature ms = (MethodSignature)o;
                return ms.name.equals(this.name) && Arrays.equals(this.args, ms.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }

    private static class PropertyReaderedMethodPair {
        private final Method readMethod;
        private final Method indexedReadMethod;

        PropertyReaderedMethodPair(Method readerMethod, Method indexedReaderMethod) {
            this.readMethod = readerMethod;
            this.indexedReadMethod = indexedReaderMethod;
        }

        PropertyReaderedMethodPair(PropertyDescriptor pd) {
            this(pd.getReadMethod(), pd instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)pd).getIndexedReadMethod() : null);
        }

        static PropertyReaderedMethodPair from(Object obj) {
            if (obj instanceof PropertyReaderedMethodPair) {
                return (PropertyReaderedMethodPair)obj;
            }
            if (obj instanceof PropertyDescriptor) {
                return new PropertyReaderedMethodPair((PropertyDescriptor)obj);
            }
            if (obj instanceof Method) {
                return new PropertyReaderedMethodPair((Method)obj, null);
            }
            throw new BugException("Unexpected obj type: " + obj.getClass().getName());
        }

        static PropertyReaderedMethodPair merge(PropertyReaderedMethodPair oldMethods, PropertyReaderedMethodPair newMethods) {
            return new PropertyReaderedMethodPair(newMethods.readMethod != null ? newMethods.readMethod : oldMethods.readMethod, newMethods.indexedReadMethod != null ? newMethods.indexedReadMethod : oldMethods.indexedReadMethod);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.indexedReadMethod == null ? 0 : this.indexedReadMethod.hashCode());
            result = 31 * result + (this.readMethod == null ? 0 : this.readMethod.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyReaderedMethodPair other = (PropertyReaderedMethodPair)obj;
            return other.readMethod == this.readMethod && other.indexedReadMethod == this.indexedReadMethod;
        }
    }
}

