/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.client.views.pfly.widgets.Button;
import org.uberfire.client.views.pfly.widgets.InlineNotification;
import org.uberfire.client.views.pfly.widgets.Modal;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class ConfirmPopup {
    @Inject
    @DataField(value="confirm-title")
    Span modalTitle;
    @Inject
    @DataField(value="confirm-inline-notification")
    InlineNotification confirmInlineNotification;
    @Inject
    @DataField(value="confirm-message")
    Span modalConfirmationMessageLabel;
    @Inject
    @DataField(value="confirm-cancel")
    Button cancelButton;
    @Inject
    @DataField(value="confirm-ok")
    Button okButton;
    @Inject
    @DataField(value="modal")
    private Modal modal;
    @Inject
    private TranslationService translationService;
    private Command okCommand;

    @PostConstruct
    public void init() {
        this.cancelButton.setText(this.translationService.getTranslation("ConfirmPopup.Cancel"));
    }

    public void show(String title, String okButtonText, String confirmMessage, Command okCommand) {
        this.show(title, null, null, okButtonText, Button.ButtonStyleType.DANGER, confirmMessage, okCommand);
    }

    public void show(String title, String inlineNotificationMessage, InlineNotification.InlineNotificationType inlineNotificationType, String okButtonText, Button.ButtonStyleType okButtonType, String confirmMessage, Command okCommand) {
        this.okCommand = okCommand;
        this.modalTitle.setTextContent(title);
        if (inlineNotificationMessage != null && inlineNotificationType != null) {
            this.confirmInlineNotification.setMessage(inlineNotificationMessage);
            this.confirmInlineNotification.setType(inlineNotificationType);
            this.confirmInlineNotification.getElement().getStyle().removeProperty("display");
        } else {
            this.confirmInlineNotification.getElement().getStyle().setProperty("display", "none");
        }
        this.okButton.setText(okButtonText);
        if (okButtonType != null) {
            this.okButton.setButtonStyleType(okButtonType);
        }
        this.modalConfirmationMessageLabel.setTextContent(confirmMessage);
        this.modal.show();
    }

    public void hide() {
        this.modal.hide();
    }

    public HTMLElement getElement() {
        return this.modal.getElement();
    }

    @EventHandler(value={"confirm-ok"})
    public void onOkClick(@ForEvent(value={"click"}) MouseEvent event) {
        if (this.okCommand != null) {
            this.okCommand.execute();
        }
        this.hide();
    }

    @EventHandler(value={"confirm-cancel"})
    public void onCancelClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"confirm-close"})
    public void onCloseClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }
}

