/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.impl.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import org.uberfire.preferences.shared.PropertyValidator;
import org.uberfire.preferences.shared.impl.validation.ValidationResult;

public class ConstrainedValuesValidator<T>
implements PropertyValidator {
    static final String NOT_ALLOWED_VALIDATION_KEY = "PropertyValidator.ConstrainedValuesValidator.NotAllowed";
    private final Supplier<Collection<T>> allowedValuesSupplier;
    private final Function<Object, T> valueParser;

    public ConstrainedValuesValidator(Supplier<Collection<T>> allowedValuesSupplier, Function<Object, T> valueParser) {
        this.allowedValuesSupplier = allowedValuesSupplier;
        this.valueParser = valueParser;
    }

    public ValidationResult validate(Object raw) {
        Object value = this.valueParser.apply(raw);
        return this.allowedValuesSupplier.get().stream().anyMatch(v -> v.equals(value)) ? new ValidationResult(true, Collections.emptyList()) : new ValidationResult(false, Collections.singletonList(NOT_ALLOWED_VALIDATION_KEY));
    }
}

