/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.promise.Promise;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class FetchEvent extends Event {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface RespondWithRUnionType {
    @JsOverlay
    static RespondWithRUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Promise<Response> asPromise() {
      return Js.cast(this);
    }

    @JsOverlay
    default Response asResponse() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isPromise() {
      return (Object) this instanceof Promise;
    }

    @JsOverlay
    default boolean isResponse() {
      return (Object) this instanceof Response;
    }
  }

  public ServiceWorkerClient client;
  public boolean isReload;
  public Promise<Response> preloadResponse;
  public Request request;

  public FetchEvent(String type, FetchEventInit eventInitDict) {
    // This call is only here for java compilation purpose.
    super((String) null, (EventInit) null);
  }

  public FetchEvent(String type) {
    // This call is only here for java compilation purpose.
    super((String) null, (EventInit) null);
  }

  @JsMethod(name = "default")
  public native Promise<Response> default_();

  public native Promise<Response> forwardTo(String url);

  @JsOverlay
  public final void respondWith(Promise<Response> r) {
    respondWith(Js.<RespondWithRUnionType>uncheckedCast(r));
  }

  public native void respondWith(RespondWithRUnionType r);

  @JsOverlay
  public final void respondWith(Response r) {
    respondWith(Js.<RespondWithRUnionType>uncheckedCast(r));
  }
}
