/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql.query.impl;

import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.sparql.query.ResourceOrVariable;
import org.apache.clerezza.rdf.core.sparql.query.TriplePattern;
import org.apache.clerezza.rdf.core.sparql.query.UriRefOrVariable;
import org.apache.clerezza.rdf.core.sparql.query.Variable;

public class SimpleTriplePattern
implements TriplePattern {
    private ResourceOrVariable subject;
    private UriRefOrVariable predicate;
    private ResourceOrVariable object;

    public SimpleTriplePattern(ResourceOrVariable subject, UriRefOrVariable predicate, ResourceOrVariable object) {
        if (subject == null) {
            throw new IllegalArgumentException("Invalid subject: null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("Invalid predicate: null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Invalid object: null");
        }
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public SimpleTriplePattern(Variable subject, Variable predicate, Variable object) {
        this(new ResourceOrVariable(subject), new UriRefOrVariable(predicate), new ResourceOrVariable(object));
    }

    public SimpleTriplePattern(NonLiteral subject, Variable predicate, Variable object) {
        this(new ResourceOrVariable(subject), new UriRefOrVariable(predicate), new ResourceOrVariable(object));
    }

    public SimpleTriplePattern(Variable subject, UriRef predicate, Variable object) {
        this(new ResourceOrVariable(subject), new UriRefOrVariable(predicate), new ResourceOrVariable(object));
    }

    public SimpleTriplePattern(NonLiteral subject, UriRef predicate, Variable object) {
        this(new ResourceOrVariable(subject), new UriRefOrVariable(predicate), new ResourceOrVariable(object));
    }

    public SimpleTriplePattern(Variable subject, Variable predicate, Resource object) {
        this(new ResourceOrVariable(subject), new UriRefOrVariable(predicate), new ResourceOrVariable(object));
    }

    public SimpleTriplePattern(NonLiteral subject, Variable predicate, Resource object) {
        this(new ResourceOrVariable(subject), new UriRefOrVariable(predicate), new ResourceOrVariable(object));
    }

    public SimpleTriplePattern(Variable subject, UriRef predicate, Resource object) {
        this(new ResourceOrVariable(subject), new UriRefOrVariable(predicate), new ResourceOrVariable(object));
    }

    public SimpleTriplePattern(NonLiteral subject, UriRef predicate, Resource object) {
        this(new ResourceOrVariable(subject), new UriRefOrVariable(predicate), new ResourceOrVariable(object));
    }

    @Override
    public ResourceOrVariable getSubject() {
        return this.subject;
    }

    @Override
    public UriRefOrVariable getPredicate() {
        return this.predicate;
    }

    @Override
    public ResourceOrVariable getObject() {
        return this.object;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriplePattern)) {
            return false;
        }
        TriplePattern other = (TriplePattern)obj;
        if (!this.subject.equals(other.getSubject())) {
            return false;
        }
        if (!this.predicate.equals(other.getPredicate())) {
            return false;
        }
        return this.object.equals(other.getObject());
    }

    public int hashCode() {
        return this.subject.hashCode() >> 1 ^ this.subject.hashCode() ^ this.subject.hashCode() << 1;
    }
}

