/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.manager;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemImpl;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProviderConfiguration;
import org.uberfire.java.nio.fs.jgit.manager.JGitFileSystemsCache;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.ws.JGitFileSystemsEventsManager;

public class JGitFileSystemsManager {
    private final Set<String> closedFileSystems = new HashSet<String>();
    private final Set<String> fileSystemsRoot = new HashSet<String>();
    private final JGitFileSystemProvider jGitFileSystemProvider;
    private final JGitFileSystemsCache fsCache;

    public JGitFileSystemsManager(JGitFileSystemProvider jGitFileSystemProvider, JGitFileSystemProviderConfiguration config) {
        this.jGitFileSystemProvider = jGitFileSystemProvider;
        this.fsCache = new JGitFileSystemsCache(config);
    }

    public void newFileSystem(Supplier<Map<String, String>> fullHostNames, Supplier<Git> git, Supplier<String> fsName, Supplier<CredentialsProvider> credential, Supplier<JGitFileSystemsEventsManager> fsManager) {
        Supplier<JGitFileSystem> fsSupplier = this.createFileSystemSupplier(fullHostNames, git, fsName, credential, fsManager);
        this.fsCache.addSupplier(fsName.get(), fsSupplier);
        this.fileSystemsRoot.addAll(this.parseFSRoots(fsName.get()));
    }

    List<String> parseFSRoots(String fsKey) {
        ArrayList<String> roots = new ArrayList<String>();
        fsKey = this.cleanupFsName(fsKey);
        int index = fsKey.indexOf("/");
        while (index >= 0) {
            roots.add(fsKey.substring(0, index));
            index = fsKey.indexOf("/", index + 1);
        }
        roots.add(fsKey);
        return roots;
    }

    private String cleanupFsName(String fsKey) {
        if (fsKey.startsWith("/")) {
            fsKey = fsKey.substring(1);
        }
        if (fsKey.endsWith("/")) {
            fsKey = fsKey.substring(0, fsKey.length() - 1);
        }
        return fsKey;
    }

    private Supplier<JGitFileSystem> createFileSystemSupplier(Supplier<Map<String, String>> fullHostNames, Supplier<Git> git, Supplier<String> fsName, Supplier<CredentialsProvider> credential, Supplier<JGitFileSystemsEventsManager> fsManager) {
        return () -> this.newFileSystem((Map)fullHostNames.get(), (Git)git.get(), (String)fsName.get(), (CredentialsProvider)credential.get(), (JGitFileSystemsEventsManager)fsManager.get());
    }

    private JGitFileSystem newFileSystem(Map<String, String> fullHostNames, Git git, String fsName, CredentialsProvider credential, JGitFileSystemsEventsManager fsEventsManager) {
        JGitFileSystemImpl fs = new JGitFileSystemImpl(this.jGitFileSystemProvider, fullHostNames, git, fsName, credential, fsEventsManager);
        fs.getGit().gc();
        return fs;
    }

    public void remove(String realFSKey) {
        this.fsCache.remove(realFSKey);
        this.closedFileSystems.remove(realFSKey);
    }

    public JGitFileSystem get(String fsName) {
        return this.fsCache.get(fsName);
    }

    public void clear() {
        this.fsCache.clear();
        this.closedFileSystems.clear();
        this.fileSystemsRoot.clear();
    }

    public boolean containsKey(String fsName) {
        return this.fsCache.getFileSystems().contains(fsName) && !this.closedFileSystems.contains(fsName);
    }

    public boolean containsRoot(String fsName) {
        return this.fileSystemsRoot.contains(fsName);
    }

    public void addClosedFileSystems(JGitFileSystem fileSystem) {
        String realFSKey = fileSystem.getName();
        this.closedFileSystems.add(realFSKey);
        List<String> roots = this.parseFSRoots(fileSystem.getName());
        this.fileSystemsRoot.removeAll(roots);
    }

    public boolean allTheFSAreClosed() {
        return this.closedFileSystems.size() == this.fsCache.getFileSystems().size();
    }

    public JGitFileSystem get(Repository db) {
        String key = this.extractFSNameFromRepo(db);
        return this.fsCache.get(key);
    }

    public Set<JGitFileSystem> getOpenFileSystems() {
        return this.fsCache.getFileSystems().stream().filter(fsName -> !this.closedFileSystems.contains(fsName)).map(fsName -> this.get((String)fsName)).collect(Collectors.toSet());
    }

    public JGitFileSystemsCache getFsCache() {
        return this.fsCache;
    }

    private String extractFSNameFromRepo(Repository db) {
        String nioGitPath = ".niogit/";
        String fullPath = db.getDirectory().getPath();
        fullPath = fullPath.substring(fullPath.indexOf(".niogit/") + ".niogit/".length(), fullPath.length());
        String fsName = fullPath.substring(0, fullPath.indexOf(".git"));
        return fsName;
    }
}

