/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.internal.ketch.KetchLeaderCache;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.commons.data.Pair;
import org.uberfire.java.nio.fs.jgit.util.Git;

public class Clone {
    private final File repoDir;
    private final String origin;
    private final CredentialsProvider credentialsProvider;
    private final boolean isMirror;
    private final KetchLeaderCache leaders;

    public Clone(File directory, String origin, boolean isMirror, CredentialsProvider credentialsProvider, KetchLeaderCache leaders) {
        this.repoDir = (File)PortablePreconditions.checkNotNull((String)"directory", (Object)directory);
        this.origin = PortablePreconditions.checkNotEmpty((String)"origin", (String)origin);
        this.isMirror = isMirror;
        this.credentialsProvider = credentialsProvider;
        this.leaders = leaders;
    }

    public Optional<Git> execute() throws InvalidRemoteException {
        Git git = Git.createRepository(this.repoDir, null);
        if (git != null) {
            List<Object> refSpecList = this.isMirror ? Collections.singletonList(new RefSpec("+refs/*:refs/*")) : Collections.emptyList();
            Pair remote = Pair.newPair((Object)"origin", (Object)this.origin);
            git.fetch(this.credentialsProvider, (Pair<String, String>)remote, refSpecList);
            StoredConfig config = git.getRepository().getConfig();
            config.setBoolean("remote", "origin", "mirror", true);
            try {
                config.save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            git.syncRemote((Pair<String, String>)remote);
            if (git.isKetchEnabled()) {
                git.convertRefTree();
                git.updateLeaders(this.leaders);
            }
            git.setHeadAsInitialized();
            return Optional.of(git);
        }
        return Optional.empty();
    }
}

