/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.PathUtil;
import org.uberfire.java.nio.fs.jgit.util.model.PathInfo;

public class ListPathContent {
    private final Git git;
    private final String branchName;
    private final String path;

    public ListPathContent(Git git, String branchName, String path) {
        this.git = git;
        this.branchName = branchName;
        this.path = path;
    }

    public List<PathInfo> execute() throws IOException {
        String gitPath = PathUtil.normalize(this.path);
        ArrayList<PathInfo> result = new ArrayList<PathInfo>();
        ObjectId tree = this.git.getTreeFromRef(this.branchName);
        if (tree == null) {
            return result;
        }
        try (TreeWalk tw = new TreeWalk(this.git.getRepository());){
            boolean found = false;
            if (gitPath.isEmpty()) {
                found = true;
            } else {
                tw.setFilter((TreeFilter)PathFilter.create((String)gitPath));
            }
            tw.reset((AnyObjectId)tree);
            while (tw.next()) {
                if (!found && tw.isSubtree()) {
                    tw.enterSubtree();
                }
                if (tw.getPathString().equals(gitPath)) {
                    found = true;
                    continue;
                }
                if (!found) continue;
                result.add(new PathInfo(tw.getObjectId(0), tw.getPathString(), tw.getFileMode(0)));
            }
            ArrayList<PathInfo> arrayList = result;
            return arrayList;
        }
    }
}

