/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V3;

public class SessionBindingQueryResponseMessage_V4
extends SessionBindingQueryResponseMessage_V3 {
    private boolean defaultPurgeOnNoConsumers;
    private int defaultMaxConsumers;

    public SessionBindingQueryResponseMessage_V4(boolean exists, List<SimpleString> queueNames, boolean autoCreateQueues, boolean autoCreateAddresses, boolean defaultPurgeOnNoConsumers, int defaultMaxConsumers) {
        super((byte)-15);
        this.exists = exists;
        this.queueNames = queueNames;
        this.autoCreateQueues = autoCreateQueues;
        this.autoCreateAddresses = autoCreateAddresses;
        this.defaultPurgeOnNoConsumers = defaultPurgeOnNoConsumers;
        this.defaultMaxConsumers = defaultMaxConsumers;
    }

    public SessionBindingQueryResponseMessage_V4() {
        super((byte)-15);
    }

    public boolean isDefaultPurgeOnNoConsumers() {
        return this.defaultPurgeOnNoConsumers;
    }

    public int getDefaultMaxConsumers() {
        return this.defaultMaxConsumers;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeBoolean(this.defaultPurgeOnNoConsumers);
        buffer.writeInt(this.defaultMaxConsumers);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.defaultPurgeOnNoConsumers = buffer.readBoolean();
        this.defaultMaxConsumers = buffer.readInt();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.defaultPurgeOnNoConsumers ? 1231 : 1237);
        result = 31 * result + this.defaultMaxConsumers;
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append("]");
        return buff.toString();
    }

    @Override
    public String getParentString() {
        StringBuffer buff = new StringBuffer(super.getParentString());
        buff.append(", defaultPurgeOnNoConsumers=" + this.defaultPurgeOnNoConsumers);
        buff.append(", defaultMaxConsumers=" + this.defaultMaxConsumers);
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionBindingQueryResponseMessage_V4)) {
            return false;
        }
        SessionBindingQueryResponseMessage_V4 other = (SessionBindingQueryResponseMessage_V4)obj;
        if (this.defaultPurgeOnNoConsumers != other.defaultPurgeOnNoConsumers) {
            return false;
        }
        return this.defaultMaxConsumers == other.defaultMaxConsumers;
    }
}

