/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.commons.services.cdi.Startable;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.commons.services.cdi.Veto;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceNio2WrapperImpl;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileSystemState;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.InvalidPathException;
import org.uberfire.java.nio.file.LockableFileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.PathMatcher;
import org.uberfire.java.nio.file.PatternSyntaxException;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.UserPrincipalLookupService;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

public class SystemConfigProducer
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(SystemConfigProducer.class);
    private static final String CDI_METHOD = "cdi";
    private static final String START_METHOD = System.getProperty("org.uberfire.start.method", "cdi");
    private final List<OrderedBean> startupEagerBeans = new LinkedList<OrderedBean>();
    private final List<OrderedBean> startupBootstrapBeans = new LinkedList<OrderedBean>();
    private final Comparator<OrderedBean> priorityComparator = (o1, o2) -> o1.priority - o2.priority;
    private boolean systemFSNotExists = true;
    private boolean pluginsFSNotExists = true;
    private boolean perspectivesFSNotExists = true;
    private boolean datasetsFSNotExists = true;
    private boolean navigationFSNotExists = true;
    private boolean ioStrategyBeanNotFound = true;

    public void processSystemFSProducer(@Observes ProcessProducer<?, FileSystem> pp) {
        if (pp.getAnnotatedMember().getJavaMember().getName().equals("systemFS")) {
            this.ioStrategyBeanNotFound = false;
        }
    }

    public void processPluginsFSProducer(@Observes ProcessProducer<?, FileSystem> pp) {
        if (pp.getAnnotatedMember().getJavaMember().getName().equals("pluginsFS")) {
            this.ioStrategyBeanNotFound = false;
        }
    }

    public void processPerspectivesFSProducer(@Observes ProcessProducer<?, FileSystem> pp) {
        if (pp.getAnnotatedMember().getJavaMember().getName().equals("perspectivesFS")) {
            this.perspectivesFSNotExists = false;
        }
    }

    public void processDatasetsFSProducer(@Observes ProcessProducer<?, FileSystem> pp) {
        if (pp.getAnnotatedMember().getJavaMember().getName().equals("datasetsFS")) {
            this.datasetsFSNotExists = false;
        }
    }

    public void processNavigationFSProducer(@Observes ProcessProducer<?, FileSystem> pp) {
        if (pp.getAnnotatedMember().getJavaMember().getName().equals("navigationFS")) {
            this.navigationFSNotExists = false;
        }
    }

    public void processIOServiceProducer(@Observes ProcessProducer<?, IOService> pp) {
        if (pp.getAnnotatedMember().getJavaMember().getName().equals("ioStrategy")) {
            this.ioStrategyBeanNotFound = false;
        }
    }

    public <X> void processBean(@Observes ProcessBean<X> event) {
        Named namedAnnotation;
        if (event.getBean().getName() != null && event.getBean().getName().equals("systemFS")) {
            this.systemFSNotExists = false;
        } else if (event.getBean().getName() != null && event.getBean().getName().equals("pluginsFS")) {
            this.pluginsFSNotExists = false;
        } else if (event.getBean().getName() != null && event.getBean().getName().equals("perspectivesFS")) {
            this.perspectivesFSNotExists = false;
        } else if (event.getBean().getName() != null && event.getBean().getName().equals("datasetsFS")) {
            this.datasetsFSNotExists = false;
        } else if (event.getBean().getName() != null && event.getBean().getName().equals("navigationFS")) {
            this.navigationFSNotExists = false;
        } else if (event.getBean().getName() != null && event.getBean().getName().equals("ioStrategy")) {
            this.ioStrategyBeanNotFound = false;
        }
        if (event.getAnnotated().isAnnotationPresent(Startup.class) && (event.getAnnotated().isAnnotationPresent(ApplicationScoped.class) || event.getAnnotated().isAnnotationPresent(Singleton.class))) {
            Startup startupAnnotation = (Startup)event.getAnnotated().getAnnotation(Startup.class);
            StartupType type = startupAnnotation.value();
            int priority = startupAnnotation.priority();
            Bean bean = event.getBean();
            switch (type) {
                case EAGER: {
                    this.startupEagerBeans.add(new OrderedBean(bean, priority));
                    break;
                }
                case BOOTSTRAP: {
                    this.startupBootstrapBeans.add(new OrderedBean(bean, priority));
                }
            }
        } else if (event.getAnnotated().isAnnotationPresent(Named.class) && (event.getAnnotated().isAnnotationPresent(ApplicationScoped.class) || event.getAnnotated().isAnnotationPresent(Singleton.class)) && (namedAnnotation = (Named)event.getAnnotated().getAnnotation(Named.class)).value().endsWith("-startable")) {
            Bean bean = event.getBean();
            this.startupBootstrapBeans.add(new OrderedBean(bean, 10));
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager manager) {
        if (CDI_METHOD.equalsIgnoreCase(START_METHOD)) {
            this.runPostConstruct(manager, this.startupBootstrapBeans);
            this.runPostConstruct(manager, this.startupEagerBeans);
        }
    }

    private void runPostConstruct(BeanManager manager, List<OrderedBean> orderedBeans) {
        Collections.sort(orderedBeans, this.priorityComparator);
        for (OrderedBean ob : orderedBeans) {
            Bean<?> bean = ob.bean;
            manager.getReference(bean, (Type)bean.getBeanClass(), manager.createCreationalContext(bean)).toString();
        }
    }

    <T> void processAnnotatedType(@Observes @WithAnnotations(value={Veto.class}) ProcessAnnotatedType<T> pat) {
        pat.veto();
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        if (this.systemFSNotExists) {
            this.buildSystemFS(abd, bm);
        }
        if (this.ioStrategyBeanNotFound) {
            this.buildIOStrategy(abd, bm);
        }
        if (this.perspectivesFSNotExists) {
            this.buildPerspectivesFS(abd, bm);
        }
        if (this.datasetsFSNotExists) {
            this.buildDatasetsFS(abd, bm);
        }
        if (this.navigationFSNotExists) {
            this.buildNavigationFS(abd, bm);
        }
        if (this.pluginsFSNotExists) {
            this.buildPluginsFS(abd, bm);
        }
        if (!CDI_METHOD.equalsIgnoreCase(START_METHOD)) {
            this.buildStartableBean(abd, bm);
        }
    }

    void buildPluginsFS(AfterBeanDiscovery abd, BeanManager bm) {
        InjectionTarget it = bm.createInjectionTarget(bm.createAnnotatedType(DummyFileSystem.class));
        abd.addBean(this.createFileSystemBean(bm, (InjectionTarget<DummyFileSystem>)it, SpacesAPI.DEFAULT_SPACE, "ioStrategy", "pluginsFS", "plugins"));
    }

    void buildPerspectivesFS(AfterBeanDiscovery abd, BeanManager bm) {
        InjectionTarget it = bm.createInjectionTarget(bm.createAnnotatedType(DummyFileSystem.class));
        abd.addBean(this.createFileSystemBean(bm, (InjectionTarget<DummyFileSystem>)it, SpacesAPI.DASHBUILDER_SPACE, "ioStrategy", "perspectivesFS", "perspectives"));
    }

    void buildDatasetsFS(AfterBeanDiscovery abd, BeanManager bm) {
        InjectionTarget it = bm.createInjectionTarget(bm.createAnnotatedType(DummyFileSystem.class));
        abd.addBean(this.createFileSystemBean(bm, (InjectionTarget<DummyFileSystem>)it, SpacesAPI.DASHBUILDER_SPACE, "ioStrategy", "datasetsFS", "datasets"));
    }

    void buildNavigationFS(AfterBeanDiscovery abd, BeanManager bm) {
        InjectionTarget it = bm.createInjectionTarget(bm.createAnnotatedType(DummyFileSystem.class));
        abd.addBean(this.createFileSystemBean(bm, (InjectionTarget<DummyFileSystem>)it, SpacesAPI.DASHBUILDER_SPACE, "ioStrategy", "navigationFS", "navigation"));
    }

    void buildSystemFS(AfterBeanDiscovery abd, BeanManager bm) {
        InjectionTarget it = bm.createInjectionTarget(bm.createAnnotatedType(DummyFileSystem.class));
        abd.addBean(this.createFileSystemBean(bm, (InjectionTarget<DummyFileSystem>)it, SpacesAPI.DEFAULT_SPACE, "configIO", "systemFS", "system"));
    }

    Bean<FileSystem> createFileSystemBean(final BeanManager bm, final InjectionTarget<DummyFileSystem> it, final Space space, final String ioService, final String beanName, final String fsName) {
        return new Bean<FileSystem>(){

            public Class<?> getBeanClass() {
                return FileSystem.class;
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return it.getInjectionPoints();
            }

            public String getName() {
                return beanName;
            }

            public Set<Annotation> getQualifiers() {
                return new HashSet<Annotation>(){
                    {
                        this.add(new AnnotationLiteral<Default>(){});
                        this.add(new AnnotationLiteral<Any>(){});
                        this.add(new NamedLiteral(beanName));
                    }
                };
            }

            public Class<? extends Annotation> getScope() {
                return ApplicationScoped.class;
            }

            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.emptySet();
            }

            public Set<Type> getTypes() {
                return new HashSet<Type>(){
                    {
                        this.add(FileSystem.class);
                        this.add(LockableFileSystem.class);
                        this.add(Object.class);
                    }
                };
            }

            public boolean isAlternative() {
                return false;
            }

            public boolean isNullable() {
                return false;
            }

            public FileSystem create(CreationalContext<FileSystem> ctx) {
                FileSystem fs;
                SpacesAPI spaces = SystemConfigProducer.this.getSpaces(bm);
                Bean bean = (Bean)bm.getBeans(ioService).iterator().next();
                CreationalContext _ctx = bm.createCreationalContext((Contextual)bean);
                IOService ioService2 = (IOService)bm.getReference(bean, IOService.class, _ctx);
                URI uri = SystemConfigProducer.this.resolveFSURI(spaces, space, fsName);
                HashMap<String, Object> env = new HashMap<String, Object>(){
                    {
                        this.put("init", Boolean.TRUE);
                        this.put("internal", Boolean.TRUE);
                    }
                };
                try {
                    fs = ioService2.newFileSystem(uri, (Map)env);
                }
                catch (FileSystemAlreadyExistsException e) {
                    fs = ioService2.getFileSystem(uri);
                }
                PriorityDisposableRegistry.register((String)beanName, (Object)fs);
                return fs;
            }

            public void destroy(FileSystem instance, CreationalContext<FileSystem> ctx) {
                try {
                    instance.dispose();
                    PriorityDisposableRegistry.unregister((String)beanName);
                }
                catch (Exception ex) {
                    logger.warn(ex.getMessage(), (Throwable)ex);
                }
                ctx.release();
            }
        };
    }

    URI resolveFSURI(SpacesAPI spaces, Space space, String fsName) {
        return spaces.resolveFileSystemURI(SpacesAPI.Scheme.GIT, space, fsName);
    }

    SpacesAPI getSpaces(BeanManager bm) {
        Bean spacesBean = (Bean)bm.getBeans(SpacesAPI.class, new Annotation[0]).iterator().next();
        CreationalContext spacesCtx = bm.createCreationalContext((Contextual)spacesBean);
        return (SpacesAPI)bm.getReference(spacesBean, SpacesAPI.class, spacesCtx);
    }

    private void buildIOStrategy(AfterBeanDiscovery abd, BeanManager bm) {
        final InjectionTarget it = bm.createInjectionTarget(bm.createAnnotatedType(IOServiceNio2WrapperImpl.class));
        abd.addBean((Bean)new Bean<IOService>(){

            public Class<?> getBeanClass() {
                return IOService.class;
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return it.getInjectionPoints();
            }

            public String getName() {
                return "ioStrategy";
            }

            public Set<Annotation> getQualifiers() {
                return new HashSet<Annotation>(){
                    {
                        this.add(new AnnotationLiteral<Default>(){});
                        this.add(new AnnotationLiteral<Any>(){});
                        this.add(new NamedLiteral("ioStrategy"));
                    }
                };
            }

            public Class<? extends Annotation> getScope() {
                return ApplicationScoped.class;
            }

            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.emptySet();
            }

            public Set<Type> getTypes() {
                return new HashSet<Type>(){
                    {
                        this.add(IOService.class);
                        this.add(Object.class);
                    }
                };
            }

            public boolean isAlternative() {
                return false;
            }

            public boolean isNullable() {
                return false;
            }

            public IOService create(CreationalContext<IOService> ctx) {
                return new IOServiceNio2WrapperImpl();
            }

            public void destroy(IOService instance, CreationalContext<IOService> ctx) {
                ctx.release();
            }
        });
    }

    private <T> T getBean(BeanManager bm, Class<T> clazz) {
        Bean bean = (Bean)bm.getBeans(clazz, new Annotation[0]).iterator().next();
        return this.getBeanReference(bm, clazz, bean);
    }

    private <T> T getBean(BeanManager bm, Class<T> clazz, Annotation qualifier) {
        Bean bean = (Bean)bm.getBeans(clazz, new Annotation[]{qualifier}).iterator().next();
        return this.getBeanReference(bm, clazz, bean);
    }

    private <T> T getBeanReference(BeanManager bm, Class<T> clazz, Bean<T> bean) {
        CreationalContext creationalContext = bm.createCreationalContext(bean);
        return (T)bm.getReference(bean, clazz, creationalContext);
    }

    private void buildStartableBean(AfterBeanDiscovery abd, final BeanManager bm) {
        abd.addBean((Bean)new Bean<Startable>(){

            public Class<?> getBeanClass() {
                return Startable.class;
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return Collections.emptySet();
            }

            public String getName() {
                return "startablebean";
            }

            public Set<Annotation> getQualifiers() {
                return new HashSet<Annotation>(){
                    {
                        this.add(new AnnotationLiteral<Default>(){});
                        this.add(new AnnotationLiteral<Any>(){});
                    }
                };
            }

            public Class<? extends Annotation> getScope() {
                return ApplicationScoped.class;
            }

            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.emptySet();
            }

            public Set<Type> getTypes() {
                return new HashSet<Type>(){
                    {
                        this.add(Startable.class);
                        this.add(Object.class);
                    }
                };
            }

            public boolean isAlternative() {
                return false;
            }

            public boolean isNullable() {
                return false;
            }

            public Startable create(CreationalContext<Startable> ctx) {
                return new Startable(){

                    public int hashCode() {
                        return super.hashCode();
                    }

                    public void start() {
                        SystemConfigProducer.this.runPostConstruct(bm, SystemConfigProducer.this.startupBootstrapBeans);
                        SystemConfigProducer.this.runPostConstruct(bm, SystemConfigProducer.this.startupEagerBeans);
                    }
                };
            }

            public void destroy(Startable instance, CreationalContext<Startable> ctx) {
                ctx.release();
            }
        });
    }

    public class NamedLiteral
    extends AnnotationLiteral<Named>
    implements Named {
        private final String value;

        public NamedLiteral(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    private class OrderedBean {
        Bean<?> bean;
        int priority;

        private OrderedBean(Bean<?> bean, int priority) {
            this.bean = bean;
            this.priority = priority;
        }
    }

    public static class DummyFileSystem
    implements FileSystem {
        private FileSystemState state = FileSystemState.NORMAL;

        public FileSystemProvider provider() {
            return null;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isReadOnly() {
            return false;
        }

        public String getSeparator() {
            return null;
        }

        public Iterable<Path> getRootDirectories() {
            return null;
        }

        public Iterable<FileStore> getFileStores() {
            return null;
        }

        public Set<String> supportedFileAttributeViews() {
            return null;
        }

        public Path getPath(String first, String ... more) throws InvalidPathException {
            return null;
        }

        public PathMatcher getPathMatcher(String syntaxAndPattern) throws IllegalArgumentException, PatternSyntaxException, UnsupportedOperationException {
            return null;
        }

        public UserPrincipalLookupService getUserPrincipalLookupService() throws UnsupportedOperationException {
            return null;
        }

        public WatchService newWatchService() throws UnsupportedOperationException, IOException {
            return null;
        }

        public String getName() {
            return "DummyFileSystem";
        }

        public void close() throws IOException {
        }

        public void dispose() {
        }
    }
}

