/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cdi.workspace;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.cdi.workspace.Workspace;
import org.uberfire.backend.server.cdi.workspace.WorkspaceManager;
import org.uberfire.backend.server.cdi.workspace.WorkspaceNameResolver;
import org.uberfire.backend.server.cdi.workspace.WorkspaceScoped;

public class WorkspaceScopeContext
implements Context {
    private static Logger logger = LoggerFactory.getLogger(WorkspaceScopeContext.class);
    private final BeanManager beanManager;
    private WorkspaceNameResolver resolver;

    public WorkspaceScopeContext(BeanManager beanManager) {
        this.beanManager = beanManager;
        this.resolver = new WorkspaceNameResolver(beanManager);
    }

    public Class<? extends Annotation> getScope() {
        return WorkspaceScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Bean<T> bean = this.getBean(contextual);
        Workspace workspace = this.getWorkspaceManager().getOrCreateWorkspace(this.getWorkspaceName());
        Object instance = this.getWorkspaceManager().getBean(workspace, bean.getBeanClass().getCanonicalName());
        if (instance == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Creating Bean <<{}>> with creational context for workspace <<{}>>", (Object)bean.getBeanClass(), (Object)workspace.getName());
            }
            Object created = bean.create(creationalContext);
            this.getWorkspaceManager().putBean(workspace, bean.getBeanClass().getCanonicalName(), created);
            return (T)created;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Bean <<{}>> found for workspace <<{}>>", (Object)bean.getBeanClass(), (Object)workspace.getName());
        }
        return instance;
    }

    public <T> T get(Contextual<T> contextual) {
        Bean<T> bean = this.getBean(contextual);
        Workspace workspace = this.getWorkspaceManager().getOrCreateWorkspace(this.getWorkspaceName());
        if (logger.isTraceEnabled()) {
            logger.trace("Getting Bean <<{}>> for workspace <<{}>>", (Object)bean.getBeanClass(), (Object)workspace.getName());
        }
        return this.getWorkspaceManager().getBean(workspace, bean.getBeanClass().getCanonicalName());
    }

    private String getWorkspaceName() {
        return this.resolver.getWorkspaceName();
    }

    public boolean isActive() {
        return true;
    }

    private <T> Bean<T> getBean(Contextual contextual) {
        return (Bean)contextual;
    }

    protected WorkspaceManager getWorkspaceManager() {
        return this.getBean(WorkspaceManager.class);
    }

    protected <T> T getBean(Class<T> clazz) {
        Bean bean = (Bean)this.beanManager.getBeans(clazz, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)bean);
        return (T)this.beanManager.getReference(bean, clazz, creationalContext);
    }
}

