/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.client;

import java.util.List;
import java.util.Set;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;

public interface ClientSession
extends XAResource,
AutoCloseable {
    public static final String JMS_SESSION_IDENTIFIER_PROPERTY = "jms-session";
    public static final String JMS_SESSION_CLIENT_ID_PROPERTY = "jms-client-id";

    public ClientSession start() throws ActiveMQException;

    public void stop() throws ActiveMQException;

    @Override
    public void close() throws ActiveMQException;

    public boolean isClosed();

    public void addFailureListener(SessionFailureListener var1);

    public boolean removeFailureListener(SessionFailureListener var1);

    public void addFailoverListener(FailoverEventListener var1);

    public boolean removeFailoverListener(FailoverEventListener var1);

    public int getVersion();

    public void createAddress(SimpleString var1, Set<RoutingType> var2, boolean var3) throws ActiveMQException;

    public void createAddress(SimpleString var1, RoutingType var2, boolean var3) throws ActiveMQException;

    @Deprecated
    public void createQueue(SimpleString var1, SimpleString var2, boolean var3) throws ActiveMQException;

    @Deprecated
    public void createSharedQueue(SimpleString var1, SimpleString var2, boolean var3) throws ActiveMQException;

    @Deprecated
    public void createSharedQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4) throws ActiveMQException;

    @Deprecated
    public void createQueue(String var1, String var2, boolean var3) throws ActiveMQException;

    @Deprecated
    public void createQueue(String var1, String var2) throws ActiveMQException;

    @Deprecated
    public void createQueue(SimpleString var1, SimpleString var2) throws ActiveMQException;

    @Deprecated
    public void createQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4) throws ActiveMQException;

    @Deprecated
    public void createQueue(String var1, String var2, String var3, boolean var4) throws ActiveMQException;

    @Deprecated
    public void createQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws ActiveMQException;

    @Deprecated
    public void createQueue(String var1, String var2, String var3, boolean var4, boolean var5) throws ActiveMQException;

    @Deprecated
    public void createTemporaryQueue(SimpleString var1, SimpleString var2) throws ActiveMQException;

    @Deprecated
    public void createTemporaryQueue(String var1, String var2) throws ActiveMQException;

    @Deprecated
    public void createTemporaryQueue(SimpleString var1, SimpleString var2, SimpleString var3) throws ActiveMQException;

    @Deprecated
    public void createTemporaryQueue(String var1, String var2, String var3) throws ActiveMQException;

    public void createQueue(SimpleString var1, RoutingType var2, SimpleString var3, boolean var4) throws ActiveMQException;

    public void createSharedQueue(SimpleString var1, RoutingType var2, SimpleString var3, boolean var4) throws ActiveMQException;

    public void createSharedQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, boolean var5) throws ActiveMQException;

    public void createQueue(String var1, RoutingType var2, String var3, boolean var4) throws ActiveMQException;

    public void createQueue(String var1, RoutingType var2, String var3) throws ActiveMQException;

    public void createQueue(SimpleString var1, RoutingType var2, SimpleString var3) throws ActiveMQException;

    public void createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, boolean var5) throws ActiveMQException;

    public void createQueue(String var1, RoutingType var2, String var3, String var4, boolean var5) throws ActiveMQException;

    public void createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6) throws ActiveMQException;

    public void createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8) throws ActiveMQException;

    public void createQueue(String var1, RoutingType var2, String var3, String var4, boolean var5, boolean var6) throws ActiveMQException;

    public void createQueue(String var1, RoutingType var2, String var3, String var4, boolean var5, boolean var6, int var7, boolean var8) throws ActiveMQException;

    public void createTemporaryQueue(SimpleString var1, RoutingType var2, SimpleString var3) throws ActiveMQException;

    public void createTemporaryQueue(String var1, RoutingType var2, String var3) throws ActiveMQException;

    public void createTemporaryQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4) throws ActiveMQException;

    public void createTemporaryQueue(String var1, RoutingType var2, String var3, String var4) throws ActiveMQException;

    public void deleteQueue(SimpleString var1) throws ActiveMQException;

    public void deleteQueue(String var1) throws ActiveMQException;

    public ClientConsumer createConsumer(SimpleString var1) throws ActiveMQException;

    public ClientConsumer createConsumer(String var1) throws ActiveMQException;

    public ClientConsumer createConsumer(SimpleString var1, SimpleString var2) throws ActiveMQException;

    public ClientConsumer createConsumer(String var1, String var2) throws ActiveMQException;

    public ClientConsumer createConsumer(SimpleString var1, boolean var2) throws ActiveMQException;

    public ClientConsumer createConsumer(String var1, boolean var2) throws ActiveMQException;

    public ClientConsumer createConsumer(String var1, String var2, boolean var3) throws ActiveMQException;

    public ClientConsumer createConsumer(SimpleString var1, SimpleString var2, boolean var3) throws ActiveMQException;

    public ClientConsumer createConsumer(SimpleString var1, SimpleString var2, int var3, int var4, boolean var5) throws ActiveMQException;

    public ClientConsumer createConsumer(String var1, String var2, int var3, int var4, boolean var5) throws ActiveMQException;

    public ClientProducer createProducer() throws ActiveMQException;

    public ClientProducer createProducer(SimpleString var1) throws ActiveMQException;

    public ClientProducer createProducer(String var1) throws ActiveMQException;

    public ClientProducer createProducer(SimpleString var1, int var2) throws ActiveMQException;

    public ClientMessage createMessage(boolean var1);

    public ClientMessage createMessage(byte var1, boolean var2);

    public ClientMessage createMessage(byte var1, boolean var2, long var3, long var5, byte var7);

    public QueueQuery queueQuery(SimpleString var1) throws ActiveMQException;

    public AddressQuery addressQuery(SimpleString var1) throws ActiveMQException;

    public XAResource getXAResource();

    public boolean isXA();

    public void commit() throws ActiveMQException;

    public void commit(boolean var1) throws ActiveMQException;

    public void rollback() throws ActiveMQException;

    public void rollback(boolean var1) throws ActiveMQException;

    public boolean isRollbackOnly();

    public boolean isAutoCommitSends();

    public boolean isAutoCommitAcks();

    public boolean isBlockOnAcknowledge();

    public ClientSession setSendAcknowledgementHandler(SendAcknowledgementHandler var1);

    public void addMetaData(String var1, String var2) throws ActiveMQException;

    public void addUniqueMetaData(String var1, String var2) throws ActiveMQException;

    public ClientSessionFactory getSessionFactory();

    public static interface QueueQuery {
        public boolean isExists();

        public boolean isTemporary();

        public boolean isDurable();

        public boolean isAutoCreateQueues();

        public int getConsumerCount();

        public long getMessageCount();

        public SimpleString getFilterString();

        public SimpleString getAddress();

        public SimpleString getName();

        public RoutingType getRoutingType();

        public int getMaxConsumers();

        public boolean isPurgeOnNoConsumers();

        public boolean isAutoCreated();
    }

    public static interface AddressQuery {
        public boolean isExists();

        public List<SimpleString> getQueueNames();

        public boolean isAutoCreateQueues();

        public boolean isAutoCreateAddresses();

        public boolean isDefaultPurgeOnNoConsumers();

        public int getDefaultMaxConsumers();
    }
}

