/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.CustomDiffCommand;

public class ListDiffs {
    private final Git git;
    private final ObjectId oldRef;
    private final ObjectId newRef;

    public ListDiffs(Git git, ObjectId oldRef, ObjectId newRef) {
        this.git = git;
        this.oldRef = oldRef;
        this.newRef = newRef;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DiffEntry> execute() {
        if (this.newRef == null) return Collections.emptyList();
        if (this.git.getRepository() == null) {
            return Collections.emptyList();
        }
        try (ObjectReader reader = this.git.getRepository().newObjectReader();){
            CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
            if (this.oldRef != null) {
                oldTreeIter.reset(reader, (AnyObjectId)this.oldRef);
            }
            CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
            newTreeIter.reset(reader, (AnyObjectId)this.newRef);
            Object object = new CustomDiffCommand(this.git).setNewTree((AbstractTreeIterator)newTreeIter).setOldTree((AbstractTreeIterator)oldTreeIter).setShowNameAndStatusOnly(true).call();
            return object;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

