/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.ketch.KetchLeaderCache;
import org.eclipse.jgit.internal.ketch.KetchSystem;
import org.eclipse.jgit.internal.storage.file.WindowCache;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.ProcessResult;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveThreadFactory;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.lifecycle.Disposable;
import org.uberfire.java.nio.Closeable;
import org.uberfire.java.nio.EncodingUtil;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AbstractPath;
import org.uberfire.java.nio.base.BasicFileAttributesImpl;
import org.uberfire.java.nio.base.ExtendedAttributeView;
import org.uberfire.java.nio.base.FileDiff;
import org.uberfire.java.nio.base.FileSystemState;
import org.uberfire.java.nio.base.SeekableByteChannelFileBasedImpl;
import org.uberfire.java.nio.base.attributes.HiddenAttributeView;
import org.uberfire.java.nio.base.attributes.HiddenAttributes;
import org.uberfire.java.nio.base.dotfiles.DotFileOption;
import org.uberfire.java.nio.base.dotfiles.DotFileUtils;
import org.uberfire.java.nio.base.options.CherryPickCopyOption;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.base.options.MergeCopyOption;
import org.uberfire.java.nio.base.options.SquashOption;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionAttributes;
import org.uberfire.java.nio.channels.AsynchronousFileChannel;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.AccessDeniedException;
import org.uberfire.java.nio.file.AccessMode;
import org.uberfire.java.nio.file.AmbiguousFileSystemNameException;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.StandardCopyOption;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.java.nio.file.StandardOpenOption;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.attribute.AttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.file.extensions.FileSystemHooks;
import org.uberfire.java.nio.fs.jgit.FileSystemLock;
import org.uberfire.java.nio.fs.jgit.FileSystemLockManager;
import org.uberfire.java.nio.fs.jgit.JGitBasicAttributeView;
import org.uberfire.java.nio.fs.jgit.JGitFSPath;
import org.uberfire.java.nio.fs.jgit.JGitFileStore;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemImpl;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProviderConfiguration;
import org.uberfire.java.nio.fs.jgit.JGitHiddenAttributeView;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.JGitSSHConfigSessionFactory;
import org.uberfire.java.nio.fs.jgit.JGitVersionAttributeView;
import org.uberfire.java.nio.fs.jgit.daemon.git.Daemon;
import org.uberfire.java.nio.fs.jgit.daemon.git.DaemonClient;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitSSHService;
import org.uberfire.java.nio.fs.jgit.manager.JGitFileSystemsManager;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.ProxyAuthenticator;
import org.uberfire.java.nio.fs.jgit.util.commands.Clone;
import org.uberfire.java.nio.fs.jgit.util.commands.PathUtil;
import org.uberfire.java.nio.fs.jgit.util.model.CommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.CommitInfo;
import org.uberfire.java.nio.fs.jgit.util.model.CopyCommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.DefaultCommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.MoveCommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.PathInfo;
import org.uberfire.java.nio.fs.jgit.util.model.PathType;
import org.uberfire.java.nio.fs.jgit.util.model.RevertCommitContent;
import org.uberfire.java.nio.fs.jgit.ws.JGitFileSystemsEventsManager;
import org.uberfire.java.nio.fs.jgit.ws.JGitWatchEvent;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.java.nio.security.SSHAuthenticator;
import org.uberfire.java.nio.security.SecuredFileSystemProvider;

public class JGitFileSystemProvider
implements SecuredFileSystemProvider,
Disposable {
    private static final Logger LOG = LoggerFactory.getLogger(JGitFileSystemProvider.class);
    private static final TimeUnit LOCK_LAST_ACCESS_TIME_UNIT = TimeUnit.SECONDS;
    private static final long LOCK_LAST_ACCESS_THRESHOLD = 10L;
    private final Map<String, String> fullHostNames = new HashMap<String, String>();
    private boolean isDefault;
    private final Object postponedEventsLock = new Object();
    private Daemon daemonService = null;
    private GitSSHService gitSSHService = null;
    private FS detectedFS = FS.DETECTED;
    private ExecutorService executorService;
    final KetchSystem system = new KetchSystem();
    final KetchLeaderCache leaders = new KetchLeaderCache(this.system);
    private AuthenticationService httpAuthenticator;
    private FileSystemAuthorizer authorizer;
    JGitFileSystemProviderConfiguration config;
    JGitFileSystemsManager fsManager;
    JGitFileSystemsEventsManager fsEventsManager;

    public JGitFileSystemProvider() {
        this(new ConfigProperties(System.getProperties()), Executors.newCachedThreadPool((ThreadFactory)new DescriptiveThreadFactory()));
    }

    public JGitFileSystemProvider(Map<String, String> gitPrefs) {
        this(new ConfigProperties(gitPrefs), Executors.newCachedThreadPool((ThreadFactory)new DescriptiveThreadFactory()));
    }

    public JGitFileSystemProvider(ConfigProperties gitPrefs, ExecutorService executorService) {
        this.executorService = executorService;
        this.setupConfigs(gitPrefs);
        this.setupFileSystemsManager();
        this.setupFSEvents();
        this.setupGitDefaultCredentials();
        this.setupSSH();
        this.setupFullHostNames();
        this.setupDaemon();
        this.setupGitSSH();
    }

    private void setupFSEvents() {
        this.fsEventsManager = new JGitFileSystemsEventsManager();
    }

    protected void setupFileSystemsManager() {
        this.fsManager = new JGitFileSystemsManager(this, this.config);
    }

    private void setupConfigs(ConfigProperties gitPrefs) {
        this.config = new JGitFileSystemProviderConfiguration();
        this.loadConfig(gitPrefs);
    }

    private void setupGitSSH() {
        if (this.config.isSshEnabled()) {
            this.buildAndStartSSH();
        } else {
            this.gitSSHService = null;
        }
    }

    private void setupDaemon() {
        if (this.config.isDaemonEnabled()) {
            this.buildAndStartDaemon();
        } else {
            this.daemonService = null;
        }
    }

    private void setupFullHostNames() {
        if (this.config.isDaemonEnabled()) {
            this.fullHostNames.put("git", this.config.getDaemonHostName() + ":" + this.config.getDaemonPort());
        }
        if (this.config.isSshEnabled()) {
            this.fullHostNames.put("ssh", this.config.getSshHostName() + ":" + this.config.getSshPort());
        }
    }

    private void setupSSH() {
        SshSessionFactory.setInstance((SshSessionFactory)new JGitSSHConfigSessionFactory(this.config));
    }

    private void setupGitDefaultCredentials() {
        CredentialsProvider.setDefault((CredentialsProvider)new UsernamePasswordCredentialsProvider("guest", ""));
    }

    private void loadConfig(ConfigProperties systemConfig) {
        this.config.load(systemConfig);
        if (this.config.httpProxyIsDefined()) {
            this.setupProxyAuthentication();
        }
    }

    private void setupProxyAuthentication() {
        Authenticator.setDefault(new ProxyAuthenticator(this.config.getHttpProxyUser(), this.config.getHttpProxyPassword(), this.config.getHttpsProxyUser(), this.config.getHttpsProxyPassword()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCloseFileSystem(JGitFileSystem fileSystem) {
        this.fsManager.addClosedFileSystems(fileSystem);
        Object object = this.postponedEventsLock;
        synchronized (object) {
            fileSystem.clearPostponedWatchEvents();
        }
        if (this.fsManager.allTheFSAreClosed()) {
            this.forceStopDaemon();
            this.shutdownSSH();
            this.shutdownEventsManager();
        }
    }

    protected void shutdownEventsManager() {
        this.fsEventsManager.shutdown();
    }

    public void onDisposeFileSystem(JGitFileSystem fileSystem) {
        this.onCloseFileSystem(fileSystem);
        this.fsManager.remove(fileSystem.id());
    }

    public void setAuthorizer(FileSystemAuthorizer authorizer) {
        this.authorizer = (FileSystemAuthorizer)PortablePreconditions.checkNotNull((String)"authorizer", (Object)authorizer);
    }

    public void setJAASAuthenticator(AuthenticationService authenticator) {
        if (this.gitSSHService != null) {
            this.gitSSHService.setUserPassAuthenticator(authenticator);
        }
    }

    public void setHTTPAuthenticator(AuthenticationService httpAuthenticator) {
        this.httpAuthenticator = httpAuthenticator;
    }

    public void setSSHAuthenticator(SSHAuthenticator authenticator) {
        PortablePreconditions.checkNotNull((String)"authenticator", (Object)authenticator);
        if (this.gitSSHService != null) {
            this.gitSSHService.setSshAuthenticator(authenticator);
        }
    }

    public void dispose() {
        this.shutdown();
    }

    public void addHostName(String protocol, String s) {
        this.fullHostNames.put(protocol, s);
    }

    public Map<String, String> getFullHostNames() {
        return new HashMap<String, String>(this.fullHostNames);
    }

    private User extractUser(Object client) {
        if (this.httpAuthenticator != null && client instanceof HttpServletRequest) {
            return this.httpAuthenticator.getUser();
        }
        if (client instanceof BaseGitCommand) {
            return ((BaseGitCommand)client).getUser();
        }
        return User.ANONYMOUS;
    }

    private void buildAndStartSSH() {
        ReceivePackFactory receivePackFactory = (req, db) -> this.getReceivePack("ssh", req, db);
        UploadPackFactory uploadPackFactory = (req, db) -> new UploadPack(db, (BaseGitCommand)req){
            final /* synthetic */ BaseGitCommand val$req;
            {
                this.val$req = baseGitCommand;
                super(x0);
                JGitFileSystem fs = JGitFileSystemProvider.this.fsManager.get(db);
                fs.filterBranchAccess(this, this.val$req.getUser());
            }
        };
        this.gitSSHService = new GitSSHService();
        this.gitSSHService.setup(this.config.getSshFileCertDir(), InetSocketAddress.createUnresolved(this.config.getSshHostAddr(), this.config.getSshPort()), this.config.getSshIdleTimeout(), this.config.getSshAlgorithm(), receivePackFactory, uploadPackFactory, this.getRepositoryResolver(), this.executorService, this.config.getGitSshCiphers(), this.config.getGitSshMACs());
        this.gitSSHService.start();
    }

    public <T> ReceivePack getReceivePack(final String protocol, final T req, final Repository db) {
        return new ReceivePack(db){
            {
                super(x0);
                JGitFileSystem fs = JGitFileSystemProvider.this.fsManager.get(db);
                HashMap oldTreeRefs = new HashMap();
                this.setPreReceiveHook((rp, commands2) -> {
                    fs.lock();
                    User user = JGitFileSystemProvider.this.extractUser(req);
                    for (ReceiveCommand command : commands2) {
                        fs.checkBranchAccess(command, user);
                        RevCommit lastCommit = fs.getGit().getLastCommit(command.getRefName());
                        oldTreeRefs.put(command.getRefName(), lastCommit);
                    }
                });
                this.setPostReceiveHook((rp, commands) -> {
                    fs.unlock();
                    fs.notifyExternalUpdate();
                    User user = JGitFileSystemProvider.this.extractUser(req);
                    for (Map.Entry oldTreeRef : oldTreeRefs.entrySet()) {
                        List<RevCommit> commits = fs.getGit().listCommits((ObjectId)oldTreeRef.getValue(), (ObjectId)fs.getGit().getLastCommit((String)oldTreeRef.getKey()));
                        for (RevCommit revCommit : commits) {
                            RevTree parent = revCommit.getParentCount() > 0 ? revCommit.getParent(0).getTree() : null;
                            JGitFileSystemProvider.this.notifyDiffs(fs, (String)oldTreeRef.getKey(), "<" + protocol + ">", user.getIdentifier(), revCommit.getFullMessage(), (ObjectId)parent, (ObjectId)revCommit.getTree());
                        }
                    }
                });
            }
        };
    }

    public <T> RepositoryResolverImpl<T> getRepositoryResolver() {
        return new RepositoryResolverImpl();
    }

    void buildAndStartDaemon() {
        if (this.daemonService == null || !this.daemonService.isRunning()) {
            this.daemonService = new Daemon(new InetSocketAddress(this.config.getDaemonHostAddr(), this.config.getDaemonPort()), new ExecutorWrapper(this.executorService), this.executorService, this.config.isEnableKetch() ? this.leaders : null);
            this.daemonService.setRepositoryResolver(new RepositoryResolverImpl<DaemonClient>());
            try {
                this.daemonService.start();
            }
            catch (java.io.IOException e) {
                throw new IOException((Exception)e);
            }
        }
    }

    private void shutdownSSH() {
        if (this.gitSSHService != null) {
            this.gitSSHService.stop();
        }
    }

    void forceStopDaemon() {
        if (this.daemonService != null && this.daemonService.isRunning()) {
            this.daemonService.stop();
        }
    }

    public void shutdown() {
        this.fsManager.getOpenFileSystems().forEach(Closeable::close);
        this.shutdownSSH();
        this.forceStopDaemon();
        this.fsManager.clear();
    }

    public File getGitRepoContainerDir() {
        return this.config.getGitReposParentDir();
    }

    public synchronized void forceAsDefault() {
        this.isDefault = true;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getScheme() {
        return "git";
    }

    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IllegalArgumentException, IOException, SecurityException, FileSystemAlreadyExistsException {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        PortablePreconditions.checkCondition((String)"uri scheme not supported", (uri.getScheme().equals(this.getScheme()) || uri.getScheme().equals("default") ? 1 : 0) != 0);
        this.checkURI("uri", uri);
        PortablePreconditions.checkNotNull((String)"env", env);
        String fsName = this.extractFSName(uri);
        this.validateFSName(uri, fsName);
        String envUsername = this.extractEnvProperty("username", env);
        String envPassword = this.extractEnvProperty("password", env);
        this.fsManager.newFileSystem(() -> this.fullHostNames, () -> this.createNewGitRepo(env, fsName), () -> fsName, () -> this.buildCredential(envUsername, envPassword), () -> this.fsEventsManager, () -> JGitFileSystemProvider.extractFSHooks(env));
        JGitFileSystem fs = this.fsManager.get(fsName);
        boolean init = false;
        if (env.containsKey("init") && Boolean.valueOf(env.get("init").toString()).booleanValue()) {
            init = true;
        }
        if (!env.containsKey("origin") && init) {
            try {
                URI initURI = URI.create(this.getScheme() + "://master@" + fsName + "/readme.md");
                OutputStream stream = this.newOutputStream(this.getPath(initURI), new OpenOption[]{null});
                String _init = "Repository Init Content\n=======================\n\nYour project description here.";
                stream.write("Repository Init Content\n=======================\n\nYour project description here.".getBytes());
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.info("Repository initialization may have failed.", (Throwable)e);
            }
        }
        if (this.config.isEnableKetch()) {
            this.createNewGitRepo(env, fsName).enableKetch();
        }
        if (this.config.isDaemonEnabled() && this.daemonService != null && !this.daemonService.isRunning()) {
            this.buildAndStartDaemon();
        }
        return fs;
    }

    static Map<FileSystemHooks, ?> extractFSHooks(Map<String, ?> env) {
        return Arrays.stream(FileSystemHooks.values()).filter(h -> env.get(h.name()) != null).collect(Collectors.toMap(Function.identity(), k -> env.get(k.name())));
    }

    private void validateFSName(URI uri, String fsName) {
        String fsNameRoot;
        if (this.fsManager.containsKey(fsName)) {
            throw new FileSystemAlreadyExistsException("There is already a FS for " + uri + ".");
        }
        if (fsName.contains("/") && this.fsManager.containsKey(fsNameRoot = fsName.substring(0, fsName.indexOf("/")))) {
            throw new AmbiguousFileSystemNameException("The file system name" + fsName + " is ambiguous with another FS registered");
        }
        if (this.fsManager.containsRoot(fsName)) {
            throw new AmbiguousFileSystemNameException("The file system name" + fsName + " is ambiguous with another FS registered");
        }
    }

    private String extractEnvProperty(String key, Map<String, ?> env) {
        if (env == null || env.get(key) == null) {
            return null;
        }
        return env.get(key).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Git createNewGitRepo(Map<String, ?> env, String fsName) {
        File repoDest = this.getRepoDest(env, fsName);
        File directory = repoDest.getParentFile();
        String lockName = directory.getName();
        if (!directory.exists()) {
            Files.createDirectory((Path)Paths.get((URI)directory.toURI()), (FileAttribute[])new FileAttribute[0]);
        }
        FileSystemLock physicalLock = this.createLock(directory, lockName);
        try {
            physicalLock.lock();
            Git git = this.createNewGitRepo(env, fsName, repoDest);
            return git;
        }
        finally {
            physicalLock.unlock();
        }
    }

    protected Git createNewGitRepo(Map<String, ?> env, String fsName, File repoDest) {
        Git git;
        String envUsername = this.extractEnvProperty("username", env);
        String envPassword = this.extractEnvProperty("password", env);
        Boolean envMirror = (Boolean)env.get("mirror");
        boolean isMirror = envMirror == null ? true : envMirror;
        CredentialsProvider credential = this.buildCredential(envUsername, envPassword);
        if (this.syncWithRemote(env, repoDest)) {
            String origin = env.get("origin").toString();
            List branches = (List)env.get("branches");
            String subdirectory = (String)env.get("subdirectory");
            try {
                if (this.isForkOrigin(origin)) {
                    git = Git.fork(this.getGitRepoContainerDir(), origin, fsName, branches, credential, this.config.isEnableKetch() ? this.leaders : null, this.config.getHookDir(), this.config.isSslVerify());
                }
                if (subdirectory != null) {
                    if (isMirror) {
                        throw new UnsupportedOperationException("Cannot make mirror repository when cloning subdirectory.");
                    }
                    git = Git.cloneSubdirectory(repoDest, origin, subdirectory, branches, credential, this.leaders, this.config.getHookDir(), this.config.isSslVerify());
                }
                git = Git.clone(repoDest, origin, isMirror, branches, credential, this.config.isEnableKetch() ? this.leaders : null, this.config.getHookDir(), this.config.isSslVerify());
            }
            catch (Clone.CloneException ce) {
                this.fsManager.remove(fsName);
                throw new RuntimeException(ce);
            }
        } else {
            git = Git.createRepository(repoDest, this.config.getHookDir(), this.config.isEnableKetch() ? this.leaders : null, this.config.isSslVerify());
        }
        return git;
    }

    private FileSystemLock createLock(File directory, String lockName) {
        return FileSystemLockManager.getInstance().getFileSystemLock(directory, lockName + ".lock", LOCK_LAST_ACCESS_TIME_UNIT, 10L);
    }

    private File getRepoDest(Map<String, ?> env, String fsName) {
        String outPath = (String)env.get("out-dir");
        File repoDest = outPath != null ? new File(outPath, fsName + ".git") : new File(this.config.getGitReposParentDir(), fsName + ".git");
        return repoDest;
    }

    private boolean syncWithRemote(Map<String, ?> env, File repoDest) {
        return env.containsKey("origin") && !repoDest.exists();
    }

    String extractFSName(URI _uri) {
        String uri = _uri.toString().replace("git://", "").replace("default://", "");
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (uri.contains("@")) {
            uri = uri.substring(uri.indexOf(64) + 1);
        }
        if (uri.contains(":")) {
            uri = uri.substring(0, uri.indexOf(58) - 1);
        }
        return uri;
    }

    private boolean isForkOrigin(String originURI) {
        return originURI.matches("(^\\w+\\/\\w+$)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        PortablePreconditions.checkCondition((String)"uri scheme not supported", (uri.getScheme().equals(this.getScheme()) || uri.getScheme().equals("default") ? 1 : 0) != 0);
        this.checkURI("uri", uri);
        JGitFileSystem fileSystem = this.deepLookupFSFrom(uri);
        if (this.hasSyncFlag(uri)) {
            try {
                String treeRef = "master";
                ObjectId oldHead = fileSystem.getGit().getTreeFromRef("master");
                Map<String, String> params = JGitFileSystemProvider.getQueryParams(uri);
                try {
                    fileSystem.lock();
                    Pair remote = Pair.newPair((Object)"upstream", (Object)params.get("sync"));
                    fileSystem.getGit().fetch(fileSystem.getCredential(), (Pair<String, String>)remote, Collections.emptyList());
                    fileSystem.getGit().syncRemote((Pair<String, String>)remote);
                }
                finally {
                    fileSystem.unlock();
                }
                ObjectId newHead = fileSystem.getGit().getTreeFromRef("master");
                this.notifyDiffs(fileSystem, "master", "<system>", "<system>", "", oldHead, newHead);
            }
            catch (Exception ex) {
                throw new IOException("Failed to sync repository.", ex);
            }
        }
        if (this.hasPushFlag(uri)) {
            try {
                Map<String, String> params = JGitFileSystemProvider.getQueryParams(uri);
                fileSystem.getGit().push(fileSystem.getCredential(), (Pair<String, String>)Pair.newPair((Object)"usptream", (Object)params.get("push")), this.hasForceFlag(uri), Collections.emptyList());
            }
            catch (Exception ex) {
                throw new IOException("Failed to push repository.", ex);
            }
        }
        return fileSystem;
    }

    String extractFSNameWithPath(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        String path = uri.getAuthority() + uri.getPath();
        int index = path.indexOf(64);
        if (index != -1) {
            path = path.substring(index + 1);
        }
        return path;
    }

    public Path getPath(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        PortablePreconditions.checkCondition((String)"uri scheme not supported", (uri.getScheme().equals(this.getScheme()) || uri.getScheme().equals("default") ? 1 : 0) != 0);
        this.checkURI("uri", uri);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Accessing uri " + uri.toString());
        }
        JGitFileSystem fileSystem = this.deepLookupFSFrom(uri);
        String branch = this.extractBranchFrom(uri);
        String host = this.buildHostFrom(fileSystem, branch);
        String pathStr = this.buildPathFrom(uri, host);
        JGitPathImpl path = JGitPathImpl.create(fileSystem, pathStr, host, false);
        return path;
    }

    private String buildPathFrom(URI uri, String host) {
        String pathStr = uri.toString();
        pathStr = pathStr.replace(host, "");
        pathStr = pathStr.replace("git://", "").replace("default://", "");
        if ((pathStr = EncodingUtil.decode((String)pathStr)).startsWith("/:")) {
            pathStr = pathStr.substring(2);
        }
        return pathStr;
    }

    private String buildHostFrom(JGitFileSystem fileSystem, String branch) {
        String host = branch + fileSystem.getName();
        host = host.replace("git://", "").replace("default://", "");
        return host;
    }

    private String extractBranchFrom(URI uri) {
        String branch = "";
        int index = uri.toString().indexOf(64);
        if (index != -1) {
            branch = uri.toString().substring(0, index + 1);
        }
        return branch;
    }

    public String extractPath(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        return this.getPath(uri).toString();
    }

    private JGitFileSystem deepLookupFSFrom(URI uri) {
        String fullURI = this.extractFSNameWithPath(uri);
        int index = fullURI.indexOf("/");
        JGitFileSystem jGitFileSystem = this.fsManager.get(fullURI);
        while (jGitFileSystem == null && index >= 0) {
            String fsCandidate = fullURI.substring(0, index);
            jGitFileSystem = this.fsManager.get(fsCandidate);
            index = fullURI.indexOf("/", index + 1);
        }
        if (jGitFileSystem == null) {
            throw new FileSystemNotFoundException("No filesystem for uri (" + uri + ") found.");
        }
        return jGitFileSystem;
    }

    public InputStream newInputStream(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        return ((JGitFileSystem)gPath.getFileSystem()).getGit().blobAsInputStream(gPath.getRefTree(), gPath.getPath());
    }

    public OutputStream newOutputStream(final Path path, final OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        final JGitPathImpl gPath = this.toPathImpl(path);
        PathInfo result = ((JGitFileSystem)gPath.getFileSystem()).getGit().getPathInfo(gPath.getRefTree(), gPath.getPath());
        if (result.getPathType().equals((Object)PathType.DIRECTORY)) {
            throw new NotDirectoryException(path.toString());
        }
        try {
            final File file = File.createTempFile("gitz", "woot");
            return new FilterOutputStream(new FileOutputStream(file)){

                @Override
                public void close() throws java.io.IOException {
                    super.close();
                    JGitFileSystemProvider.this.commit(gPath, JGitFileSystemProvider.this.buildCommitInfo("{" + JGitFileSystemProvider.this.toPathImpl(path).getPath() + "}", Arrays.asList(options)), new DefaultCommitContent((Map<String, File>)new HashMap<String, File>(){
                        {
                            this.put(gPath.getPath(), file);
                        }
                    }));
                }
            };
        }
        catch (java.io.IOException e) {
            throw new IOException("Could not create file or output stream.", (Exception)e);
        }
    }

    private CommitInfo buildCommitInfo(String defaultMessage, Collection<? extends Option> options) {
        CommentedOption op;
        String sessionId = null;
        String name = null;
        String email = null;
        String message = defaultMessage;
        TimeZone timeZone = null;
        Date when = null;
        if (options != null && !options.isEmpty() && (op = this.extractCommentedOption(options)) != null) {
            sessionId = op.getSessionId();
            name = op.getName();
            email = op.getEmail();
            if (op.getMessage() != null && !op.getMessage().trim().isEmpty()) {
                message = op.getMessage() + " " + defaultMessage;
            }
            timeZone = op.getTimeZone();
            when = op.getWhen();
        }
        return new CommitInfo(sessionId, name, email, message, timeZone, when);
    }

    private CommentedOption extractCommentedOption(Collection<? extends Option> options) {
        for (Option option : options) {
            if (!(option instanceof CommentedOption)) continue;
            return (CommentedOption)option;
        }
        return null;
    }

    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        JGitPathImpl gPath = this.toPathImpl(path);
        if (this.exists(path) && !this.shouldCreateOrOpenAByteChannel(options)) {
            throw new FileAlreadyExistsException(path.toString());
        }
        PathInfo result = ((JGitFileSystem)gPath.getFileSystem()).getGit().getPathInfo(gPath.getRefTree(), gPath.getPath());
        if (result.getPathType().equals((Object)PathType.DIRECTORY)) {
            throw new NotDirectoryException(path.toString());
        }
        try {
            if (options != null && options.contains(StandardOpenOption.READ)) {
                SeekableByteChannelFileBasedImpl seekableByteChannelFileBasedImpl = this.openAByteChannel(path);
                return seekableByteChannelFileBasedImpl;
            }
            SeekableByteChannel seekableByteChannel = this.createANewByteChannel(path, options, gPath, attrs);
            return seekableByteChannel;
        }
        catch (java.io.IOException e) {
            throw new IOException("Failed to open or create a byte channel.", (Exception)e);
        }
        finally {
            ((AbstractPath)path).clearCache();
        }
    }

    private SeekableByteChannel createANewByteChannel(final Path path, final Set<? extends OpenOption> options, final JGitPathImpl gPath, final FileAttribute<?>[] attrs) throws java.io.IOException {
        final File file = File.createTempFile("gitz", "woot");
        return new SeekableByteChannelFileBasedImpl(new RandomAccessFile(file, "rw").getChannel()){

            public void close() throws java.io.IOException {
                boolean hasDotContent;
                super.close();
                File tempDot = null;
                if (options != null && options.contains(new DotFileOption())) {
                    JGitFileSystemProvider.this.deleteIfExists(DotFileUtils.dot((Path)path), new DeleteOption[]{JGitFileSystemProvider.this.extractCommentedOption(options)});
                    tempDot = File.createTempFile("meta", "dot");
                    hasDotContent = DotFileUtils.buildDotFile((Path)path, (OutputStream)new FileOutputStream(tempDot), (FileAttribute[])attrs);
                } else {
                    hasDotContent = false;
                }
                final File dotfile = tempDot;
                JGitFileSystemProvider.this.commit(gPath, JGitFileSystemProvider.this.buildCommitInfo("{" + JGitFileSystemProvider.this.toPathImpl(path).getPath() + "}", options), new DefaultCommitContent((Map<String, File>)new HashMap<String, File>(){
                    {
                        this.put(gPath.getPath(), file);
                        if (hasDotContent) {
                            this.put(JGitFileSystemProvider.this.toPathImpl(DotFileUtils.dot((Path)gPath)).getPath(), dotfile);
                        }
                    }
                }));
            }
        };
    }

    private SeekableByteChannelFileBasedImpl openAByteChannel(Path path) throws FileNotFoundException {
        return new SeekableByteChannelFileBasedImpl(new RandomAccessFile(path.toFile(), "r").getChannel());
    }

    private boolean shouldCreateOrOpenAByteChannel(Set<? extends OpenOption> options) {
        return options != null && (options.contains(StandardOpenOption.TRUNCATE_EXISTING) || options.contains(StandardOpenOption.READ));
    }

    protected boolean exists(Path path) {
        try {
            this.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<Path> pfilter) throws IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        final DirectoryStream.Filter<Path> filter = pfilter == null ? entry -> true : pfilter;
        final JGitPathImpl gPath = this.toPathImpl(path);
        PathInfo result = ((JGitFileSystem)gPath.getFileSystem()).getGit().getPathInfo(gPath.getRefTree(), gPath.getPath());
        if (!result.getPathType().equals((Object)PathType.DIRECTORY)) {
            throw new NotDirectoryException(path.toString());
        }
        final List<PathInfo> pathContent = ((JGitFileSystem)gPath.getFileSystem()).getGit().listPathContent(gPath.getRefTree(), gPath.getPath());
        return new DirectoryStream<Path>(){
            boolean isClosed = false;

            public void close() throws IOException {
                if (this.isClosed) {
                    throw new IOException("This stream is closed.");
                }
                this.isClosed = true;
            }

            public Iterator<Path> iterator() {
                if (this.isClosed) {
                    throw new IOException("This stream is closed.");
                }
                return new Iterator<Path>(){
                    int i = -1;
                    Path nextEntry = null;
                    boolean atEof = false;

                    @Override
                    public boolean hasNext() {
                        if (this.nextEntry == null && !this.atEof) {
                            this.nextEntry = this.readNextEntry();
                        }
                        return this.nextEntry != null;
                    }

                    @Override
                    public Path next() {
                        Path result;
                        if (this.nextEntry == null && !this.atEof) {
                            result = this.readNextEntry();
                        } else {
                            result = this.nextEntry;
                            this.nextEntry = null;
                        }
                        if (result == null) {
                            throw new NoSuchElementException();
                        }
                        return result;
                    }

                    private Path readNextEntry() {
                        JGitPathImpl result;
                        block3: {
                            PathInfo content;
                            JGitPathImpl path;
                            if (this.atEof) {
                                return null;
                            }
                            result = null;
                            do {
                                ++this.i;
                                if (this.i >= pathContent.size()) {
                                    this.atEof = true;
                                    break block3;
                                }
                                content = (PathInfo)pathContent.get(this.i);
                            } while (!filter.accept((Object)(path = JGitPathImpl.create((JGitFileSystem)gPath.getFileSystem(), "/" + content.getPath(), gPath.getHost(), content.getObjectId(), gPath.isRealPath()))));
                            result = path;
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void createDirectory(Path path, FileAttribute<?> ... attrs) throws UnsupportedOperationException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        PathInfo result = ((JGitFileSystem)gPath.getFileSystem()).getGit().getPathInfo(gPath.getRefTree(), gPath.getPath());
        if (!result.getPathType().equals((Object)PathType.NOT_FOUND)) {
            throw new FileAlreadyExistsException(path.toString());
        }
        try {
            OutputStream outputStream = this.newOutputStream(path.resolve(".gitkeep"), new OpenOption[0]);
            outputStream.close();
        }
        catch (Exception e) {
            throw new IOException("Failed to write to or close the output stream.", e);
        }
    }

    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public void createLink(Path link, Path existing) throws UnsupportedOperationException, IOException, SecurityException {
        throw new UnsupportedOperationException();
    }

    public void delete(Path path, DeleteOption ... options) throws IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        if (path instanceof JGitFSPath) {
            this.deleteFS(path.getFileSystem());
            return;
        }
        JGitPathImpl gPath = this.toPathImpl(path);
        if (this.isBranch(gPath)) {
            this.deleteBranch(gPath);
            return;
        }
        this.deleteAsset(gPath, options);
    }

    protected boolean deleteFS(FileSystem fileSystem) {
        File gitDir = ((JGitFileSystemImpl)fileSystem).getGit().getRepository().getDirectory();
        File parentDir = gitDir.getParentFile();
        FileSystemLock physicalLock = this.createLock(parentDir, parentDir.getName());
        try {
            physicalLock.lock();
            fileSystem.close();
            fileSystem.dispose();
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                WindowCache.reconfigure((WindowCacheConfig)new WindowCacheConfig());
            }
            this.fsManager.remove(fileSystem.getName());
            FileUtils.delete((File)gitDir, (int)7);
            this.cleanupParentDir(gitDir);
            boolean bl = true;
            return bl;
        }
        catch (java.io.IOException e) {
            throw new IOException("Failed to remove the git repository.", (Exception)e);
        }
        finally {
            physicalLock.unlock();
        }
    }

    private void cleanupParentDir(File gitDir) throws java.io.IOException {
        File parentDir = gitDir.getParentFile();
        if (parentDir.isDirectory() && this.parentDirIsEmpty(parentDir) && !parentDir.equals(this.getGitRepoContainerDir())) {
            FileUtils.delete((File)parentDir, (int)3);
        }
    }

    private boolean parentDirIsEmpty(File parentDir) {
        return parentDir.list().length == 0;
    }

    public void deleteAsset(JGitPathImpl path, DeleteOption ... options) {
        PathInfo result = ((JGitFileSystem)path.getFileSystem()).getGit().getPathInfo(path.getRefTree(), path.getPath());
        if (result.getPathType().equals((Object)PathType.DIRECTORY)) {
            if (this.deleteNonEmptyDirectory(options)) {
                this.deleteResource(path, options);
                return;
            }
            List<PathInfo> content = ((JGitFileSystem)path.getFileSystem()).getGit().listPathContent(path.getRefTree(), path.getPath());
            if (content.size() == 1 && content.get(0).getPath().equals(path.getPath().substring(1) + "/.gitkeep")) {
                this.delete(path.resolve(".gitkeep"), new DeleteOption[0]);
                this.deleteResource(path, options);
                return;
            }
            throw new DirectoryNotEmptyException(path.toString());
        }
        if (result.getPathType().equals((Object)PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
        this.deleteResource(path, options);
    }

    private void deleteResource(JGitPathImpl path, DeleteOption ... options) {
        this.delete(path, this.buildCommitInfo("delete {" + path.getPath() + "}", Arrays.asList(options)));
    }

    private boolean deleteNonEmptyDirectory(DeleteOption ... options) {
        for (DeleteOption option : options) {
            if (!option.equals(StandardDeleteOption.NON_EMPTY_DIRECTORIES)) continue;
            return true;
        }
        return false;
    }

    public void deleteBranch(JGitPathImpl path) {
        Ref branch = ((JGitFileSystem)path.getFileSystem()).getGit().getRef(path.getRefTree());
        if (branch == null) {
            throw new NoSuchFileException(path.toString());
        }
        try {
            ((JGitFileSystem)path.getFileSystem()).lock();
            ((JGitFileSystem)path.getFileSystem()).getGit().deleteRef(branch);
        }
        finally {
            ((JGitFileSystem)path.getFileSystem()).unlock();
        }
    }

    public boolean deleteIfExists(Path path, DeleteOption ... options) throws IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        if (path instanceof JGitFSPath) {
            return this.deleteFS(path.getFileSystem());
        }
        JGitPathImpl gPath = this.toPathImpl(path);
        if (this.isBranch(gPath)) {
            return this.deleteBranchIfExists(gPath);
        }
        return this.deleteAssetIfExists(gPath, options);
    }

    public boolean deleteBranchIfExists(JGitPathImpl path) {
        try {
            this.deleteBranch(path);
            return true;
        }
        catch (NoSuchFileException ignored) {
            return false;
        }
    }

    public boolean deleteAssetIfExists(JGitPathImpl path, DeleteOption ... options) {
        PathInfo result = ((JGitFileSystem)path.getFileSystem()).getGit().getPathInfo(path.getRefTree(), path.getPath());
        if (result.getPathType().equals((Object)PathType.DIRECTORY)) {
            if (this.deleteNonEmptyDirectory(options)) {
                this.deleteResource(path, options);
                return true;
            }
            List<PathInfo> content = ((JGitFileSystem)path.getFileSystem()).getGit().listPathContent(path.getRefTree(), path.getPath());
            if (content.size() == 1 && content.get(0).getPath().equals(path.getPath().substring(1) + "/.gitkeep")) {
                this.delete(path.resolve(".gitkeep"), new DeleteOption[0]);
                return true;
            }
            throw new DirectoryNotEmptyException(path.toString());
        }
        if (result.getPathType().equals((Object)PathType.NOT_FOUND)) {
            return false;
        }
        this.deleteResource(path, options);
        return true;
    }

    public Path readSymbolicLink(Path link) throws UnsupportedOperationException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"link", (Object)link);
        throw new UnsupportedOperationException();
    }

    public void copy(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, IOException, SecurityException {
        boolean isBranch;
        PortablePreconditions.checkNotNull((String)"source", (Object)source);
        PortablePreconditions.checkNotNull((String)"target", (Object)target);
        JGitPathImpl gSource = this.toPathImpl(source);
        JGitPathImpl gTarget = this.toPathImpl(target);
        boolean bl = isBranch = this.isBranch(gSource) && this.isBranch(gTarget);
        if (options.length == 1 && options[0] instanceof MergeCopyOption) {
            if (!isBranch) {
                throw new IOException("Merge needs source and target as root.");
            }
            this.merge(gSource, gTarget);
        } else if (options.length == 1 && options[0] instanceof CherryPickCopyOption) {
            if (!isBranch) {
                throw new IOException("Cherry pick needs source and target as root.");
            }
            String[] commits = ((CherryPickCopyOption)options[0]).getCommits();
            if (commits == null || commits.length == 0) {
                throw new IOException("Cherry pick needs at least one commit id.");
            }
            this.cherryPick(gSource, gTarget, commits);
        } else {
            if (isBranch) {
                this.copyBranch(gSource, gTarget);
                return;
            }
            this.copyAsset(gSource, gTarget, options);
        }
    }

    private void merge(JGitPathImpl source, JGitPathImpl target) {
        try {
            ((JGitFileSystem)target.getFileSystem()).lock();
            ((JGitFileSystem)source.getFileSystem()).getGit().merge(source.getRefTree(), target.getRefTree());
        }
        finally {
            ((JGitFileSystem)target.getFileSystem()).unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cherryPick(JGitPathImpl source, JGitPathImpl target, String ... commits) {
        try {
            ((JGitFileSystem)target.getFileSystem()).lock();
            ((JGitFileSystem)source.getFileSystem()).getGit().cherryPick(target, commits);
        }
        finally {
            ((JGitFileSystem)target.getFileSystem()).unlock();
        }
    }

    private void copyBranch(JGitPathImpl source, JGitPathImpl target) {
        PortablePreconditions.checkCondition((String)"source and target should have same file system", (boolean)this.hasSameFileSystem(source, target));
        if (this.existsBranch(target)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (!this.existsBranch(source)) {
            throw new NoSuchFileException(target.toString());
        }
        this.createBranch(source, target);
    }

    private void copyAsset(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        PathInfo sourceResult = ((JGitFileSystem)source.getFileSystem()).getGit().getPathInfo(source.getRefTree(), source.getPath());
        PathInfo targetResult = ((JGitFileSystem)target.getFileSystem()).getGit().getPathInfo(target.getRefTree(), target.getPath());
        if (!this.isRoot(target) && targetResult.getPathType() != PathType.NOT_FOUND && !this.contains(options, (CopyOption)StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (sourceResult.getPathType() == PathType.NOT_FOUND) {
            throw new NoSuchFileException(target.toString());
        }
        if (!source.getRefTree().equals(target.getRefTree())) {
            this.copyAssetContent(source, target, options);
        } else if (!((JGitFileSystem)source.getFileSystem()).equals(target.getFileSystem())) {
            this.copyAssetContent(source, target, options);
        } else {
            HashMap<JGitPathImpl, JGitPathImpl> sourceDest = new HashMap<JGitPathImpl, JGitPathImpl>();
            if (sourceResult.getPathType() == PathType.DIRECTORY) {
                sourceDest.putAll(this.mapDirectoryContent(source, target, options));
            } else {
                sourceDest.put(source, target);
            }
            this.copyFiles(source, target, sourceDest, options);
        }
    }

    private void copyAssetContent(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        PathInfo sourceResult = ((JGitFileSystem)source.getFileSystem()).getGit().getPathInfo(source.getRefTree(), source.getPath());
        PathInfo targetResult = ((JGitFileSystem)target.getFileSystem()).getGit().getPathInfo(target.getRefTree(), target.getPath());
        if (!this.isRoot(target) && targetResult.getPathType() != PathType.NOT_FOUND && !this.contains(options, (CopyOption)StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (sourceResult.getPathType() == PathType.NOT_FOUND) {
            throw new NoSuchFileException(target.toString());
        }
        if (sourceResult.getPathType() == PathType.DIRECTORY) {
            this.copyDirectory(source, target, options);
            return;
        }
        this.copyFile(source, target, options);
    }

    private boolean contains(CopyOption[] options, CopyOption opt) {
        for (CopyOption option : options) {
            if (!option.equals(opt)) continue;
            return true;
        }
        return false;
    }

    private void copyDirectory(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        ArrayList<JGitPathImpl> directories = new ArrayList<JGitPathImpl>();
        for (Path path : this.newDirectoryStream((Path)source, null)) {
            JGitPathImpl gPath = this.toPathImpl(path);
            PathInfo pathResult = ((JGitFileSystem)gPath.getFileSystem()).getGit().getPathInfo(gPath.getRefTree(), gPath.getPath());
            if (pathResult.getPathType() == PathType.DIRECTORY) {
                directories.add(gPath);
                continue;
            }
            JGitPathImpl gTarget = this.composePath(target, (JGitPathImpl)gPath.getFileName(), new CopyOption[0]);
            this.copyFile(gPath, gTarget, new CopyOption[0]);
        }
        for (JGitPathImpl directory : directories) {
            this.createDirectory((Path)this.composePath(target, (JGitPathImpl)directory.getFileName(), new CopyOption[0]), new FileAttribute[0]);
        }
    }

    private JGitPathImpl composePath(JGitPathImpl directory, JGitPathImpl fileName, CopyOption ... options) {
        if (directory.getPath().endsWith("/")) {
            return this.toPathImpl(this.getPath(URI.create(directory.toUri().toString() + this.uriEncode(fileName.toString(false)))));
        }
        return this.toPathImpl(this.getPath(URI.create(directory.toUri().toString() + "/" + this.uriEncode(fileName.toString(false)))));
    }

    private String uriEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(JGitPathImpl source, JGitPathImpl target, final CopyOption ... options) {
        InputStream in = this.newInputStream((Path)source, this.convert(options));
        SeekableByteChannel out = this.newByteChannel((Path)target, (Set<? extends OpenOption>)new HashSet<OpenOption>(){
            {
                this.add(StandardOpenOption.TRUNCATE_EXISTING);
                for (CopyOption _option : options) {
                    if (!(_option instanceof OpenOption)) continue;
                    this.add((OpenOption)_option);
                }
            }
        }, new FileAttribute[0]);
        try {
            int count;
            byte[] buffer = new byte[8192];
            while ((count = in.read(buffer)) > 0) {
                out.write(ByteBuffer.wrap(buffer, 0, count));
            }
            return;
        }
        catch (Exception e) {
            throw new IOException("Failed to copy file from '" + (Object)((Object)source) + "' to '" + (Object)((Object)target) + "'", e);
        }
        finally {
            try {
                out.close();
            }
            catch (java.io.IOException e) {
                throw new IOException("Could not close output stream.", (Exception)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (java.io.IOException e) {
                    throw new IOException("Could not close input stream.", (Exception)e);
                }
            }
        }
    }

    private OpenOption[] convert(CopyOption ... options) {
        if (options == null || options.length == 0) {
            return new OpenOption[0];
        }
        ArrayList<OpenOption> newOptions = new ArrayList<OpenOption>(options.length);
        for (CopyOption option : options) {
            if (!(option instanceof OpenOption)) continue;
            newOptions.add((OpenOption)option);
        }
        return newOptions.toArray(new OpenOption[newOptions.size()]);
    }

    private void createBranch(JGitPathImpl source, JGitPathImpl target) {
        try {
            ((JGitFileSystem)target.getFileSystem()).lock();
            ((JGitFileSystem)source.getFileSystem()).getGit().createRef(source.getRefTree(), target.getRefTree());
        }
        finally {
            ((JGitFileSystem)target.getFileSystem()).unlock();
        }
    }

    private boolean existsBranch(JGitPathImpl path) {
        return ((JGitFileSystem)path.getFileSystem()).getGit().getRef(path.getRefTree()) != null;
    }

    private boolean isBranch(JGitPathImpl path) {
        return path.getPath().length() == 1 && path.getPath().equals("/");
    }

    private boolean isRoot(JGitPathImpl path) {
        return this.isBranch(path);
    }

    private boolean hasSameFileSystem(JGitPathImpl source, JGitPathImpl target) {
        return ((JGitFileSystem)source.getFileSystem()).equals(target.getFileSystem());
    }

    public void move(Path source, Path target, CopyOption ... options) throws DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"source", (Object)source);
        PortablePreconditions.checkNotNull((String)"target", (Object)target);
        JGitPathImpl gSource = this.toPathImpl(source);
        JGitPathImpl gTarget = this.toPathImpl(target);
        boolean isSourceBranch = this.isBranch(gSource);
        boolean isTargetBranch = this.isBranch(gTarget);
        if (isSourceBranch && isTargetBranch) {
            this.moveBranch(gSource, gTarget, options);
            return;
        }
        this.moveAsset(gSource, gTarget, options);
    }

    private void moveBranch(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        PortablePreconditions.checkCondition((String)"source and target should have same file system", (boolean)this.hasSameFileSystem(source, target));
        if (!this.exists((Path)source)) {
            throw new NoSuchFileException(target.toString());
        }
        boolean targetExists = this.existsBranch(target);
        if (targetExists && !this.contains(options, (CopyOption)StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (!targetExists) {
            this.createBranch(source, target);
            this.deleteBranch(source);
        } else {
            this.commit(target, this.buildCommitInfo("reverting from {" + source.getPath() + "}", Arrays.asList(options)), new RevertCommitContent(source.getRefTree()));
        }
    }

    private void moveAsset(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        PathInfo sourceResult = ((JGitFileSystem)source.getFileSystem()).getGit().getPathInfo(source.getRefTree(), source.getPath());
        PathInfo targetResult = ((JGitFileSystem)target.getFileSystem()).getGit().getPathInfo(target.getRefTree(), target.getPath());
        if (!this.isRoot(target) && targetResult.getPathType() != PathType.NOT_FOUND && !this.contains(options, (CopyOption)StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (sourceResult.getPathType() == PathType.NOT_FOUND) {
            throw new NoSuchFileException(target.toString());
        }
        if (!source.getRefTree().equals(target.getRefTree())) {
            this.copy((Path)source, (Path)target, options);
            this.delete((Path)source, new DeleteOption[0]);
        } else {
            HashMap<JGitPathImpl, JGitPathImpl> fromTo = new HashMap<JGitPathImpl, JGitPathImpl>();
            if (sourceResult.getPathType() == PathType.DIRECTORY) {
                fromTo.putAll(this.mapDirectoryContent(source, target, options));
            } else {
                fromTo.put(source, target);
            }
            this.moveFiles(source, target, fromTo, options);
        }
    }

    private Map<JGitPathImpl, JGitPathImpl> mapDirectoryContent(JGitPathImpl source, JGitPathImpl target, CopyOption ... options) {
        HashMap<JGitPathImpl, JGitPathImpl> fromTo = new HashMap<JGitPathImpl, JGitPathImpl>();
        for (Path path : this.newDirectoryStream((Path)source, null)) {
            JGitPathImpl gPath = this.toPathImpl(path);
            PathInfo pathResult = ((JGitFileSystem)gPath.getFileSystem()).getGit().getPathInfo(gPath.getRefTree(), gPath.getPath());
            if (pathResult.getPathType() == PathType.DIRECTORY) {
                fromTo.putAll(this.mapDirectoryContent(gPath, this.composePath(target, (JGitPathImpl)gPath.getFileName(), new CopyOption[0]), new CopyOption[0]));
                continue;
            }
            JGitPathImpl gTarget = this.composePath(target, (JGitPathImpl)gPath.getFileName(), new CopyOption[0]);
            fromTo.put(gPath, gTarget);
        }
        return fromTo;
    }

    private void moveFiles(JGitPathImpl source, JGitPathImpl target, Map<JGitPathImpl, JGitPathImpl> fromTo, CopyOption ... options) {
        HashMap<String, String> result = new HashMap<String, String>(fromTo.size());
        for (Map.Entry<JGitPathImpl, JGitPathImpl> fromToEntry : fromTo.entrySet()) {
            result.put(PathUtil.normalize(fromToEntry.getKey().getPath()), PathUtil.normalize(fromToEntry.getValue().getPath()));
        }
        this.commit(source, this.buildCommitInfo("moving from {" + source.getPath() + "} to {" + target.getPath() + "}", Arrays.asList(options)), new MoveCommitContent(result));
    }

    private void copyFiles(JGitPathImpl source, JGitPathImpl target, Map<JGitPathImpl, JGitPathImpl> sourceDest, CopyOption ... options) {
        HashMap<String, String> result = new HashMap<String, String>(sourceDest.size());
        for (Map.Entry<JGitPathImpl, JGitPathImpl> sourceDestEntry : sourceDest.entrySet()) {
            result.put(PathUtil.normalize(sourceDestEntry.getKey().getPath()), PathUtil.normalize(sourceDestEntry.getValue().getPath()));
        }
        this.commit(source, this.buildCommitInfo("copy from {" + source.getPath() + "} to {" + target.getPath() + "}", Arrays.asList(options)), new CopyCommitContent(result));
    }

    public boolean isSameFile(Path pathA, Path pathB) throws IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"pathA", (Object)pathA);
        PortablePreconditions.checkNotNull((String)"pathB", (Object)pathB);
        JGitPathImpl gPathA = this.toPathImpl(pathA);
        JGitPathImpl gPathB = this.toPathImpl(pathB);
        PathInfo resultA = ((JGitFileSystem)gPathA.getFileSystem()).getGit().getPathInfo(gPathA.getRefTree(), gPathA.getPath());
        PathInfo resultB = ((JGitFileSystem)gPathB.getFileSystem()).getGit().getPathInfo(gPathB.getRefTree(), gPathB.getPath());
        if (resultA.getPathType() == PathType.FILE && resultA.getObjectId().equals((AnyObjectId)resultB.getObjectId())) {
            return true;
        }
        return pathA.equals(pathB);
    }

    public boolean isHidden(Path path) throws IllegalArgumentException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        if (gPath.getFileName() == null) {
            return false;
        }
        return this.toPathImpl(path.getFileName()).toString(false).startsWith(".");
    }

    public FileStore getFileStore(Path path) throws IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return new JGitFileStore(((JGitFileSystem)this.toPathImpl(path).getFileSystem()).getGit().getRepository());
    }

    public void checkAccess(Path path, AccessMode ... modes) throws UnsupportedOperationException, NoSuchFileException, AccessDeniedException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        JGitPathImpl gPath = this.toPathImpl(path);
        PathInfo result = ((JGitFileSystem)gPath.getFileSystem()).getGit().getPathInfo(gPath.getRefTree(), gPath.getPath());
        if (result.getPathType().equals((Object)PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
    }

    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) throws NoSuchFileException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotNull((String)"type", type);
        JGitPathImpl gPath = this.toPathImpl(path);
        PathInfo pathResult = ((JGitFileSystem)gPath.getFileSystem()).getGit().getPathInfo(gPath.getRefTree(), gPath.getPath());
        if (pathResult.getPathType().equals((Object)PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
        FileAttributeView resultView = (FileAttributeView)gPath.getAttrView(type);
        if (resultView == null) {
            if (type == BasicFileAttributeView.class || type == JGitBasicAttributeView.class) {
                JGitBasicAttributeView newView = new JGitBasicAttributeView(gPath);
                gPath.addAttrView((AttributeView)newView);
                return (V)((Object)newView);
            }
            if (type == HiddenAttributeView.class || type == JGitHiddenAttributeView.class) {
                JGitHiddenAttributeView newView = new JGitHiddenAttributeView(gPath);
                gPath.addAttrView((AttributeView)newView);
                return (V)((Object)newView);
            }
            if (type == VersionAttributeView.class || type == JGitVersionAttributeView.class) {
                JGitVersionAttributeView newView = new JGitVersionAttributeView(gPath);
                gPath.addAttrView((AttributeView)newView);
                return (V)((Object)newView);
            }
        }
        return (V)resultView;
    }

    private ExtendedAttributeView getFileAttributeView(JGitPathImpl path, String name, LinkOption ... options) {
        ExtendedAttributeView view = (ExtendedAttributeView)path.getAttrView(name);
        if (view == null) {
            if (name.equals("basic")) {
                JGitBasicAttributeView newView = new JGitBasicAttributeView(path);
                path.addAttrView((AttributeView)newView);
                return newView;
            }
            if (name.equals("extended")) {
                JGitHiddenAttributeView newView = new JGitHiddenAttributeView(path);
                path.addAttrView((AttributeView)newView);
                return newView;
            }
            if (name.equals("version")) {
                JGitVersionAttributeView newView = new JGitVersionAttributeView(path);
                path.addAttrView((AttributeView)newView);
                return newView;
            }
        }
        return view;
    }

    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws NoSuchFileException, UnsupportedOperationException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotNull((String)"type", type);
        JGitPathImpl gPath = this.toPathImpl(path);
        PathInfo pathResult = ((JGitFileSystem)gPath.getFileSystem()).getGit().getPathInfo(gPath.getRefTree(), gPath.getPath());
        if (pathResult.getPathType().equals((Object)PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path.toString());
        }
        if (type == VersionAttributes.class) {
            JGitVersionAttributeView view = this.getFileAttributeView(path, JGitVersionAttributeView.class, options);
            return (A)view.readAttributes();
        }
        if (type == HiddenAttributes.class) {
            JGitHiddenAttributeView view = this.getFileAttributeView(path, JGitHiddenAttributeView.class, options);
            return (A)view.readAttributes();
        }
        if (type == BasicFileAttributesImpl.class || type == BasicFileAttributes.class) {
            JGitBasicAttributeView view = this.getFileAttributeView(path, JGitBasicAttributeView.class, options);
            return (A)view.readAttributes();
        }
        return null;
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotEmpty((String)"attributes", (String)attributes);
        String[] s = this.split(attributes);
        if (s[0].length() == 0) {
            throw new IllegalArgumentException(attributes);
        }
        if (s[0].equals("diff")) {
            String[] branches = s[1].split(",");
            String branchA = branches[0];
            String branchB = branches[1];
            List<FileDiff> diffs = ((JGitFileSystem)((JGitPathImpl)path).getFileSystem()).getGit().diffRefs(branchA, branchB);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("diff", diffs);
            return map;
        }
        ExtendedAttributeView view = this.getFileAttributeView(this.toPathImpl(path), s[0], options);
        if (view == null) {
            throw new UnsupportedOperationException("View '" + s[0] + "' not available");
        }
        return view.readAttributes(s[1].split(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotEmpty((String)"attributes", (String)attribute);
        if (attribute.equals("SQUASH_ATTR") && value instanceof SquashOption) {
            this.lockAndSquash(path, (SquashOption)value);
            return;
        }
        if (attribute.equals(FileSystemState.FILE_SYSTEM_STATE_ATTR)) {
            JGitFileSystem fileSystem = (JGitFileSystem)path.getFileSystem();
            try {
                fileSystem.lock();
                if (value instanceof CommentedOption) {
                    fileSystem.setBatchCommitInfo("Batch mode", (CommentedOption)value);
                    fileSystem.unlock();
                    return;
                }
                boolean isOriginalStateBatch = fileSystem.isOnBatch();
                fileSystem.setState(value.toString());
                FileSystemState.valueOf((String)value.toString());
                if (isOriginalStateBatch && !fileSystem.isOnBatch()) {
                    fileSystem.setBatchCommitInfo(null);
                    this.firePostponedBatchEvents(fileSystem);
                    this.postCommitHook(fileSystem);
                }
                fileSystem.setHadCommitOnBatchState(false);
            }
            finally {
                fileSystem.unlock();
            }
            return;
        }
        String[] s = this.split(attribute);
        if (s[0].length() == 0) {
            throw new IllegalArgumentException(attribute);
        }
        ExtendedAttributeView view = this.getFileAttributeView(this.toPathImpl(path), s[0], options);
        if (view == null) {
            throw new UnsupportedOperationException("View '" + s[0] + "' not available");
        }
        view.setAttribute(s[1], value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockAndSquash(Path path, SquashOption value) {
        JGitFileSystem fileSystem = (JGitFileSystem)path.getFileSystem();
        try {
            fileSystem.lock();
            JGitPathImpl gSource = this.toPathImpl(path);
            String commitMessage = PortablePreconditions.checkNotEmpty((String)"commitMessage", (String)value.getMessage());
            String startCommit = PortablePreconditions.checkNotEmpty((String)"startCommit", (String)value.getRecord().id());
            ((JGitFileSystem)gSource.getFileSystem()).getGit().squash(gSource.getRefTree(), startCommit, commitMessage);
        }
        finally {
            fileSystem.unlock();
        }
    }

    private void checkURI(String paramName, URI uri) throws IllegalArgumentException {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        if (uri.getAuthority() == null || uri.getAuthority().isEmpty()) {
            throw new IllegalArgumentException("Parameter named '" + paramName + "' is invalid, missing host repository!");
        }
        int atIndex = uri.getPath().indexOf("@");
        if (atIndex != -1 && !uri.getAuthority().contains("@") && uri.getPath().indexOf("/", atIndex) == -1) {
            throw new IllegalArgumentException("Parameter named '" + paramName + "' is invalid, missing host repository!");
        }
    }

    public String extractHostForPath(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        int atIndex = uri.getPath().indexOf("@");
        if (atIndex != -1 && !uri.getAuthority().contains("@")) {
            return uri.getAuthority() + uri.getPath().substring(0, uri.getPath().indexOf("/", atIndex));
        }
        return uri.getAuthority();
    }

    private boolean hasSyncFlag(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        return uri.getQuery() != null && uri.getQuery().contains("sync");
    }

    private boolean hasForceFlag(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        return uri.getQuery() != null && uri.getQuery().contains("force");
    }

    private boolean hasPushFlag(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        return uri.getQuery() != null && uri.getQuery().contains("push");
    }

    private static Map<String, String> getQueryParams(URI uri) {
        final String[] params = uri.getQuery().split("&");
        return new HashMap<String, String>(params.length){
            {
                super(x0);
                for (String param : params) {
                    String[] kv = param.split("=");
                    String name = kv[0];
                    String value = kv.length == 2 ? kv[1] : "";
                    this.put(name, value);
                }
            }
        };
    }

    private CredentialsProvider buildCredential(String username, String password) {
        if (username != null) {
            if (password != null) {
                return new UsernamePasswordCredentialsProvider(username, password);
            }
            return new UsernamePasswordCredentialsProvider(username, "");
        }
        return CredentialsProvider.getDefault();
    }

    private JGitPathImpl toPathImpl(Path path) {
        if (path instanceof JGitPathImpl) {
            return (JGitPathImpl)path;
        }
        throw new IllegalArgumentException("Path not supported by current provider.");
    }

    private String[] split(String attribute) {
        String[] s = new String[2];
        int pos = attribute.indexOf(58);
        if (pos == -1) {
            s[0] = "basic";
            s[1] = attribute;
        } else {
            s[0] = attribute.substring(0, pos);
            s[1] = pos == attribute.length() ? "" : attribute.substring(pos + 1);
        }
        return s;
    }

    private int getSchemeSize(URI uri) {
        if (uri.getScheme().equals("git")) {
            return JGitFileSystemProviderConfiguration.SCHEME_SIZE;
        }
        return JGitFileSystemProviderConfiguration.DEFAULT_SCHEME_SIZE;
    }

    private void delete(final JGitPathImpl path, CommitInfo commitInfo) {
        this.commit(path, commitInfo, new DefaultCommitContent((Map<String, File>)new HashMap<String, File>(){
            {
                this.put(path.getPath(), null);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(JGitPathImpl path, CommitInfo commitInfo, CommitContent commitContent) {
        JGitFileSystem fileSystem = (JGitFileSystem)path.getFileSystem();
        try {
            fileSystem.lock();
            Git git = fileSystem.getGit();
            String branchName = path.getRefTree();
            boolean batchState = fileSystem.isOnBatch();
            boolean amend = batchState && fileSystem.isHadCommitOnBatchState(path.getRoot());
            ObjectId oldHead = ((JGitFileSystem)path.getFileSystem()).getGit().getTreeFromRef(branchName);
            boolean hasCommit = batchState && fileSystem.getBatchCommitInfo() != null ? git.commit(branchName, fileSystem.getBatchCommitInfo(), amend, null, commitContent) : git.commit(branchName, commitInfo, amend, null, commitContent);
            if (!batchState) {
                int value;
                if (hasCommit && (value = fileSystem.incrementAndGetCommitCount()) >= this.config.getCommitLimit()) {
                    git.gc();
                    fileSystem.resetCommitCount();
                }
                ObjectId newHead = ((JGitFileSystem)path.getFileSystem()).getGit().getTreeFromRef(branchName);
                this.postCommitHook(fileSystem);
                this.notifyDiffs((JGitFileSystem)path.getFileSystem(), branchName, commitInfo.getSessionId(), commitInfo.getName(), commitInfo.getMessage(), oldHead, newHead);
            } else {
                Object object = this.postponedEventsLock;
                synchronized (object) {
                    String message;
                    String userName;
                    String sessionId;
                    if (fileSystem.getBatchCommitInfo() != null) {
                        sessionId = fileSystem.getBatchCommitInfo().getSessionId();
                        userName = fileSystem.getBatchCommitInfo().getName();
                        message = fileSystem.getBatchCommitInfo().getMessage();
                    } else {
                        sessionId = commitInfo.getSessionId();
                        userName = commitInfo.getName();
                        message = commitInfo.getMessage();
                    }
                    ObjectId newHead = ((JGitFileSystem)path.getFileSystem()).getGit().getTreeFromRef(branchName);
                    List<WatchEvent<?>> postponedWatchEvents = this.compareDiffs((JGitFileSystem)path.getFileSystem(), branchName, sessionId, userName, message, oldHead, newHead);
                    fileSystem.addPostponedWatchEvents(postponedWatchEvents);
                }
            }
            if (((JGitFileSystem)path.getFileSystem()).isOnBatch() && !fileSystem.isHadCommitOnBatchState(path.getRoot())) {
                fileSystem.setHadCommitOnBatchState(path.getRoot(), hasCommit);
            }
        }
        finally {
            fileSystem.unlock();
        }
    }

    private void postCommitHook(JGitFileSystem fileSystem) {
        ProcessResult result = this.detectedFS.runHookIfPresent(fileSystem.getGit().getRepository(), "post-commit", new String[0]);
        if (result.getStatus().equals((Object)ProcessResult.Status.OK)) {
            fileSystem.notifyPostCommit(result.getExitCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePostponedBatchEvents(JGitFileSystem fileSystem) {
        Object object = this.postponedEventsLock;
        synchronized (object) {
            if (fileSystem.hasPostponedEvents()) {
                fileSystem.publishEvents((Path)fileSystem.getRootDirectories().iterator().next(), fileSystem.getPostponedWatchEvents());
            }
            fileSystem.clearPostponedWatchEvents();
            int value = fileSystem.incrementAndGetCommitCount();
            if (value >= this.config.getCommitLimit()) {
                fileSystem.getGit().gc();
                fileSystem.resetCommitCount();
            }
        }
    }

    List<WatchEvent<?>> notifyDiffs(JGitFileSystem fs, String _tree, String sessionId, String userName, String message, ObjectId oldHead, ObjectId newHead) {
        List<WatchEvent<?>> watchEvents = this.compareDiffs(fs, _tree, sessionId, userName, message, oldHead, newHead);
        String tree = _tree.startsWith("refs/") ? _tree.substring(_tree.lastIndexOf("/") + 1) : _tree;
        String host = tree + "@" + fs.getName();
        JGitPathImpl root = JGitPathImpl.createRoot(fs, "/", host, false);
        if (!watchEvents.isEmpty()) {
            fs.publishEvents((Path)root, watchEvents);
        }
        return watchEvents;
    }

    List<WatchEvent<?>> compareDiffs(JGitFileSystem fs, String _tree, String sessionId, String userName, String message, ObjectId oldHead, ObjectId newHead) {
        String tree = _tree.startsWith("refs/") ? _tree.substring(_tree.lastIndexOf("/") + 1) : _tree;
        String host = tree + "@" + fs.getName();
        List<DiffEntry> diff = fs.getGit().listDiffs(oldHead, newHead);
        ArrayList events = new ArrayList(diff.size());
        for (DiffEntry diffEntry : diff) {
            JGitPathImpl newPath;
            JGitPathImpl oldPath = !diffEntry.getOldPath().equals("/dev/null") ? JGitPathImpl.create(fs, "/" + diffEntry.getOldPath(), host, null, false) : null;
            if (!diffEntry.getNewPath().equals("/dev/null")) {
                PathInfo pathInfo = fs.getGit().getPathInfo(tree, diffEntry.getNewPath());
                newPath = JGitPathImpl.create(fs, "/" + pathInfo.getPath(), host, pathInfo.getObjectId(), false);
            } else {
                newPath = null;
            }
            JGitWatchEvent e = new JGitWatchEvent(sessionId, userName, message, diffEntry.getChangeType().name(), (Path)oldPath, (Path)newPath);
            events.add(e);
        }
        return events;
    }

    GitSSHService getGitSSHService() {
        return this.gitSSHService;
    }

    public JGitFileSystemProviderConfiguration getConfig() {
        return this.config;
    }

    public void setDetectedFS(FS detectedFS) {
        this.detectedFS = detectedFS;
    }

    public JGitFileSystemsManager getFsManager() {
        return this.fsManager;
    }

    private static class ExecutorWrapper
    implements Executor {
        private final ExecutorService simpleAsyncExecutor;

        public ExecutorWrapper(ExecutorService simpleAsyncExecutor) {
            this.simpleAsyncExecutor = (ExecutorService)PortablePreconditions.checkNotNull((String)"simpleAsyncExecutor", (Object)simpleAsyncExecutor);
        }

        @Override
        public void execute(Runnable command) {
            this.simpleAsyncExecutor.execute(command);
        }
    }

    public class RepositoryResolverImpl<T>
    implements RepositoryResolver<T> {
        public Repository open(T client, String name) throws RepositoryNotFoundException, ServiceNotAuthorizedException {
            User user = JGitFileSystemProvider.this.extractUser(client);
            JGitFileSystem fs = JGitFileSystemProvider.this.fsManager.get(name);
            if (fs == null) {
                throw new RepositoryNotFoundException(name);
            }
            if (JGitFileSystemProvider.this.authorizer != null && !JGitFileSystemProvider.this.authorizer.authorize((FileSystem)fs, user)) {
                throw new ServiceNotAuthorizedException("User not authorized.");
            }
            return fs.getGit().getRepository();
        }

        public JGitFileSystem resolveFileSystem(Repository repository) {
            return JGitFileSystemProvider.this.fsManager.get(repository);
        }
    }
}

