/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.ws.cluster;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.fs.jgit.ws.cluster.WatchEventsWrapper;

public class JGitEventsBroadcast {
    private static final Logger LOGGER = LoggerFactory.getLogger(JGitEventsBroadcast.class);
    public static final String DEFAULT_APPFORMER_TOPIC = "default-appformer-topic";
    private String nodeId = UUID.randomUUID().toString();
    private Consumer<WatchEventsWrapper> eventsPublisher;
    private final ClusterService clusterService;

    public JGitEventsBroadcast(ClusterService clusterService, Consumer<WatchEventsWrapper> eventsPublisher) {
        this.clusterService = clusterService;
        this.eventsPublisher = eventsPublisher;
        this.setupJMSConnection();
    }

    private void setupJMSConnection() {
        this.clusterService.connect();
    }

    public void createWatchServiceJMS(String topicName) {
        this.clusterService.createConsumer(ClusterService.DestinationType.PubSub, this.getChannelName(topicName), WatchEventsWrapper.class, we -> {
            if (!we.getNodeId().equals(this.nodeId)) {
                this.eventsPublisher.accept((WatchEventsWrapper)we);
            }
        });
    }

    public synchronized void broadcast(String fsName, Path watchable, List<WatchEvent<?>> events) {
        this.clusterService.broadcast(ClusterService.DestinationType.PubSub, this.getChannelName(fsName), (Serializable)new WatchEventsWrapper(this.nodeId, fsName, watchable, events));
    }

    private String getChannelName(String fsName) {
        String channelName = DEFAULT_APPFORMER_TOPIC;
        if (fsName.contains("/")) {
            channelName = fsName.substring(0, fsName.indexOf("/"));
        }
        return channelName;
    }

    public void close() {
        this.clusterService.close();
    }
}

