/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class DataView extends ArrayBufferView {
  public DataView(ArrayBuffer buffer, double byteOffset, double byteLength) {}

  public DataView(ArrayBuffer buffer, double byteOffset) {}

  public DataView(ArrayBuffer buffer) {}

  public native double getFloat32(double byteOffset, boolean littleEndian);

  public native double getFloat32(double byteOffset);

  public native double getFloat64(double byteOffset, boolean littleEndian);

  public native double getFloat64(double byteOffset);

  public native double getInt16(double byteOffset, boolean littleEndian);

  public native double getInt16(double byteOffset);

  public native double getInt32(double byteOffset, boolean littleEndian);

  public native double getInt32(double byteOffset);

  public native double getInt8(double byteOffset);

  public native double getUint16(double byteOffset, boolean littleEndian);

  public native double getUint16(double byteOffset);

  public native double getUint32(double byteOffset, boolean littleEndian);

  public native double getUint32(double byteOffset);

  public native double getUint8(double byteOffset);

  public native void setFloat32(double byteOffset, double value, boolean littleEndian);

  public native void setFloat32(double byteOffset, double value);

  public native void setFloat64(double byteOffset, double value, boolean littleEndian);

  public native void setFloat64(double byteOffset, double value);

  public native void setInt16(double byteOffset, double value, boolean littleEndian);

  public native void setInt16(double byteOffset, double value);

  public native void setInt32(double byteOffset, double value, boolean littleEndian);

  public native void setInt32(double byteOffset, double value);

  public native void setInt8(double byteOffset, double value);

  public native void setUint16(double byteOffset, double value, boolean littleEndian);

  public native void setUint16(double byteOffset, double value);

  public native void setUint32(double byteOffset, double value, boolean littleEndian);

  public native void setUint32(double byteOffset, double value);

  public native void setUint8(double byteOffset, double value);
}
