/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.backend.server.cdi.workspace;

import java.lang.RuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.preferences.shared.annotations.PortablePreference;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.PropertyFormType;
import org.uberfire.preferences.shared.PropertyValidator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Portable( mapSuperTypes = true )
@PortablePreference
@Generated("org.uberfire.ext.preferences.processors.WorkbenchPreferenceProcessor")
/*
* WARNING! This class is generated. Do not modify.
*/
public class WorkspaceManagerPreferencesPortableGeneratedImpl extends WorkspaceManagerPreferences implements BasePreferencePortable<WorkspaceManagerPreferences> {

    public WorkspaceManagerPreferencesPortableGeneratedImpl() {
    }

    public WorkspaceManagerPreferencesPortableGeneratedImpl( @MapsTo("cacheMaximumSize") int cacheMaximumSize, @MapsTo("cacheExpirationTime") int cacheExpirationTime, @MapsTo("cacheExpirationUnit") java.lang.String cacheExpirationUnit ) {
        setCacheMaximumSize( cacheMaximumSize );
        setCacheExpirationTime( cacheExpirationTime );
        setCacheExpirationUnit( cacheExpirationUnit );
    }

    @Override
    public Class<WorkspaceManagerPreferences> getPojoClass() {
        return WorkspaceManagerPreferences.class;
    }

    @Override
    public String identifier() {
        return "WorkspaceManagerPreferences";
    }

    @Override
    public String[] parents() {
        return new String[] { "" };
    }

    @Override
    public String bundleKey() {
        return "WorkspaceManagerPreferences.Label";
    }

    @Override
    public void set( String property, Object value ) {
        if ( property.equals( "cacheMaximumSize" ) ) {
            setCacheMaximumSize( (int) value );
        } else
        if ( property.equals( "cacheExpirationTime" ) ) {
            setCacheExpirationTime( (int) value );
        } else
        if ( property.equals( "cacheExpirationUnit" ) ) {
            setCacheExpirationUnit( (java.lang.String) value );
        } else
        {
            throw new RuntimeException( "Unknown property: " + property );
        }
    }

    @Override
    public Object get( String property ) {
        if ( property.equals( "cacheMaximumSize" ) ) {
            return getCacheMaximumSize();
        } else
        if ( property.equals( "cacheExpirationTime" ) ) {
            return getCacheExpirationTime();
        } else
        if ( property.equals( "cacheExpirationUnit" ) ) {
            return getCacheExpirationUnit();
        } else
        {
            throw new RuntimeException( "Unknown property: " + property );
        }
    }

    @Override
    public Map<String, PropertyFormType> getPropertiesTypes() {
        Map<String, PropertyFormType> propertiesTypes = new HashMap<>();

        propertiesTypes.put( "cacheMaximumSize", PropertyFormType.TEXT);
        propertiesTypes.put( "cacheExpirationTime", PropertyFormType.TEXT);
        propertiesTypes.put( "cacheExpirationUnit", PropertyFormType.TEXT);

        return propertiesTypes;
    }

    @Override
    public Map<String, List<PropertyValidator>> getPropertiesValidators() {
        Map<String, List<PropertyValidator>> validatorsByProperty = new HashMap<>();


        return validatorsByProperty;
    }

    @Override
    public boolean equals( final Object o ) {
        if ( this == o ) {
            return true;
        }
        if ( o == null || getClass() != o.getClass() ) {
            return false;
        }

        final WorkspaceManagerPreferencesPortableGeneratedImpl that = (WorkspaceManagerPreferencesPortableGeneratedImpl) o;

        if ( getCacheMaximumSize() != that.getCacheMaximumSize() ) {
            return false;
        }
        if ( getCacheExpirationTime() != that.getCacheExpirationTime() ) {
            return false;
        }
        if ( getCacheExpirationUnit() != null ? !getCacheExpirationUnit().equals( that.getCacheExpirationUnit() ) : that.getCacheExpirationUnit() != null ) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;

        result = 31 * result + java.lang.Integer.hashCode( getCacheMaximumSize() );
        result = ~~result;
        result = 31 * result + java.lang.Integer.hashCode( getCacheExpirationTime() );
        result = ~~result;
        result = 31 * result + ( getCacheExpirationUnit() != null ? getCacheExpirationUnit().hashCode() : 0 );
        result = ~~result;

        return result;
    }

    @Override
    public boolean isPersistable() {
        return true;
    }
}
